/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dbps.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherDBPSMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEDBPSDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger LOGGER = TELogFactory.getNormalLogger();

    private TEDBPSDbMgr() {
    }

    public static TEEtherDBPSMOPO getEtherDBPSMOFromDB(int neID, int dbpsNo, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEDBPSDbMgr.getEtherDBPSMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEDBPSDbMgr.getEtherDBPSMOFromDB");
        if (null == errRet) {
            return null;
        }
        TEEtherDBPSMOPO moObject = null;
        TEDaoOperationResult dsoOperResult = null;
        try {
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
            criteria.add(new TEDaoNameValuePair("DbpsID", String.valueOf(dbpsNo)));
            dsoOperResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEEtherDBPSMOPO.class, criteria);
        }
        catch (Exception e) {
            TEDBPSDbMgr.logExceptionOnGet(neID, e);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getEtherDBPSMOFromDB");
            return moObject;
        }
        if (null == dsoOperResult) {
            TEDBPSDbMgr.logNullErrorOnGet(neID);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getEtherDBPSMOFromDB");
            return moObject;
        }
        int retCode = dsoOperResult.getResult();
        if (1090613273 == retCode) {
            TEDBPSDbMgr.logNullNEError(neID);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1090596385);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getEtherDBPSMOFromDB");
            return moObject;
        }
        if (0 == retCode) {
            List data = dsoOperResult.getData();
            if (null != data && !data.isEmpty()) {
                moObject = (TEEtherDBPSMOPO)data.get(0);
            }
        } else {
            TEDBPSDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEDBPSDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getEtherDBPSMOFromDB");
        return moObject;
    }

    public static List<TEEtherDBPSMOPO> getAllEtherDBPSMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEDBPSDbMgr.getAllEtherDBPSMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEDBPSDbMgr.getAllEtherDBPSMOFromDB");
        if (null == errRet) {
            return new ArrayList<TEEtherDBPSMOPO>(0);
        }
        ArrayList<Object> moObject = new ArrayList<TEEtherDBPSMOPO>(0);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.findAll((int)neID, (int[])new int[]{neID}, TEEtherDBPSMOPO.class);
        }
        catch (Exception e) {
            TEDBPSDbMgr.logExceptionOnGet(neID, e);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getAllEtherDBPSMOFromDB");
            return moObject;
        }
        if (null == dbResult) {
            TEDBPSDbMgr.logNullErrorOnGet(neID);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getAllEtherDBPSMOFromDB");
            return moObject;
        }
        int retCode = dbResult.getResult();
        if (1090613273 == retCode) {
            TEDBPSDbMgr.logNullNEError(neID);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1090596385);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getAllEtherDBPSMOFromDB");
            return moObject;
        }
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moObject = new ArrayList(data.size());
                for (Object obj : data) {
                    moObject.add((TEEtherDBPSMOPO)obj);
                }
            }
        } else {
            TEDBPSDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEDBPSDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.getAllEtherDBPSMOFromDB");
        return moObject;
    }

    public static void createOrUpdateEtherDBPSMOToDB(int neID, TEEtherDBPSMOPO dbpsMO, TEErrInfoReturn errRet, boolean updateFlag) {
        String FUNC_NAME = "TEDBPSDbMgr.createOrUpdateEtherDBPSMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEDBPSDbMgr.createOrUpdateEtherDBPSMOToDB");
        if (null == dbpsMO) {
            return;
        }
        if (null == errRet) {
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = updateFlag ? TECommonDaoService.update((int)neID, (int[])new int[]{neID}, (Object)dbpsMO) : TECommonDaoService.create((int)neID, (int[])new int[]{neID}, (Object)dbpsMO);
        }
        catch (Exception e) {
            TEDBPSDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.createOrUpdateEtherDBPSMOToDB");
            return;
        }
        if (null == dbResult) {
            TEDBPSDbMgr.logNullErrorOnUpdate(neID);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.createOrUpdateEtherDBPSMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEDBPSDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEDBPSDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.createOrUpdateEtherDBPSMOToDB");
    }

    public static void delDBPSMOToDB(int neID, TEEtherDBPSMOPO dbpsMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEDBPSDbMgr.delDBPSMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEDBPSDbMgr.delDBPSMOToDB");
        if (null == dbpsMO) {
            return;
        }
        if (null == errRet) {
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.delete((int)neID, (int[])new int[]{neID}, (Object)dbpsMO);
        }
        catch (Exception e) {
            TEDBPSDbMgr.logExceptionErrorOnDel(neID, e);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.delDBPSMOToDB");
            return;
        }
        if (null == dbResult) {
            TEDBPSDbMgr.logNullErrorOnDel(neID);
            TEDBPSDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.delDBPSMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEDBPSDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEDBPSDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEDBPSDbMgr.delDBPSMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEDBPSDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEDBPSDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEDBPSDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        LOGGER.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        LOGGER.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        LOGGER.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        LOGGER.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        LOGGER.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnDel(int neID) {
        LOGGER.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        LOGGER.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }
}

