/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.dbps;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.TENGWDMIPUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TEDBPSGetAvailPortBean
extends TENEExplorerBean {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private int slotId = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams row = new RowParams();
        Param param = new Param("portid", "");
        row.addParam(param);
        RowParams rowParam = inputData.getBussinessParams().getRowParams(0);
        this.slotId = Integer.parseInt(rowParam.getParam("slotid").getValue());
        int boardType = this.mgr.getBoardType(neid, this.slotId);
        String boardName = this.mgr.getBoardTypeName(neid, boardType);
        String portType = rowParam.getParam("porttype").getValue();
        List portList = this.getPortList(portType, boardType);
        StringBuffer sb = null;
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            sb = new StringBuffer();
            sb.append(this.slotId).append("-");
            sb.append(boardName).append("-");
            Integer portId = (Integer)portList.get(i);
            sb.append(portId).append("-");
            sb.append(TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)this.slotId)).append("-");
            sb.append(TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)this.slotId)).append("-");
            sb.append(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)this.slotId));
            param.addOption(new Option(sb.toString()));
        }
        this.outputData.getBussinessParams().addRowParams(row);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.outputData;
    }

    private List getPortList(String portType, int boardType) {
        if ("ip".equalsIgnoreCase(portType)) {
            if (TENGWDMIPUtil.isLEM18Board((int)boardType) || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_OSN_DBPS", "OTN_ATTR_SUPPORT_DBPS_LIKELEM18")) {
                int boardMode = TEGetBoardMode.queryBoardMode((int)this.neid, (int)this.slotId);
                return TENGWDMIPUtil.getMACPortList((int)this.neid, (int)this.slotId, (int)boardType, (int)boardMode);
            }
            return this.getIpPortList(boardType);
        }
        if ("vctrunk".equalsIgnoreCase(portType)) {
            return this.getVctrunkPortList(boardType);
        }
        if (TENGWDMIPUtil.isLEM18Board((int)boardType) || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_OSN_DBPS", "OTN_ATTR_SUPPORT_DBPS_LIKELEM18")) {
            return TENGWDMIPUtil.getEthPortList((int)this.neid, (int)this.slotId, (int)boardType);
        }
        List retList = this.getIpPortList(boardType);
        retList.addAll(this.getVctrunkPortList(boardType));
        return retList;
    }

    private List getIpPortList(int boardType) {
        ArrayList supportportList = new ArrayList(new HashSet(this.mgr.getSupportedDynPortList(this.neid, boardType)));
        ArrayList logicportList = this.mgr.getLogicPortList(this.neid, this.slotId);
        ArrayList<Integer> portList = new ArrayList<Integer>();
        int m = supportportList.size();
        for (int i = 0; i < m; ++i) {
            Integer portid = (Integer)supportportList.get(i);
            int portType = this.mgr.getPortType(this.neid, boardType, portid.intValue());
            if (logicportList.size() != 0 && !logicportList.contains(portid) || 1025 != portType) continue;
            portList.add(portid);
        }
        Collections.sort(portList);
        return portList;
    }

    private List getVctrunkPortList(int boardType) {
        return this.mgr.getETHVCTrunkPort(this.neid, this.slotId, boardType);
    }
}

