/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp.db.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockPort;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.ngwdm.clockptp.db.TEBeanObserverIF;
import com.huawei.nglct.nemgr.ngwdm.e2e.db.TEPTPClockDBMgr;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPMOConverter;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryPortStatusBeanObserver
implements TEBeanObserverIF {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void operSaveDBAfterSendMessage(int neID, int cmdID, List<Operation> operationList) {
    }

    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode && 1 != retCode) {
            this.logBeanOperError(neID, retCode);
            TEPTPClockUtil.printRowError(outputData);
            return;
        }
        boolean isNullPort = false;
        RowParams[] rowParamsArr = new RowParams[]{};
        if (null == outputData.getBussinessParams()) {
            this.logNullBussinessParamsError();
            isNullPort = true;
        }
        if (null != outputData.getBussinessParams() && 0 == outputData.getBussinessParams().getRowParamsCount()) {
            this.logNullRowParamsError();
            isNullPort = true;
        }
        if (!isNullPort) {
            rowParamsArr = outputData.getBussinessParams().getRowParams();
        }
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEPTPClockPropertyMOPO moDevice = TEPTPClockDBMgr.getClockDeviceFromDB(neID, errRet);
        TEE2EClockDevice dataDevice = null;
        if (null == moDevice) {
            dataDevice = TEPTPBuildClock.buildClockDevice(neID);
            TEQueryPortStatusBeanObserver.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            errRet = new TEErrInfoReturn();
            TEPTPClockDBMgr.createClockDeviceToDB(neID, dataDevice, errRet);
        } else {
            dataDevice = TEPTPMOConverter.mo2DataDevice(neID, moDevice);
            TEPTPBuildClock.clearPtpPort(dataDevice);
            TEQueryPortStatusBeanObserver.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            errRet = new TEErrInfoReturn();
            TEPTPClockDBMgr.updateClockDeviceToDB(neID, dataDevice, errRet);
        }
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams[] rowParamsArr) {
        RowParams rowParams2 = null;
        TEPTPBuildClock.clearPtpPort(device);
        for (RowParams rowParams2 : rowParamsArr) {
            if (0 != rowParams2.getRowErrorsCount()) continue;
            int slotID = TEPTPClockUtil.getIntParam(rowParams2, "slotid", -1);
            int portID = TEPTPClockUtil.getIntParam(rowParams2, "port", -1);
            portID = TEConfigurationDataMgr.getPortRelativeID((int)portID);
            int portstatus = TEPTPClockUtil.getIntParam(rowParams2, "portrealstatus", -1);
            int portworkmode = TEPTPClockUtil.getIntParam(rowParams2, "portworkmode", -1);
            TEE2EClockPort clockPort = TEPTPBuildClock.buildClockPortList(neID, slotID, portID, portworkmode, portstatus);
            device.getClockPortList().add(clockPort);
            TEE2EClockSource clock = TEPTPBuildClock.buildClockSource(neID, slotID, portID, 2);
            device.getClockSourceList().add(clock);
        }
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    private void logBeanOperError(int neID, int retCode) {
        String tipStr = String.format("bean oper error! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private void logNullBussinessParamsError() {
        e2eLogger.error("bussinessparams is null!");
    }

    private void logNullRowParamsError() {
        e2eLogger.error("rowparams is null!");
    }
}

