/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp.db.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockDevice;
import com.huawei.nglct.nemgr.e2e.task.clock.model.TEE2EClockSource;
import com.huawei.nglct.nemgr.ngwdm.clockptp.db.TEBeanObserverIF;
import com.huawei.nglct.nemgr.ngwdm.e2e.db.TEPTPClockDBMgr;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPBuildClock;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.e2e.util.TEPTPMOConverter;
import com.huawei.nglct.po.embeddednemgrmo.otn.ptpclock.TEPTPClockPropertyMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryOuterBaseAttrBeanObserver
implements TEBeanObserverIF {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void operSaveDBAfterSendMessage(int neID, int cmdID, List<Operation> operationList) {
    }

    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (null == outputData) {
            return;
        }
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode && 1 != retCode) {
            this.logBeanOperError(neID, retCode);
            TEPTPClockUtil.printRowError(outputData);
        }
        if (null == outputData.getBussinessParams()) {
            this.logNullBussinessParamsError();
            return;
        }
        if (0 == outputData.getBussinessParams().getRowParamsCount()) {
            this.logNullRowParamsError();
            return;
        }
        RowParams[] rowParamsArr = outputData.getBussinessParams().getRowParams();
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        TEPTPClockPropertyMOPO moDevice = TEPTPClockDBMgr.getClockDeviceFromDB(neID, errRet);
        TEE2EClockDevice dataDevice = null;
        if (null == moDevice) {
            dataDevice = TEPTPBuildClock.buildClockDevice(neID);
            TEQueryOuterBaseAttrBeanObserver.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            errRet = new TEErrInfoReturn();
            TEPTPClockDBMgr.createClockDeviceToDB(neID, dataDevice, errRet);
        } else {
            dataDevice = TEPTPMOConverter.mo2DataDevice(neID, moDevice);
            TEPTPBuildClock.clearOuterClock(dataDevice);
            TEQueryOuterBaseAttrBeanObserver.parseAttributeFromRowParams(neID, dataDevice, rowParamsArr);
            errRet = new TEErrInfoReturn();
            TEPTPClockDBMgr.updateClockDeviceToDB(neID, dataDevice, errRet);
        }
    }

    public static void parseAttributeFromRowParams(int neID, TEE2EClockDevice device, RowParams[] rowParamsArr) {
        if (null == rowParamsArr || 0 == rowParamsArr.length) {
            return;
        }
        RowParams rowParams2 = null;
        HashSet<TEE2EClockSource> outerClockSet = new HashSet<TEE2EClockSource>();
        for (RowParams rowParams2 : rowParamsArr) {
            if (0 != rowParams2.getRowErrorsCount()) continue;
            int subslotid = TEPTPClockUtil.getIntParam(rowParams2, "subslotid", -1);
            int slotID = TEPTPClockUtil.getIntParam(rowParams2, "slotid", -1);
            int portID = TEPTPClockUtil.getIntParam(rowParams2, "port", -1);
            if (-1 == subslotid || -1 == slotID || -1 == portID) continue;
            TEE2EClockSource clock = TEPTPBuildClock.buildClockSource(neID, slotID, portID, 3);
            outerClockSet.add(clock);
        }
        device.getClockSourceList().addAll(outerClockSet);
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    private void logBeanOperError(int neID, int retCode) {
        String tipStr = String.format("bean oper error! neID:%d, retCode:%d", neID, retCode);
        e2eLogger.error(tipStr);
    }

    private void logNullBussinessParamsError() {
        e2eLogger.error("bussinessparams is null!");
    }

    private void logNullRowParamsError() {
        e2eLogger.error("rowparams is null!");
    }
}

