/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp.beanplugin.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.mstp.TEClockBasicInfoMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TESrcModeDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TESrcModeDbMgr() {
    }

    public static TEClockBasicInfoMOPO getMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TESrcModeDbMgr.getMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TESrcModeDbMgr.getMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEClockBasicInfoMOPO moDevice = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TESrcModeDbMgr.logNullNEError(neID);
                TESrcModeDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.getMOFromDB");
                return moDevice;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEClockBasicInfoMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEClockBasicInfoMOPO.class);
        }
        catch (Exception e) {
            TESrcModeDbMgr.logExceptionOnGet(neID, e);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.getMOFromDB");
            return moDevice;
        }
        if (null == dbResult) {
            TESrcModeDbMgr.logNullErrorOnGet(neID);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.getMOFromDB");
            return moDevice;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moDevice = (TEClockBasicInfoMOPO)data.get(0);
            }
        } else {
            TESrcModeDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TESrcModeDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.getMOFromDB");
        return moDevice;
    }

    public static void updateMOToDB(int neID, TEClockBasicInfoMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TESrcModeDbMgr.updateMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TESrcModeDbMgr.updateMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TESrcModeDbMgr.logExceptionErrorOnUpdate(neID, e);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.updateMOToDB");
            return;
        }
        if (null == dbResult) {
            TESrcModeDbMgr.logNullErrorOnUpdate(neID);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.updateMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TESrcModeDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TESrcModeDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.updateMOToDB");
    }

    public static void createMOToDB(int neID, TEClockBasicInfoMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TESrcModeDbMgr.createMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TESrcModeDbMgr.createMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TESrcModeDbMgr.logExceptionErrorOnCreate(neID, e);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.createMOToDB");
            return;
        }
        if (null == dbResult) {
            TESrcModeDbMgr.logNullErrorOnCreate(neID);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.createMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TESrcModeDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TESrcModeDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.createMOToDB");
    }

    public static void delMOToDB(int neID, TEClockBasicInfoMOPO modeMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TESrcModeDbMgr.delMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TESrcModeDbMgr.delMOToDB");
        if (null == modeMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResultMode = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResultMode = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)modeMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)modeMO);
        }
        catch (Exception e1) {
            TESrcModeDbMgr.logExceptionErrorOnDel(neID, e1);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.delMOToDB");
            return;
        }
        if (null == dbResultMode) {
            TESrcModeDbMgr.logNullErrorOnDel(neID);
            TESrcModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.delMOToDB");
            return;
        }
        int retCode = dbResultMode.getResult();
        if (0 != retCode) {
            TESrcModeDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TESrcModeDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TESrcModeDbMgr.delMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCodeMode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TESrcModeDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCodeMode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCodeMode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TESrcModeDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCodeMode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCodeMode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TESrcModeDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCodeMode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objNameMode) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objNameMode.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objNameMode[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCodeMode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCodeMode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e1) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e1);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCodeMode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCodeMode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e1) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e1);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e1) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)e1);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCodeMode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCodeMode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e1) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)e1);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCodeMode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCodeMode);
        logger.error(tipStr);
    }
}

