/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clockptp.PTPClockUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEUsableBoardPortResource {
    private int slotID = -1;
    private int boardType = 0;
    private String boardName;
    private int subboardId = -1;
    private String subboardName;
    private ArrayList portidList = null;
    private ArrayList portNameList = null;
    private static final int HASHCODE_MULTIPLIED = 37;
    private static final int HASHCODE_INITVALUE = 17;

    public TEUsableBoardPortResource(int slotID, String boardName, int subboardId, String subboardName, ArrayList portidList, ArrayList portNameList) {
        this.slotID = slotID;
        this.boardName = boardName;
        this.subboardId = subboardId;
        this.subboardName = subboardName;
        this.portidList = portidList;
        this.portNameList = portNameList;
    }

    public static int getPTPEnableResList(int neID, ArrayList usableResourceList) {
        return PTPClockUtil.getPortResList(neID, usableResourceList, PTPClockUtil.PTP_PORT_RES_CfgFile, 1);
    }

    public static ArrayList getBoardPortList(int neID, TEBoard board) {
        if (null == board) {
            return null;
        }
        ArrayList existPortList = null;
        int boardType = board.getBoardType();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        if (mgr.isDynPortBoardType(neID, boardType)) {
            existPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(neID, board.getSlotID());
        }
        if (null == existPortList || existPortList.isEmpty()) {
            return mgr.getBoardPortList(neID, boardType);
        }
        return existPortList;
    }

    public static ArrayList getExistPortList(int neID, int slotID, String invalid_subSoltID) {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_SUBBD_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotID));
            input.setPartValue("subslotid", invalid_subSoltID);
            input.setPartValue("port", "0");
            operationList.add(oper);
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            if (operationList.size() == 0) {
                return returnList;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (result == 0) {
                Operation oOperation = (Operation)operationList.get(0);
                for (Output output : oOperation.getOutput()) {
                    if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                    String portId = output.getPartValue("port");
                    returnList.add(Integer.valueOf(portId));
                }
            }
            return returnList;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public static Datainterface constructOutput(int neID, ArrayList usablePortResourceList, String user, String ipAddress) {
        Datainterface outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        int size = usablePortResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableBoardPortResource res = (TEUsableBoardPortResource)usablePortResourceList.get(i);
            RowParams rowParams = new RowParams();
            Param param = null;
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)res.getSlotID());
            if (subrack != null && !subrack.equals("")) {
                param = new Param("subrack", subrack);
                rowParams.addParam(param);
            }
            param = new Param("slotid", "" + res.getSlotID());
            rowParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rowParams.addParam(param);
            param = new Param("subslotid", "" + res.getSubslotID());
            rowParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rowParams.addParam(param);
            String supptpPri = ClockUtil.supPTPClockSourceMap.get(String.valueOf(res.getBoardType()));
            String suppDomain = ClockUtil.suppClockDomainMap.get(String.valueOf(res.getBoardType()));
            if (supptpPri == null) {
                supptpPri = "N";
            }
            if (suppDomain == null) {
                suppDomain = "F";
            }
            param = new Param("supportPTPPri", supptpPri);
            rowParams.addParam(param);
            param = new Param("supportDomain", suppDomain);
            rowParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rowParams.addParam(param);
            param = new Param("portName", (String)res.getPortNameList().get(0));
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rowParams.addParam(param);
            bussinessParams.addRowParams(rowParams);
        }
        outputData.setBussinessParams(bussinessParams);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        return outputData;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setBoardName(String name) {
        this.boardName = name;
    }

    public void setPortidList(ArrayList portidList) {
        this.portidList = portidList;
    }

    public void setPortNameList(ArrayList portNameList) {
        this.portNameList = portNameList;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public String getBoardName() {
        return this.boardName;
    }

    public int getSubslotID() {
        return this.subboardId;
    }

    public String getSubboardName() {
        return this.subboardName;
    }

    public ArrayList getPortidList() {
        return this.portidList;
    }

    public ArrayList getPortNameList() {
        return this.portNameList;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.slotID;
        result = 37 * result + this.subboardId;
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TEUsableBoardPortResource)) {
            return false;
        }
        TEUsableBoardPortResource resource = (TEUsableBoardPortResource)o;
        int slotCompare = this.slotID - resource.slotID;
        if (0 != slotCompare) {
            return false;
        }
        if (0 != this.subboardId - resource.subboardId) {
            return false;
        }
        return this.boardName.equals(resource.boardName);
    }

    public int getBoardType() {
        return this.boardType;
    }

    public void setBoardType(int boardType) {
        this.boardType = boardType;
    }

    public String toString() {
        return "\nslotID=" + this.slotID + ",portidList=" + this.portidList;
    }
}

