/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ngwdm.clockptp.PTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clockptp.Port;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEUsableBoardPortResource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryTransWarpBean
extends TENEClockWriteLogBean {
    private ArrayList usableResourceList = new ArrayList();

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        if (0 != TEUsableBoardPortResource.getPTPEnableResList(neid, this.usableResourceList)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        this.operationList = this.constructOperationList(subFunc);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int ret = this.sendMessage(neid, subFunc);
        if (ret == 0) {
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)ret));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errCodeList = new ArrayList<Integer>();
        errCodeList.add(43216);
        errCodeList.add(38737);
        errCodeList.add(43219);
        return errCodeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        BussinessParams params = this.outputData.getBussinessParams();
        if (params == null) {
            return;
        }
        int size = params.getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            int slotid;
            String subrack;
            RowParams param = params.getRowParams(i);
            if (param.getParam("slotid") == null || (subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)(slotid = Integer.parseInt(param.getParam("slotid").getValue())))) == null || subrack.equals("")) continue;
            param.addParam(new Param("subrack", subrack));
        }
    }

    private ArrayList constructOperationList(SubFunc subFunc) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        ArrayList portList = PTPClockUtil.getPTPEnablePorts(this.neid, this.getTimeOut(), subFunc, this.usableResourceList);
        if (null == portList || portList.size() == 0) {
            return null;
        }
        for (int i = portList.size() - 1; i >= 0; --i) {
            Port portRes = (Port)portList.get(i);
            String slotid = portRes.soltid;
            String subslotid = portRes.subboradid;
            String portid = portRes.portid;
            Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTP_LINEWARP");
            Input input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
        }
        return operList;
    }
}

