/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ngwdm.clockptp.PTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryTransDistanceBean
extends TENEClockWriteLogBean {
    @Override
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList<String> portList = new ArrayList<String>();
        portList.add("2");
        portList.add("4");
        this.operationList = PTPClockUtil.getQueryOutTimePortLinkOperation(this.neid, portList);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        int result = this.sendMessage(this.neid, this.operationList);
        ArrayList<String> board_port_list = null;
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        board_port_list = this.getOuterTimeResList(this.neid, this.operationList, this.subfunc);
        this.operationList = this.getOperation(this.neid, board_port_list);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        result = this.sendMessage(this.neid, this.operationList);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        this.handleMessage(this.neid, this.operationList, this.subfunc, this.getFilterErrorCodeList());
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        RowParams row = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            int slotid;
            String subrack;
            row = rows[i];
            if (row.getRowErrorsCount() > 0 || (subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)(slotid = Integer.parseInt(row.getParam("slotid").getValue())))).equals("")) continue;
            row.addParam("subrack", subrack);
        }
    }

    public ArrayList getOperation(int neid, ArrayList<String> board_port_list) {
        String opertionStr = "NSCMD_CFG_GET_PTP_CABLELENGTH";
        ArrayList<Object> operlist = new ArrayList<Object>();
        try {
            if (null == board_port_list || board_port_list.size() == 0) {
                return null;
            }
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)opertionStr);
            Input input = oper.getInput();
            for (int i = board_port_list.size() - 1; i >= 0; --i) {
                String[] strArr = board_port_list.get(i).split(",");
                input.setPartValue("slotid", strArr[0]);
                input.setPartValue("subslotid", "255");
                input.setPartValue("port", strArr[1]);
                if (strArr[2].equals("1") || strArr[2].equals("0")) {
                    input.setPartValue("trandirection", "0");
                    operlist.add(oper.clone());
                }
                if (!strArr[2].equals("0")) continue;
                input.setPartValue("trandirection", "1");
                operlist.add(oper.clone());
            }
            return operlist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private ArrayList<String> getOuterTimeResList(int neid, ArrayList operationList, SubFunc subfunc) {
        ArrayList<String> board_port_list = new ArrayList<String>();
        Operation operation = null;
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            Output[] outputs = operation.getOutput();
            Output output = null;
            int listlen = operation.getOutputCount();
            for (int i = 0; i < listlen; ++i) {
                String res;
                if (!outputs[i].getFault(0).getCode().equals("0") || board_port_list.contains(res = (output = outputs[i]).getPartValue("slotid") + "," + output.getPartValue("port") + "," + output.getPartValue("enablestatus"))) continue;
                board_port_list.add(res);
            }
        }
        return board_port_list;
    }
}

