/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.clockptp.db.TEPTPClockDBMgrBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryPriorityBean
extends TEPTPClockDBMgrBean {
    private static final int EMPTY_RESULT = 38662;
    private static final int MODE_ISNOT_TCOC = 43219;
    private TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
    private ArrayList<String> ptpClocksource = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation tmpOper = (Operation)operationList.get(0);
        operationList.clear();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        Output[] outputArr = tmpOper.getOutput();
        this.ptpClocksource.clear();
        for (Output output : outputArr) {
            for (Fault fault : output.getFault()) {
                int code = Integer.parseInt(fault.getCode());
                if (code == 38662) {
                    BussinessParams bussinessParam = new BussinessParams();
                    this.outputData.setBussinessParams(bussinessParam);
                    this.addInnerClockSource(bussinessParam);
                    return;
                }
                if (code != 43219) continue;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)43219));
                return;
            }
            if (Integer.parseInt(output.getPart("srcount").getValue()) <= 0) {
                return;
            }
            BussinessParams bussinessParam = new BussinessParams();
            this.outputData.setBussinessParams(bussinessParam);
            RowParams rowparam = null;
            Param param = null;
            Part part = output.getPart("priorityData");
            byte[] bValue = part.getValue().getBytes();
            int stepLength = 30;
            int startIndex = 0;
            while (startIndex + stepLength <= bValue.length) {
                String subrack;
                rowparam = new RowParams();
                param = null;
                byte[] bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 0, bTmp, 0, 4);
                int slotid = this.getNMSlotID(bTmp);
                param = new Param("slotid", slotid + "");
                rowparam.addParam(param);
                int boardType = this.configurDataMgr.getBoard(neid, slotid).getBoardType();
                if (this.isNGWDMDomain(neid) && (subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid)) != null && !subrack.equals("")) {
                    param = new Param("subrack", subrack);
                    rowparam.addParam(param);
                }
                String boardName = this.configurDataMgr.getBoardTypeName(neid, boardType);
                param = new Param("boardname", boardName);
                rowparam.addParam(param);
                bTmp = new byte[2];
                System.arraycopy(bValue, startIndex + 4, bTmp, 0, 2);
                int subslotid = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                param = new Param("subslotid", subslotid + "");
                rowparam.addParam(param);
                bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 6, bTmp, 0, 4);
                int port = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                param = new Param("port", port + "");
                rowparam.addParam(param);
                String portName = this.configurDataMgr.getPortName(neid, slotid, boardType, port);
                param = new Param("portname", portName);
                rowparam.addParam(param);
                bTmp = new byte[8];
                System.arraycopy(bValue, startIndex + 10, bTmp, 0, 8);
                String tempHigh = this.byteArr2HexStr(bTmp);
                param = new Param("srcidhigh", tempHigh);
                rowparam.addParam(param);
                bTmp = new byte[8];
                System.arraycopy(bValue, startIndex + 18, bTmp, 0, 8);
                String tempLow = this.byteArr2HexStr(bTmp);
                param = new Param("srcidlow", tempLow);
                rowparam.addParam(param);
                this.ptpClocksource.add(tempHigh + "-" + tempLow);
                bTmp = new byte[4];
                System.arraycopy(bValue, startIndex + 26, bTmp, 0, 4);
                param = new Param("interfaceid", this.byteArr2HexStr(bTmp));
                rowparam.addParam(param);
                bussinessParam.addRowParams(rowparam);
                startIndex += stepLength;
            }
            this.addInnerClockSource(bussinessParam);
        }
    }

    private int getNMSlotID(byte[] tmp) {
        int nmSlotid = -1;
        if (this.isNGWDMDomain(this.neid)) {
            byte[] bTmpShelf = new byte[2];
            System.arraycopy(tmp, 0, bTmpShelf, 0, 2);
            int shelfId = IOStreamConvertor.readPositiveShort((byte[])bTmpShelf, (int)0);
            byte[] bTmpSlot = new byte[2];
            System.arraycopy(tmp, 2, bTmpSlot, 0, 2);
            int neSlotId = IOStreamConvertor.readPositiveShort((byte[])bTmpSlot, (int)0);
            nmSlotid = TEBoardUtil.neToSlotIDNM((int)shelfId, (int)neSlotId);
        } else {
            nmSlotid = IOStreamConvertor.readPositiveInt((byte[])tmp, (int)0);
        }
        return nmSlotid;
    }

    private boolean isNGWDMDomain(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String domain = TEGetNEDomainVersion.getInstance().getDomain(ne.getNEType());
        return domain.equalsIgnoreCase("ngwdm") || domain.equalsIgnoreCase("wdm");
    }

    private void addInnerClockSource(BussinessParams bussinessParam) {
        RowParams rowparam = new RowParams();
        Param param = new Param("boardname", "0");
        rowparam.addParam(param);
        bussinessParam.addRowParams(rowparam);
    }

    private String byteArr2HexStr(byte[] b) {
        StringBuffer str = new StringBuffer();
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            str.append((char)b[i]);
        }
        return str.toString();
    }

    public int getClockSourcePri(String clock) {
        int size = this.ptpClocksource.size();
        for (int i = 0; i < size; ++i) {
            if (!this.ptpClocksource.get(i).equalsIgnoreCase(clock)) continue;
            return i + 1;
        }
        return -1;
    }
}

