/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.clockptp.PTPClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clockptp.Port;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEUsableBoardPortResource;
import com.huawei.nglct.nemgr.ngwdm.clockptp.db.TENEOperWrapper;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEQueryPortMessageBean
extends TENEClockWriteLogBean {
    private ArrayList usableResourceList = new ArrayList();

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TENEOperWrapper.addWnemgrBusClassMapping(subFunc);
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        if (0 != TEUsableBoardPortResource.getPTPEnableResList(neid, this.usableResourceList)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        this.operationList = this.constructOperationList(subFunc);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid, subFunc);
        if (result == 0) {
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private ArrayList constructOperationList(SubFunc subFunc) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        ArrayList portList = PTPClockUtil.getPTPEnablePorts(this.neid, this.getTimeOut(), subFunc, this.usableResourceList);
        if (null == portList || portList.size() == 0) {
            return null;
        }
        for (int i = portList.size() - 1; i >= 0; --i) {
            Port portRes = (Port)portList.get(i);
            String slotid = portRes.soltid;
            String subslotid = portRes.subboradid;
            String portid = portRes.portid;
            Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPPEMODE");
            Input input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPSYNCCYCLE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPDELAYCYCLE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPPDELAYCYCLE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPANNCYCLE");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_PTPANNTIMEOUT");
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("subslotid", subslotid);
            input.setPartValue("port", portid);
            operList.add(operation);
        }
        return operList;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errCodeList = new ArrayList<Integer>();
        errCodeList.add(43216);
        errCodeList.add(38737);
        errCodeList.add(43219);
        return errCodeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        int num = 0;
        if (null != rows) {
            num = rows.length;
        }
        for (int i = 0; i < num; ++i) {
            boolean isSDHLineBoard;
            byte cycleByte;
            String cycle;
            RowParams row = rows[i];
            if (row.getRowErrorsCount() > 0) continue;
            String slotid = row.getParam("slotid").getValue();
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)Integer.parseInt(slotid));
            if (subrack != null) {
                row.addParam(new Param("subrack", subrack));
            }
            if (!(cycle = row.getParam("syncycle").getValue()).equals("")) {
                cycleByte = Integer.valueOf(cycle).byteValue();
                row.getParam("syncycle").setValue(String.valueOf(cycleByte));
            }
            if (!(cycle = row.getParam("anncycle").getValue()).equals("")) {
                cycleByte = Integer.valueOf(cycle).byteValue();
                row.getParam("anncycle").setValue(String.valueOf(cycleByte));
            }
            if (!(cycle = row.getParam("delaycycle").getValue()).equals("")) {
                cycleByte = Integer.valueOf(cycle).byteValue();
                row.getParam("delaycycle").setValue(String.valueOf(cycleByte));
            }
            if (!(cycle = row.getParam("pdelaycycle").getValue()).equals("")) {
                cycleByte = Integer.valueOf(cycle).byteValue();
                row.getParam("pdelaycycle").setValue(String.valueOf(cycleByte));
            }
            if ((isSDHLineBoard = TEConfigurationDataMgr.getInstance().isSDHLineBoard(neid, Integer.parseInt(slotid))) && 1557 != TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.valueOf(slotid).intValue())) {
                row.getParam("pemode").setValue("-1");
                continue;
            }
            cycle = row.getParam("pemode").getValue();
            if (cycle.equals("")) continue;
            cycleByte = Integer.valueOf(cycle).byteValue();
            row.getParam("pemode").setValue(String.valueOf(cycleByte));
        }
    }
}

