/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEUsableBoardPortResource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEGetUsablePortsBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        ArrayList usableResourceList = new ArrayList();
        int result = TEUsableBoardPortResource.getPTPEnableResList(neID, usableResourceList);
        if (0 != result) {
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        String workMode = this.getWorkModeFromInputData(inputData);
        this.fillterNotSupportBoard(usableResourceList);
        this.fillterNotSupportClockType(usableResourceList, workMode);
        this.outputData = TEUsableBoardPortResource.constructOutput(neID, usableResourceList, user, ipAddress);
        return this.outputData;
    }

    private void fillterNotSupportClockType(ArrayList usableResourceList, String workMode) {
        Iterator it = usableResourceList.iterator();
        TEUsableBoardPortResource bdres = null;
        while (it.hasNext()) {
            bdres = (TEUsableBoardPortResource)it.next();
            List workModelist = TESpecialAttrMgr.getInstance().getCPAttrListValueByType(bdres.getBoardType(), "TE_FUNC_CFG_PTPCLOCK_PRIORITY", "OTN_ATTR_SUPPORT_PTPCLOCKTYPE");
            if (workModelist.isEmpty() || workMode.isEmpty() || workModelist.contains(workMode)) continue;
            it.remove();
        }
    }

    private String getWorkModeFromInputData(Datainterface inputData) {
        try {
            RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
            if (rowparams.getParam("WorkMode") != null && rowparams.getParam("WorkMode").getValue() != null) {
                return rowparams.getParam("WorkMode").getValue();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("PTP Clock NEWorkMode error.", (Throwable)e);
        }
        return "";
    }

    private void fillterNotSupportBoard(ArrayList usableResourceList) {
        Iterator it = usableResourceList.iterator();
        TEUsableBoardPortResource bdres = null;
        while (it.hasNext()) {
            bdres = (TEUsableBoardPortResource)it.next();
            int subrackType = TEBoardUtil.getShelfType((int)this.neid, (int)bdres.getSlotID());
            List notSupportres = this.getNotSupportBoardList(subrackType);
            if (!notSupportres.contains(String.valueOf(bdres.getBoardType())) && Integer.parseInt("110") != subrackType) continue;
            it.remove();
        }
    }

    private List getNotSupportBoardList(int subrackType) {
        List res = TESpecialAttrMgr.getInstance().getNEAttrListValueByShelfType(this.neid, subrackType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_BOARD_NOTSUPPORT_PTPCLOCK");
        return res;
    }
}

