/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clockptp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clockptp.Port;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEUsableBoardPortResource;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PTPClockUtil {
    public static final String PTP_PORT_RES_CfgFile = "conf" + File.separator + "clock_ptp" + File.separator + "ptp_port_res.xml";
    public static final int PTP_PORT_RES_CFG_FLAG = 1;
    public static final int OUT_PORT_RES_CFG_FLAG = 2;
    public static final int PORT_PTPLINKENABLE_RES_CFG_FLAG = 3;
    public static final int LINE_MODE = 168;
    public static HashMap<String, ArrayList> ptpEnableCfgRes = null;
    public static HashMap<String, ArrayList> outPortCfgRes = null;
    public static HashMap<String, ArrayList> ptpLinkEnableCfgRes = null;

    public static HashMap<String, ArrayList> getPortCfgResMap(int neID, String cfgFile, int resCfgFileFlag) {
        String cfgfile = "nemgr" + File.separator + "ngwdm" + File.separator + PTP_PORT_RES_CfgFile;
        if (resCfgFileFlag == 1) {
            ptpEnableCfgRes = ClockUtil.parseBoardPortCfgFile(neID, cfgfile);
            return ptpEnableCfgRes;
        }
        if (resCfgFileFlag == 2) {
            outPortCfgRes = ClockUtil.parseBoardPortCfgFile(neID, cfgfile);
            return outPortCfgRes;
        }
        ptpLinkEnableCfgRes = PTPClockUtil.parseBoardPortCfgFile(cfgfile);
        return ptpLinkEnableCfgRes;
    }

    public static HashMap<String, ArrayList> parseBoardPortCfgFile(String cfgfile) {
        HashMap<String, ArrayList> boradPortMap = new HashMap<String, ArrayList>();
        String cfgFilePath = TEResourceManager.getPath() + File.separator + cfgfile;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(cfgFilePath);
            NodeList nodeList = doc.getElementsByTagName("item");
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap sub_nodes = node.getAttributes();
                String bodyTypeId = PTPClockUtil.getNodeAttrValue(sub_nodes, "cp_type_id");
                String portListStr = PTPClockUtil.getNodeAttrValue(sub_nodes, "port_list");
                String lportListStr = PTPClockUtil.getNodeAttrValue(sub_nodes, "lport_list");
                ArrayList<String> portList = new ArrayList<String>();
                String[] portArray = portListStr.split(",");
                String[] lportArray = lportListStr.split(",");
                int num1 = portArray.length;
                for (int index1 = 0; index1 < num1; ++index1) {
                    if (portArray[index1].equals("")) continue;
                    portList.add(portArray[index1]);
                }
                int num2 = lportArray.length;
                for (int index2 = 0; index2 < num2; ++index2) {
                    if (lportArray[index2].equals("")) continue;
                    portList.add(lportArray[index2]);
                }
                boradPortMap.put(bodyTypeId, portList);
            }
            return boradPortMap;
        }
        catch (ParserConfigurationException e1) {
            TELogFactory.getNormalLogger().error("", (Throwable)e1);
            return null;
        }
        catch (SAXException e2) {
            TELogFactory.getNormalLogger().error("", (Throwable)e2);
            return null;
        }
        catch (IOException e3) {
            TELogFactory.getNormalLogger().error("", (Throwable)e3);
            return null;
        }
    }

    private static String getNodeAttrValue(NamedNodeMap sub_nodes, String attrName) {
        if (null == sub_nodes) {
            return "";
        }
        String value = "";
        int len1 = sub_nodes.getLength();
        for (int j = 0; j < len1; ++j) {
            Node sub_node = sub_nodes.item(j);
            String name = sub_node.getNodeName();
            value = sub_node.getNodeValue();
            if (name.equals(attrName)) break;
        }
        return value;
    }

    public static int getPortResList(int neID, ArrayList usableResourceList, String cfgFile, int resCfgFileFlag) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        Vector boardList = ne.getBoardList();
        if (boardList == null || boardList.size() == 0) {
            return 2;
        }
        Collections.sort(boardList);
        HashMap<String, ArrayList> portCfgResMap = PTPClockUtil.getPortCfgResMap(neID, cfgFile, resCfgFileFlag);
        if (portCfgResMap == null || portCfgResMap.size() == 0) {
            return 2;
        }
        ArrayList filterList = null;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            int boardMode;
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            if (!portCfgResMap.containsKey("" + boardType) || (boardType == 2208 || boardType == 2209 || boardType == 2436 || boardType == 2590) && (boardMode = TEGetBoardMode.queryBoardMode((int)neID, (int)board.getSlotID())) != 168 && boardMode != 0) continue;
            filterList = portCfgResMap.get("" + boardType);
            int slotID = board.getSlotID();
            String bdName = board.getBoardName();
            int subBoardId = 255;
            String subdName = "";
            ArrayList portList = TEUsableBoardPortResource.getBoardPortList(neID, board);
            PTPClockUtil.filterPort(portList, filterList);
            ArrayList<String> portIDList = new ArrayList<String>();
            ArrayList<String> portNameList = new ArrayList<String>();
            int num = portList.size();
            for (int j = 0; j < num; ++j) {
                int portID = (Integer)portList.get(j);
                portIDList.add(j, portID + "");
                String portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portID);
                portNameList.add(j, portName);
            }
            if (portIDList.size() <= 0) continue;
            TEUsableBoardPortResource usableResource = new TEUsableBoardPortResource(slotID, bdName, subBoardId, subdName, portIDList, portNameList);
            usableResource.setBoardType(boardType);
            if (usableResourceList.contains(usableResource)) continue;
            usableResourceList.add(usableResource);
        }
        return 0;
    }

    public static void filterPort(ArrayList portList, ArrayList filterList) {
        if (null == portList || null == filterList) {
            return;
        }
        for (int index = portList.size() - 1; index >= 0; --index) {
            int item = (Integer)portList.get(index);
            boolean flag = true;
            int len = filterList.size();
            for (int i = 0; i < len; ++i) {
                int filterItem = Integer.parseInt((String)filterList.get(i));
                if (filterItem != item) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            portList.remove(index);
        }
    }

    public static ArrayList getOuterTimeOperation(int neid, String opertionStr, ArrayList<String> board_port_list) {
        try {
            if (null == board_port_list || board_port_list.size() == 0) {
                return null;
            }
            ArrayList<Object> templist = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)opertionStr);
            Input input = oper.getInput();
            for (int i = board_port_list.size() - 1; i >= 0; --i) {
                String[] strArr = board_port_list.get(i).split(",");
                input.setPartValue("slotid", strArr[0]);
                input.setPartValue("subslotid", "255");
                input.setPartValue("port", strArr[1]);
                templist.add(oper.clone());
            }
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public static Datainterface handleOuterTimeMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Datainterface outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 == errorCode || 1 == errorCode) {
            TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
            RowParams[] rowArray = outputData.getBussinessParams().getRowParams();
            int rowArrayLen = rowArray.length;
            for (int i = 0; i < rowArrayLen; ++i) {
                RowParams rowdata = outputData.getBussinessParams().getRowParams(i);
                int soltId = Integer.parseInt(rowdata.getParam("slotid").getValue());
                TEBoard board = cfgDataMgr.getBoard(neid, soltId);
                int boardType = board.getBoardType();
                String boardName = board.getBoardName();
                rowdata.addParam("boardname", boardName);
                int portId = Integer.parseInt(rowdata.getParam("port").getValue());
                String portName = cfgDataMgr.getPortName(neid, soltId, boardType, portId);
                rowdata.addParam("portname", portName);
            }
        }
        return outputData;
    }

    public static ArrayList getPTPEnablePorts(int neid, int timeout, SubFunc subFunc, ArrayList usableResourceList) {
        ArrayList<Port> portList = new ArrayList<Port>();
        ArrayList queryPortEnableList = PTPClockUtil.getQueryPTPEnableOperList(neid, usableResourceList);
        if (null == queryPortEnableList || queryPortEnableList.size() == 0) {
            return null;
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, queryPortEnableList, timeout, subFunc);
        if (result.retCode == 0) {
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            int size = queryPortEnableList.size();
            for (int i = 0; i < size; ++i) {
                Output output = ((Operation)queryPortEnableList.get(i)).getOutput()[0];
                Fault[] faultArr = output.getFault();
                boolean isSuccess = true;
                for (Fault fault : faultArr) {
                    String code = fault.getCode();
                    if (Integer.parseInt(code) == 0) continue;
                    isSuccess = false;
                    break;
                }
                if (!isSuccess || !"1".equals(output.getPartValue("ptpenable"))) continue;
                String slotid = output.getPartValue("slotid");
                String subslotid = output.getPartValue("subslotid");
                String portid = output.getPartValue("port");
                int boardType = mgr.getBoardType(neid, Integer.valueOf(slotid).intValue());
                Port port = new Port(slotid, subslotid, portid);
                port.setBoardType(boardType);
                portList.add(port);
            }
        }
        return portList;
    }

    private static ArrayList getQueryPTPEnableOperList(int neid, ArrayList usableResourceList) {
        ArrayList<Operation> queryPortEnableList = new ArrayList<Operation>();
        int size = usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            TEUsableBoardPortResource res = (TEUsableBoardPortResource)usableResourceList.get(i);
            int slotid = res.getSlotID();
            int subslotid = res.getSubslotID();
            ArrayList portidList = res.getPortidList();
            int size1 = portidList.size();
            for (int j = 0; j < size1; ++j) {
                String portid = (String)portidList.get(j);
                Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PTPENABLE");
                Input input = operation.getInput();
                input.setPartValue("slotid", slotid + "");
                input.setPartValue("subslotid", subslotid + "");
                input.setPartValue("port", portid);
                queryPortEnableList.add(operation);
            }
        }
        return queryPortEnableList;
    }

    public static ArrayList getClockBoardSlotIdList(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getBoardList();
        if (boardList == null || boardList.size() == 0) {
            return null;
        }
        Collections.sort(boardList);
        ArrayList<String> clockBoardSlotIdList = new ArrayList<String>();
        ArrayList<String> clockBoardShelfIdList = new ArrayList<String>();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            int slotID = board.getSlotID();
            PTPClockUtil.isNewClockBorad(clockBoardShelfIdList, clockBoardSlotIdList, boardType, slotID);
        }
        return clockBoardSlotIdList;
    }

    private static boolean isNewClockBorad(ArrayList<String> clockBoardShelfIdList, ArrayList<String> clockBoardSlotIdList, int boardType, int slotID) {
        String slotIDStr = "" + slotID;
        if (boardType != 1544 && boardType != 1571 && boardType != 2058 && boardType != 1622 && boardType != 2285 && boardType != 2446 && boardType != 2306 && boardType != 2328 && !TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CLOCK_CONTROL_CENTER", "OTN_ATTR_IS_WDMCLOCK_BOARD")) {
            return false;
        }
        String shelfIDStr = PTPClockUtil.getShelfIDStr(slotID);
        if (!clockBoardShelfIdList.contains(shelfIDStr.toLowerCase())) {
            clockBoardShelfIdList.add(shelfIDStr.toLowerCase());
        }
        clockBoardSlotIdList.add(slotIDStr);
        return true;
    }

    public static String getShelfIDStr(int slotID) {
        String shelfIDStr = "" + slotID % 65536;
        return shelfIDStr;
    }

    public static ArrayList getQueryOutTimePortLinkOperation(int neid, ArrayList<String> portList) {
        try {
            String opertionStr = "NSCMD_CFG_GET_STGPORTLINK";
            ArrayList<Object> templist = new ArrayList<Object>();
            ArrayList clockBoardSlotIdList = PTPClockUtil.getClockBoardSlotIdList(neid);
            if (null == clockBoardSlotIdList || clockBoardSlotIdList.size() == 0) {
                return null;
            }
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)opertionStr);
            Input input = oper.getInput();
            for (int i = clockBoardSlotIdList.size() - 1; i >= 0; --i) {
                String slotId = (String)clockBoardSlotIdList.get(i);
                input.setPartValue("slotid", slotId);
                input.setPartValue("subslotid", "255");
                for (int j = portList.size() - 1; j >= 0; --j) {
                    input.setPartValue("port", portList.get(j));
                    templist.add(oper.clone());
                }
            }
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public static ArrayList<String> getOuterTimeResList(int neid, ArrayList operationList, SubFunc subfunc) {
        ArrayList<String> board_port_list = new ArrayList<String>();
        Operation operation = null;
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            Output[] outputs = operation.getOutput();
            Output output = null;
            int listlen = operation.getOutputCount();
            for (int i = 0; i < listlen; ++i) {
                String res;
                if (!outputs[i].getFault(0).getCode().equals("0") || "1".equals((output = outputs[i]).getPartValue("enablestatus")) || "2".equals(output.getPartValue("enablestatus")) || board_port_list.contains(res = output.getPartValue("slotid") + "," + output.getPartValue("port"))) continue;
                board_port_list.add(res);
            }
        }
        return board_port_list;
    }
}

