/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.jni.TEStgfreqDBMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.phyclock.TEStgfreqMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;

public class TEStgfreqScriptHandler
implements TEScriptHandler {
    static final String[] SYNSSMMODE = new String[]{"disables1", "expands1", "standards1"};
    static final String[] SYNCSWENABLE = new String[]{"disable", "enable"};
    static final String[] OUTSSMQL = new String[]{"ql_dnu", "ql_sec", "ql_ssub", "ql_ssua", "ql_prc"};
    static final String[] UNKNOWQL = new String[]{"ql_unknown", "", "ql_prc", "", "ql_ssua", "", "", "", "ql_ssub", "", "", "ql_sec", "", "", "", ""};

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }

    public int doExport(int neID, int item) {
        int result = 0;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne == null) {
            String tipStr = "TEBadDetectScriptHandler NE is Not Exist!";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            TELogFactory.getE2ELogger().info(tipStr);
            return result;
        }
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEStgfreqMOPO> stgList = TEStgfreqDBMgr.getStgfreqFromDB(neID, errRet);
        for (TEStgfreqMOPO stf : stgList) {
            TEScriptCmd cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            if (stf.getFreqsynclass() != null && !stf.getFreqsynclass().isEmpty()) {
                String[] srcids = stf.getFreqsynclass().split(",");
                StringBuilder sb = new StringBuilder();
                for (String srcid : srcids) {
                    if (sb.length() != 0) {
                        sb.append("&");
                    }
                    sb.append("{srcnum=" + srcids.length + ",");
                    sb.append("srcid=0x" + srcid + "}");
                }
                cmd.addPara("freqsynclass", sb.toString(), false, false);
            }
            if (stf.getHoldofftime() != -1) {
                cmd.addPara("holdofftime", stf.getHoldofftime(), false, false);
            }
            if (stf.getKeepmode() != -1) {
                cmd.addPara("keepmode", stf.getKeepmode(), false, false);
            }
            if (stf.getOutssmql() != -1) {
                cmd.addPara("outssmql", OUTSSMQL[stf.getOutssmql()], false, false);
            }
            if (stf.getSyncswenable() != -1) {
                cmd.addPara("syncswenable", SYNCSWENABLE[stf.getSyncswenable()], false, false);
            }
            if (stf.getSynssmmode() != -1) {
                cmd.addPara("synssmmode", SYNSSMMODE[stf.getSynssmmode()], false, false);
                if (stf.getSubnetid() != -1 && stf.getSynssmmode() == 1) {
                    cmd.addPara("subnetid", "0x" + Integer.toHexString(stf.getSubnetid()), false, false);
                }
            }
            if (stf.getUnknowql1() != -1) {
                cmd.addPara("unknowql1", UNKNOWQL[stf.getUnknowql1()], false, false);
            }
            if (stf.getUnknowql2() != -1) {
                cmd.addPara("unknowql2", UNKNOWQL[stf.getUnknowql2()], false, false);
            }
            if (stf.getWtrtime() != -1) {
                cmd.addPara("wtrtime", stf.getWtrtime(), false, false);
            }
            result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }
}

