/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.jni;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.phyclock.TEStgfreqsrcMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEStgfreqsrcDBMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEStgfreqsrcDBMgr() {
    }

    private static void logRetCodeErr(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logExpErrOnCreate(int neID, Exception e) {
        logger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    public static List<TEStgfreqsrcMOPO> getAllStgfreqsrcFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqsrcDBMgr.getStgfreqsrcFromDB";
        logger.info("TEStgfreqsrcDBMgr.getStgfreqsrcFromDB: begin.");
        ArrayList<TEStgfreqsrcMOPO> stgfreqList = new ArrayList<TEStgfreqsrcMOPO>();
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEStgfreqsrcDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.getStgfreqsrcFromDB");
                return stgfreqList;
            }
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEStgfreqsrcMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEStgfreqsrcMOPO.class);
        }
        catch (Exception e) {
            logger.error("get arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.getStgfreqsrcFromDB");
            return stgfreqList;
        }
        if (null == dbRet) {
            logger.error("get clock device from db fail! dbRet is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.getStgfreqsrcFromDB");
            return stgfreqList;
        }
        int retCode = dbRet.getResult();
        if (0 == retCode) {
            List data = dbRet.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    stgfreqList.add((TEStgfreqsrcMOPO)obj);
                }
            }
        } else {
            TEStgfreqsrcDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.getStgfreqsrcFromDB");
        return stgfreqList;
    }

    public static TEStgfreqsrcMOPO getStgfreqsrcByClkid(int neID, String clockid, TEErrInfoReturn errRet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Srcid", clockid);
        criteria.add(aPair);
        TEStgfreqsrcMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEStgfreqsrcMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEStgfreqsrcMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEStgfreqsrcMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEStgfreqsrcMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEStgfreqsrcMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateStgfreqsrcToDB(int neID, TEStgfreqsrcMOPO mo, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)mo);
        }
        catch (Exception e) {
            String tipStr = "Get TEStgfreqsrcMOPO fail! ";
            logger.error(tipStr, (Throwable)e);
            errRet.setResult(1092743443);
            return;
        }
        if (null == dbResult) {
            TEStgfreqsrcDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            errRet.setResult(retCode);
        }
    }

    public static void delStgfreqsrcFromDB(int neID, TEStgfreqsrcMOPO stgSrcMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqsrcDBMgr.delStgfreqsrcFromDB";
        logger.info("TEStgfreqsrcDBMgr.delStgfreqsrcFromDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)stgSrcMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)stgSrcMO);
        }
        catch (Exception e) {
            logger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.delStgfreqsrcFromDB");
            return;
        }
        if (null == dbRet) {
            TEStgfreqsrcDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.delStgfreqsrcFromDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEStgfreqsrcDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.delStgfreqsrcFromDB");
    }

    public static void delAllStgfreqsrcFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqsrcDBMgr.delAllStgfreqsrcFromDB";
        logger.info("TEStgfreqsrcDBMgr.delAllStgfreqsrcFromDB: begin.");
        List<TEStgfreqsrcMOPO> stgList = TEStgfreqsrcDBMgr.getAllStgfreqsrcFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEStgfreqsrcDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEStgfreqsrcMOPO stg : stgList) {
            TEStgfreqsrcDBMgr.delStgfreqsrcFromDB(neID, stg, errRet);
        }
        TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.delAllStgfreqsrcFromDB");
    }

    public static void createStgfreqsrcToDB(int neID, TEStgfreqsrcMOPO stgfreqMO, TEErrInfoReturn errRet) {
        String FUNCNAME = "TEStgfreqsrcDBMgr.createStgfreqsrcToDB";
        logger.info("TEStgfreqsrcDBMgr.createStgfreqsrcToDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)stgfreqMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)stgfreqMO);
        }
        catch (Exception e) {
            TEStgfreqsrcDBMgr.logExpErrOnCreate(neID, e);
            errRet.setResult(1092743443);
            TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.createStgfreqsrcToDB");
            return;
        }
        if (null == dbRet) {
            TEStgfreqsrcDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.createStgfreqsrcToDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEStgfreqsrcDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqsrcDBMgr.logFunEnd("TEStgfreqsrcDBMgr.createStgfreqsrcToDB");
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullError(int neID) {
        logger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFunEnd(String funcName) {
        logger.info(funcName + ": end.");
    }
}

