/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.jni;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.phyclock.TEStgfreqextsynMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEStgfreqextsynDBMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEStgfreqextsynDBMgr() {
    }

    private static void logRetCodeErr(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    public static List<TEStgfreqextsynMOPO> getAllStgfreqextsynFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqextsynDBMgr.getStgfreqextsynFromDB";
        logger.info("TEStgfreqextsynDBMgr.getStgfreqextsynFromDB: begin.");
        ArrayList<TEStgfreqextsynMOPO> stgsynList = new ArrayList<TEStgfreqextsynMOPO>();
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEStgfreqextsynDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.getStgfreqextsynFromDB");
                return stgsynList;
            }
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEStgfreqextsynMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEStgfreqextsynMOPO.class);
        }
        catch (Exception e) {
            logger.error("get arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.getStgfreqextsynFromDB");
            return stgsynList;
        }
        if (null == dbRet) {
            logger.error("get clock device from db fail! dbRet is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.getStgfreqextsynFromDB");
            return stgsynList;
        }
        int retCode = dbRet.getResult();
        if (0 == retCode) {
            List data = dbRet.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    stgsynList.add((TEStgfreqextsynMOPO)obj);
                }
            }
        } else {
            TEStgfreqextsynDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.getStgfreqextsynFromDB");
        return stgsynList;
    }

    private static void logExpErrOnCreate(int neID, Exception e) {
        logger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    public static TEStgfreqextsynMOPO getStgfreqextsynByExtsynid(int neID, String extsynid, TEErrInfoReturn errRet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Extsynid", extsynid);
        criteria.add(aPair);
        TEStgfreqextsynMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEStgfreqextsynMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEStgfreqextsynMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEStgfreqextsynMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEStgfreqextsynMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEStgfreqextsynMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateStgfreqextsynToDB(int neID, TEStgfreqextsynMOPO mo, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)mo);
        }
        catch (Exception e) {
            String tipStr = "Get TEStgfreqextsynMOPO fail! ";
            logger.error(tipStr, (Throwable)e);
            errRet.setResult(1092743443);
            return;
        }
        if (null == dbResult) {
            TEStgfreqextsynDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            errRet.setResult(retCode);
        }
    }

    public static void delStgfreqextsynFromDB(int neID, TEStgfreqextsynMOPO stgSrcMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqextsynDBMgr.delStgfreqextsynFromDB";
        logger.info("TEStgfreqextsynDBMgr.delStgfreqextsynFromDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)stgSrcMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)stgSrcMO);
        }
        catch (Exception e) {
            logger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.delStgfreqextsynFromDB");
            return;
        }
        if (null == dbRet) {
            TEStgfreqextsynDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.delStgfreqextsynFromDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEStgfreqextsynDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.delStgfreqextsynFromDB");
    }

    public static void delAllStgfreqextsynFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqextsynDBMgr.delAllStgfreqextsynFromDB";
        logger.info("TEStgfreqextsynDBMgr.delAllStgfreqextsynFromDB: begin.");
        List<TEStgfreqextsynMOPO> stgList = TEStgfreqextsynDBMgr.getAllStgfreqextsynFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEStgfreqextsynDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEStgfreqextsynMOPO stg : stgList) {
            TEStgfreqextsynDBMgr.delStgfreqextsynFromDB(neID, stg, errRet);
        }
        TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.delAllStgfreqextsynFromDB");
    }

    private static void logNullError(int neID) {
        logger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFunEnd(String funcName) {
        logger.info(funcName + ": end.");
    }

    public static void createStgfreqextsynToDB(int neID, TEStgfreqextsynMOPO stgsynMO, TEErrInfoReturn errRet) {
        String FUNCNAME = "TEStgfreqextsynDBMgr.createStgfreqextsynToDB";
        logger.info("TEStgfreqextsynDBMgr.createStgfreqextsynToDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)stgsynMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)stgsynMO);
        }
        catch (Exception e) {
            TEStgfreqextsynDBMgr.logExpErrOnCreate(neID, e);
            errRet.setResult(1092743443);
            TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.createStgfreqextsynToDB");
            return;
        }
        if (null == dbRet) {
            TEStgfreqextsynDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.createStgfreqextsynToDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEStgfreqextsynDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqextsynDBMgr.logFunEnd("TEStgfreqextsynDBMgr.createStgfreqextsynToDB");
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

