/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.jni;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.phyclock.TEStgfreqMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEStgfreqDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TEStgfreqDBMgr() {
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    public static List<TEStgfreqMOPO> getStgfreqFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqDBMgr.getStgfreqFromDB";
        normalLogger.info("TEStgfreqDBMgr.getStgfreqFromDB: begin.");
        ArrayList<TEStgfreqMOPO> stgfreqList = new ArrayList<TEStgfreqMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEStgfreqDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.getStgfreqFromDB");
                return stgfreqList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEStgfreqMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEStgfreqMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("get arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.getStgfreqFromDB");
            return stgfreqList;
        }
        if (null == dbResult) {
            normalLogger.error("get clock device from db fail! dbResult is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.getStgfreqFromDB");
            return stgfreqList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    stgfreqList.add((TEStgfreqMOPO)obj);
                }
            }
        } else {
            TEStgfreqDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.getStgfreqFromDB");
        return stgfreqList;
    }

    public static void delStgfreqFromDB(int neID, TEStgfreqMOPO stgMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqDBMgr.delStgfreqFromDB";
        normalLogger.info("TEStgfreqDBMgr.delStgfreqFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)stgMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)stgMO);
        }
        catch (Exception e) {
            normalLogger.error("delete arp from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.delStgfreqFromDB");
            return;
        }
        if (null == dbResult) {
            TEStgfreqDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.delStgfreqFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEStgfreqDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.delStgfreqFromDB");
    }

    public static void delAllStgfreqFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEStgfreqDBMgr.delAllStgfreqFromDB";
        normalLogger.info("TEStgfreqDBMgr.delAllStgfreqFromDB: begin.");
        List<TEStgfreqMOPO> stgList = TEStgfreqDBMgr.getStgfreqFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEStgfreqDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEStgfreqMOPO stg : stgList) {
            TEStgfreqDBMgr.delStgfreqFromDB(neID, stg, errRet);
        }
        TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.delAllStgfreqFromDB");
    }

    public static void createStgfreqToDB(int neID, TEStgfreqMOPO stgfreqMO, TEErrInfoReturn errRet) {
        String FUNCNAME = "TEStgfreqDBMgr.createArpToDB";
        normalLogger.info("TEStgfreqDBMgr.createArpToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)stgfreqMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)stgfreqMO);
        }
        catch (Exception e) {
            TEStgfreqDBMgr.logExceptionErrorOnCreate(neID, e);
            errRet.setResult(1092743443);
            TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.createArpToDB");
            return;
        }
        if (null == dbResult) {
            TEStgfreqDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.createArpToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEStgfreqDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEStgfreqDBMgr.logFunEnd("TEStgfreqDBMgr.createArpToDB");
    }

    private static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFunEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }
}

