/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.jni.TEGetOtherFiberEndAdapter;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEUsableBoardPortResource {
    private int slotID = -1;
    private String boardName;
    private int subboardId = -1;
    private String subboardName;
    private ArrayList portidList = null;
    private ArrayList portNameList = null;
    private static final int HASHCODE_MULTIPLIED = 37;
    private static final int HASHCODE_INITVALUE = 17;

    public TEUsableBoardPortResource(int slotID, String boardName, int subboardId, String subboardName, ArrayList portidList, ArrayList portNameList) {
        this.slotID = slotID;
        this.boardName = boardName;
        this.subboardId = subboardId;
        this.subboardName = subboardName;
        this.portidList = portidList;
        this.portNameList = portNameList;
    }

    public static ArrayList getClockSourceResList(int neID) {
        return ClockUtil.getClockSourceResList(neID, ClockUtil.clockSourceCfgFile, -1);
    }

    public static ArrayList getBoardPortList(int neID, TEBoard board) {
        if (null == board) {
            return null;
        }
        ArrayList existPortList = null;
        int boardType = board.getBoardType();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        existPortList = mgr.getBoardPortList(neID, boardType);
        if (mgr.isDynPortBoardType(neID, boardType)) {
            existPortList.removeAll(mgr.getSupportedDynPortList(neID, boardType));
            existPortList.addAll(TEPortModelConfigurationDataMgr.getInstance().getDynLogicPortList(neID, board.getSlotID(), board.getBoardType()));
        }
        return existPortList;
    }

    public static Datainterface constructQueryClockSourceOutput(int neID, ArrayList clockSourceList, String user, String ipAddress) {
        TEErrInfoReturn errInfoRet = TEGetOtherFiberEndAdapter.getOtherEnd(clockSourceList);
        Datainterface outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        int size = clockSourceList.size();
        for (int i = 0; i < size; ++i) {
            TEClockSource res = (TEClockSource)clockSourceList.get(i);
            RowParams rowParams = new RowParams();
            Param param = null;
            param = new Param("slotid", "" + res.getSlotID());
            rowParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rowParams.addParam(param);
            param = new Param("subslotid", "" + res.getSubboardId());
            rowParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rowParams.addParam(param);
            param = new Param("portid", "" + res.getPortID());
            rowParams.addParam(param);
            param = new Param("portName", "" + res.getPortName());
            rowParams.addParam(param);
            param = new Param("clockSourceType", "" + res.getClockSourceType());
            rowParams.addParam(param);
            param = new Param("clockid", "" + res.getSourceID());
            rowParams.addParam(param);
            param = new Param("clockidhex", res.getSourceIDHexStr());
            rowParams.addParam(param);
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)res.getSlotID());
            String clockName = ClockUtil.getClockName(res, neID);
            param = new Param("clockname", clockName);
            if (!subrack.equals("") && res.getOuterSourceNo().equals("-1")) {
                param = new Param("clockname", subrack + "-" + clockName);
            }
            rowParams.addParam(param);
            param = new Param("subrackname", subrack);
            rowParams.addParam(param);
            rowParams.addParam("otherfiberend", res.getOtherFiberEnd());
            bussinessParams.addRowParams(rowParams);
        }
        outputData.setBussinessParams(bussinessParams);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        ErrorMessage errMsg = outputData.getErrorMessage();
        if (TESysManagerBean.getInstance().isIntegratedStatus() && 0 != errInfoRet.getResult()) {
            errMsg.setErrorcode(String.valueOf(1));
            RowParams rowparams = new RowParams();
            ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
            rowErrorList.addAll(TEGetOtherFiberEndAdapter.contructErrorMessage(neID, errInfoRet));
            for (RowErrors rowError : rowErrorList) {
                rowparams.addRowErrors(rowError);
            }
            outputData.getBussinessParams().addRowParams(0, rowparams);
        }
        return outputData;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public String getBoardName() {
        return this.boardName;
    }

    public int getSubslotID() {
        return this.subboardId;
    }

    public String getSubboardName() {
        return this.subboardName;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setBoardName(String name) {
        this.boardName = name;
    }

    public void setPortidList(ArrayList portidList) {
        this.portidList = portidList;
    }

    public void setPortNameList(ArrayList portNameList) {
        this.portNameList = portNameList;
    }

    public ArrayList getPortidList() {
        return this.portidList;
    }

    public ArrayList getPortNameList() {
        return this.portNameList;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.slotID;
        result = 37 * result + this.subboardId;
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TEUsableBoardPortResource)) {
            return false;
        }
        TEUsableBoardPortResource resObj = (TEUsableBoardPortResource)o;
        int slotCompare = this.slotID - resObj.slotID;
        if (0 != slotCompare) {
            return false;
        }
        if (0 != this.subboardId - resObj.subboardId) {
            return false;
        }
        return this.boardName.equals(resObj.boardName);
    }
}

