/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TENEClockWriteLogBean;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public class TESet2mClockPriority
extends TENEClockWriteLogBean {
    private static final int CLOCK_STATE_ENABLE = 1;
    private static final int CLOCK_STATE_DISABLED = 0;
    private static final int CLOCK_INDEX_COUNT = 8;
    private List<String> oldPriorityIndexs = new ArrayList<String>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Datainterface newinput = this.handleInput(inputData);
        return super.performBussinessProcess(neid, subFunc, newinput, memeryData, user, ipAddress);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        int i;
        ArrayList operationList = super.getOperation(neid, subFunc, inputData, memeryData);
        Operation operation = null;
        ArrayList operations = null;
        int clocknum = 0;
        String clockdata = "";
        int len = operationList.size();
        for (i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            if (!operation.getName().equals("NSCMD_CFG_SET_2MPLL_CLASS_EX")) continue;
            clockdata = operation.getInput().getPartValue("clockdata");
            clocknum = Integer.parseInt(operation.getInput().getPartValue("clocknum"));
            operations = this.getSetPortEnableOperations(clocknum, clockdata, 1);
            if (operations.isEmpty()) continue;
            operationList.addAll(i, operations);
        }
        if (!this.oldPriorityIndexs.isEmpty()) {
            for (i = 0; i < this.oldPriorityIndexs.size(); ++i) {
                operation = this.getPortEnableOperation(this.oldPriorityIndexs.get(i), 0);
                if (operation == null) continue;
                operationList.add(operation);
            }
        }
        return operationList;
    }

    public ArrayList getSetPortEnableOperations(int clocknum, String clockDatas, int state) {
        ArrayList<Operation> operationListTemp = new ArrayList<Operation>();
        String clockdata = "";
        Operation operation = null;
        for (int i = 0; i < clocknum && clockDatas.length() >= i * 8 + 8; ++i) {
            clockdata = clockDatas.substring(i * 8, i * 8 + 8);
            this.oldPriorityIndexs.remove(clockdata);
            operation = this.getPortEnableOperation(clockdata, state);
            if (operation == null) continue;
            operationListTemp.add(operation);
        }
        return operationListTemp;
    }

    private Operation getPortEnableOperation(String clockdata, int state) {
        TEClockSource clocksource = ClockUtil.hexclockID2TEClockSource(this.neid, clockdata);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, clocksource.getSlotID());
        Operation operation = null;
        if (boardType == 2217 && (operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_PORTCLKSYNCENABLE")) != null) {
            Input input = operation.getInput();
            input.setPartValue("slotid", String.valueOf(clocksource.getSlotID()));
            input.setPartValue("subslotid", "255");
            input.setPartValue("port", String.valueOf(clocksource.getPortID()));
            input.setPartValue("W32PORT_ATTR_SYNCLOCKENABLE", String.valueOf(state));
        }
        return operation;
    }

    private Datainterface handleInput(Datainterface inputData) {
        Datainterface newinput = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        newinput.setBussinessParams(businessParam);
        RowParams[] oldRows = inputData.getBussinessParams().getRowParams();
        RowParams row = new RowParams();
        String clockslotno = oldRows[0].getParam("clockslotno").getValue();
        row.addParam("clockslotno", clockslotno);
        String clock2mFlag = oldRows[0].getParam("clock2mFlag").getValue();
        row.addParam("clock2mindex", clock2mFlag);
        if (oldRows[0].getParam("oldclockindex") != null && oldRows[0].getParam("oldclocknum") != null) {
            this.oldPriorityIndexs = new ArrayList<String>();
            int clocknum = Integer.parseInt(oldRows[0].getParam("oldclocknum").getValue());
            String clockIndexs = oldRows[0].getParam("oldclockindex").getValue();
            for (int i = 0; i < clocknum; ++i) {
                if (clockIndexs.length() < i * 8 + 8) continue;
                this.oldPriorityIndexs.add(clockIndexs.substring(i * 8, i * 8 + 8));
            }
        }
        int len = oldRows.length;
        row.addParam("clocknum", len - 1 + "");
        StringBuilder sb = new StringBuilder();
        StringBuilder opDescSb = new StringBuilder();
        for (int i = 1; i < len; ++i) {
            RowParams rowParams = oldRows[i];
            sb.append(rowParams.getParam("clockidhex").getValue());
            if (rowParams.getParam("opDesc") == null) continue;
            opDescSb.append(rowParams.getParam("opDesc").getValue());
            opDescSb.append(",");
        }
        row.addParam("clockdata", sb.toString());
        row.addParam("clockdata", sb.toString());
        row.addParam("opDesc", opDescSb.toString());
        newinput.getBussinessParams().addRowParams(row);
        return newinput;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(38737);
        return arrayList;
    }
}

