/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryClockSwitchConBean
extends TENEClockWriteLogBean {
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList clockSourceList = ClockUtil.getClockSourceResList(neID, ClockUtil.clockSourceCfgFile_switch, -1);
        if (null == clockSourceList || clockSourceList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
            return this.outputData;
        }
        this.operationList = this.getOperation(this.neid, clockSourceList);
        if (null == this.operationList || this.operationList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            this.handleMessage(this.neid, this.operationList, clockSourceList);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, ArrayList clockSourceList) {
        if (null == clockSourceList || clockSourceList.size() == 0) {
            return null;
        }
        try {
            ArrayList<Object> operList = new ArrayList<Object>();
            Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ALM2CLKSW");
            Input input = operation.getInput();
            int size = clockSourceList.size();
            for (int i = 0; i < size; ++i) {
                TEClockSource clockSource = (TEClockSource)clockSourceList.get(i);
                input.setPartValue("slotno", "" + clockSource.getSlotID());
                input.setPartValue("subboardno", "" + clockSource.getSubboardId());
                input.setPartValue("port", "" + clockSource.getPortID());
                String alarmID = clockSource.getAlarmID();
                if (!alarmID.isEmpty()) {
                    String[] alm = alarmID.split(",");
                    int len = alm.length;
                    for (int j = 0; j < len; ++j) {
                        input.setPartValue("alarmid", alm[j]);
                        operList.add(operation.clone());
                    }
                    continue;
                }
                input.setPartValue("alarmid", "35");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "33");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12327");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12333");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12315");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12361");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12357");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12354");
                operList.add(operation.clone());
                input.setPartValue("alarmid", "12350");
                operList.add(operation.clone());
            }
            return operList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, ArrayList clockSourceList) {
        ArrayList<Object> tempOperList = new ArrayList<Object>();
        Operation oper = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            oper = (Operation)operationList.get(i);
            tempOperList.add(oper.clone());
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)this.subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (null == clockSourceList || clockSourceList.size() == 0) {
            return;
        }
        RowParams errorRowParams = null;
        int num = this.outputData.getBussinessParams().getRowParamsCount();
        String errorCode = this.outputData.getErrorMessage().getErrorcode();
        if (num > 0 && !errorCode.equals("0")) {
            errorRowParams = this.outputData.getBussinessParams().getRowParams(num - 1);
        }
        this.outputData.getBussinessParams().clearRowParams();
        int len = clockSourceList.size();
        for (int i = 0; i < len; ++i) {
            TEClockSource clockSource = (TEClockSource)clockSourceList.get(i);
            RowParams row = new RowParams();
            row.addParam("slotno", "" + clockSource.getSlotID());
            row.addParam("subboardno", "" + clockSource.getSubboardId());
            row.addParam("port", "" + clockSource.getPortID());
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)clockSource.getSlotID());
            if (clockSource.getSlotID() > 0 && !subrackname.equals("") && clockSource.getOuterSourceNo().equals("-1")) {
                row.addParam("clockname", subrackname + "-" + ClockUtil.getClockName(clockSource, neid));
            } else {
                row.addParam("clockname", ClockUtil.getClockName(clockSource, neid));
            }
            row.addParam("flag", "false");
            row.addParam("pmaisswitch", "-");
            row.addParam("pmdgeswitch", "-");
            row.addParam("odu3pmaisswitch", "-");
            row.addParam("odu3pmdgeswitch", "-");
            row.addParam("msaisswitch", "-");
            row.addParam("b2excswitch", "-");
            row.addParam("otu1degswitch", "-");
            row.addParam("otu2degswitch", "-");
            row.addParam("otu3degswitch", "-");
            this.outputData.getBussinessParams().addRowParams(row);
        }
        if (null != errorRowParams) {
            this.outputData.getBussinessParams().addRowParams(errorRowParams);
        }
        this.handleQuery(tempOperList);
    }

    private void handleQuery(ArrayList operList) {
        if (operList == null) {
            return;
        }
        for (int index = operList.size() - 1; index >= 0; --index) {
            Operation opr = (Operation)operList.get(index);
            Output[] outputs = opr.getOutput();
            Output output2 = null;
            for (Output output2 : outputs) {
                if (!output2.getFault(0).getCode().equals("0")) continue;
                int alarmid = Integer.parseInt(output2.getPartValue("alarmid"));
                String key = output2.getPartValue("slotno") + output2.getPartValue("port");
                String isswitch = output2.getPartValue("isswitch");
                this.jointRow(key, alarmid, isswitch);
            }
            operList.remove(index);
        }
    }

    private void jointRow(String keyIn, int alarmid, String isswitch) {
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        int len = rows.length;
        for (int j = 0; j < len; ++j) {
            String key;
            if (rows[j].getRowErrorsCount() > 0 || !(key = rows[j].getParam("slotno").getValue() + rows[j].getParam("port").getValue()).equalsIgnoreCase(keyIn)) continue;
            rows[j].getParam("flag").setValue("true");
            switch (alarmid) {
                case 35: {
                    rows[j].getParam("b2excswitch").setValue(isswitch);
                    break;
                }
                case 33: {
                    rows[j].getParam("msaisswitch").setValue(isswitch);
                    break;
                }
                case 12354: {
                    rows[j].getParam("pmaisswitch").setValue(isswitch);
                    break;
                }
                case 12350: {
                    rows[j].getParam("pmdgeswitch").setValue(isswitch);
                    break;
                }
                case 12361: {
                    rows[j].getParam("odu3pmaisswitch").setValue(isswitch);
                    break;
                }
                case 12357: {
                    rows[j].getParam("odu3pmdgeswitch").setValue(isswitch);
                    break;
                }
                case 12315: {
                    rows[j].getParam("otu1degswitch").setValue(isswitch);
                    break;
                }
                case 12327: {
                    rows[j].getParam("otu2degswitch").setValue(isswitch);
                    break;
                }
                case 12333: {
                    rows[j].getParam("otu3degswitch").setValue(isswitch);
                    break;
                }
            }
            return;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38737);
        list.add(38671);
        list.add(38675);
        list.add(38774);
        list.add(39555);
        list.add(38709);
        return list;
    }
}

