/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TENEClockWriteLogBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockQuality
extends TENEClockWriteLogBean {
    private Datainterface otheroutputData = null;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.otheroutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 38662 || faultCode == 0) {
            this.handleData(this.otheroutputData);
        } else {
            this.outputData = this.otheroutputData;
        }
        RowParams row = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            row = this.outputData.getBussinessParams().getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String clockIdHex = row.getParam("clockid").getValue();
            String clockQuality = row.getParam("clockquality").getValue();
            if (clockQuality.equals("") || clockQuality.equals("-1")) {
                row.getParam("clockquality").setValue("16");
            } else {
                int quality = Integer.parseInt(clockQuality);
                row.getParam("clockquality").setValue(String.valueOf(quality &= 0xF));
                if (quality != 0 && quality != 2 && quality != 4 && quality != 8 && quality != 11 && quality != 15) {
                    row.getParam("clockquality").setValue("16");
                }
            }
            TEClockSource res = ClockUtil.hexclockID2TEClockSource(neid, clockIdHex);
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)res.getSlotID());
            if (!subrack.equals("") && res.getOuterSourceNo().equals("-1")) {
                row.addParam("clockname", subrack + "-" + ClockUtil.getClockName(res, neid));
            } else {
                row.addParam("clockname", ClockUtil.getClockName(res));
            }
            row.addParam("clockSourceType", "" + res.getClockSourceType());
            row.addParam("subrackname", subrack);
        }
    }

    private void handleData(Datainterface otheroutputData) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_CLASS_EX");
            Input input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            operationList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
            if (result.retCode != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result.retCode));
                return;
            }
            int retCode = this.handleclockidlist(operationList);
            if (retCode != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
                return;
            }
            if (!String.valueOf(0).equals(otheroutputData.getErrorMessage().getErrorcode())) {
                this.outputData.setErrorMessage((ErrorMessage)otheroutputData.getErrorMessage().clone());
                int len = otheroutputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowParams row = otheroutputData.getBussinessParams().getRowParams(i);
                    if (row.getRowErrorsCount() <= 0) continue;
                    this.outputData.getBussinessParams().addRowParams((RowParams)row.clone());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("handleIFBoard " + this.neid + "failed");
        }
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        String[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = Integer.valueOf(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = Integer.valueOf(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockid = new String[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = value.substring(index, index + 8);
                    index += 8;
                }
            }
        }
        this.handleClockIdData(clockid);
        return 0;
    }

    private void handleClockIdData(String[] clockid) {
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockid.length; ++i) {
            String ssminputquality;
            String clockQuality;
            RowParams rtnRowParams = new RowParams();
            String clockIdHex = clockid[i];
            rtnRowParams.addParam("clockid", clockIdHex);
            String configQuality = this.getClockAttrValue(clockid[i], "configquality");
            if (configQuality != null) {
                rtnRowParams.addParam("configquality", configQuality);
            }
            if ((clockQuality = this.getClockAttrValue(clockid[i], "clockquality")) != null) {
                rtnRowParams.addParam("clockquality", clockQuality);
            }
            if ((ssminputquality = this.getClockAttrValue(clockid[i], "ssminputquality")) != null) {
                rtnRowParams.addParam("ssminputquality", ssminputquality);
            }
            businessParam.addRowParams(rtnRowParams);
        }
        this.outputData.setBussinessParams(businessParam);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
    }

    private String getClockAttrValue(String clockid, String attrID) {
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() <= 0) {
            return null;
        }
        RowParams[] rowparam = this.otheroutputData.getBussinessParams().getRowParams();
        int len = rowparam.length;
        for (int j = 0; j < len; ++j) {
            Param p;
            String clockidvalue;
            Param para = rowparam[j].getParam("clockid");
            if (para == null || !(clockidvalue = para.getValue()).equalsIgnoreCase(clockid) || (p = rowparam[j].getParam(attrID)) == null) continue;
            return p.getValue();
        }
        return null;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList errorCodeList = super.getFilterErrorCodeList();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }
}

