/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryClockNetBean
extends TENEExplorerBean {
    private Datainterface otheroutputData = null;
    private static final int MODE_INVALID = 39286;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.otheroutputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode == 38662 || faultCode == 0 || faultCode == 39286) {
            this.handleData(this.otheroutputData);
            return;
        }
        this.outputData = this.otheroutputData;
    }

    private void handleData(Datainterface otheroutputData) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SYN_CLASS_EX");
            Input input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            operationList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
            if (result.retCode != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)result.retCode));
                return;
            }
            int retCode = this.handleclockidlist(operationList);
            if (retCode != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
                return;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("handleIFBoard " + this.neid + "failed");
        }
    }

    private int handleclockidlist(ArrayList operationList) {
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        String[] clockid = null;
        int clocknum = 0;
        int retCode = 0;
        for (Output output : outputArr) {
            retCode = Integer.valueOf(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum = Integer.valueOf(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockid = new String[clocknum];
                int index = 0;
                for (int i = 0; i < clocknum; ++i) {
                    clockid[i] = value.substring(index, index + 8);
                    index += 8;
                }
            }
        }
        this.handleClockIdData(clockid);
        return 0;
    }

    private void handleClockIdData(String[] clockid) {
        this.outputData = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        for (int i = 0; i < clockid.length; ++i) {
            RowParams rtnRowParams = new RowParams();
            String clockIdHex = clockid[i];
            TEClockSource res = ClockUtil.hexclockID2TEClockSource(this.neid, clockIdHex);
            rtnRowParams.addParam("clockid", clockIdHex);
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)res.getSlotID());
            if (!subrack.equals("") && res.getOuterSourceNo().equals("-1")) {
                rtnRowParams.addParam("clockname", subrack + "-" + ClockUtil.getClockName(res, this.neid));
            } else {
                rtnRowParams.addParam("clockname", ClockUtil.getClockName(res));
            }
            rtnRowParams.addParam("clockSourceType", "" + res.getClockSourceType());
            int clocknetid = this.getClockS1Id(clockid[i]);
            rtnRowParams.addParam("clocknetid", clocknetid + "");
            rtnRowParams.addParam("subrackname", subrack);
            businessParam.addRowParams(rtnRowParams);
        }
        String clocknetno = "0";
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() > 0) {
            RowParams rowpara = this.otheroutputData.getBussinessParams().getRowParams(0);
            clocknetno = rowpara.getParam("clocknetno").getValue();
        }
        int len = businessParam.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams rowpara = businessParam.getRowParams(i);
            rowpara.addParam("clocknetno", clocknetno);
        }
        this.outputData.setBussinessParams(businessParam);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
    }

    private int getClockS1Id(String clockid) {
        if (this.otheroutputData.getBussinessParams().getRowParamsCount() <= 0) {
            return 0;
        }
        RowParams[] rowparam = this.otheroutputData.getBussinessParams().getRowParams();
        int len = rowparam.length;
        for (int j = 0; j < len; ++j) {
            Param para = rowparam[j].getParam("clockid");
            String clockidvalue = para.getValue();
            if (!clockidvalue.equalsIgnoreCase(clockid)) continue;
            Param p = rowparam[j].getParam("clocknetid");
            return Integer.valueOf(p.getValue());
        }
        return 0;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(39286);
        return list;
    }
}

