/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TEQuery2MProperty
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = ClockUtil.getOutClockSourceOperation(neid);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            ArrayList outerClockSourceList = null;
            HashMap synidMap = new HashMap();
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return this.outputData;
            }
            outerClockSourceList = ClockUtil.getOuterClockSourceList(neid, this.operationList, synidMap);
            this.operationList.clear();
            this.operationList = this.getQuery2MPropertyOperationList(outerClockSourceList);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            result = this.sendMessage(neid);
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return this.outputData;
            }
            this.constructOutputData(synidMap);
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private ArrayList getQuery2MPropertyOperationList(ArrayList outerClockSourceList) {
        int num = 0;
        if (null == outerClockSourceList || (num = outerClockSourceList.size()) == 0) {
            return null;
        }
        ArrayList<Object> operList = new ArrayList<Object>();
        try {
            Operation operation = null;
            Input input = null;
            for (int i = 0; i < num; ++i) {
                String clockid = (String)outerClockSourceList.get(i);
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXTOUT_MODE");
                input = operation.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clockid", clockid);
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXTIN_S1INPSLOT");
                input = operation.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clockid", clockid);
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXTOUT_TH_EX");
                input = operation.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clockid", clockid);
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXT_LAPSE_TERM");
                input = operation.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clockid", clockid);
                input.setPartValue("lapseid", "1");
                operList.add(operation.clone());
                input.setPartValue("clockid", clockid);
                input.setPartValue("lapseid", "2");
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_2MPLL_SYNLOS_ACTION_EX");
                input = operation.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clockid", clockid);
                operList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_EXTSYN_FORCECLOSE_EX");
                input = operation.getInput();
                input.setPartValue("clockslotno", "65535");
                input.setPartValue("clockid", clockid);
                operList.add(operation.clone());
            }
            return operList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return operList;
        }
    }

    private void constructOutputData(Map synidMap) {
        String clockid = null;
        String lapseid = null;
        Operation operation = null;
        ArrayList<Operation> operList = new ArrayList<Operation>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = this.operationList.size() - 1; i >= 0; --i) {
            operation = (Operation)this.operationList.get(i);
            if (!operation.getName().equalsIgnoreCase("NSCMD_CFG_GET_EXT_LAPSE_TERM")) continue;
            operList.add(operation);
            Output[] outputs = operation.getOutput();
            Output output2 = null;
            for (Output output2 : outputs) {
                int retCode = Integer.parseInt(output2.getFault()[0].getCode());
                if (retCode != 0) continue;
                clockid = output2.getPartValue("clockid").toLowerCase();
                lapseid = output2.getPartValue("lapseid");
                if (!output2.getPartValue("flag").equals("1")) continue;
                if (map.containsKey(clockid)) {
                    map.put(clockid, "3");
                    continue;
                }
                map.put(clockid, lapseid);
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operationList, (ArrayList)this.getFilterErrorCodeList());
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        RowParams row = null;
        for (int i = rows.length - 1; i >= 0; --i) {
            row = rows[i];
            if (row.getRowErrorsCount() > 0) continue;
            lapseid = "0";
            clockid = row.getParam("clockid").getValue().toLowerCase();
            if (map.containsKey(clockid)) {
                lapseid = (String)map.get(clockid);
            }
            row.addParam("lapseflag", lapseid);
            String shelfIdstr = "0x" + clockid.substring(0, 2);
            int clockSlotid = Integer.decode(shelfIdstr) * 65536 + 1;
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)clockSlotid);
            row.addParam("subrackname", subrack);
            row.addParam("synid", (String)synidMap.get(clockid));
        }
    }
}

