/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TENEClockWriteLogBean;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEUsableBoardPortResource;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TEGetClockSourceSuperBean
extends TENEClockWriteLogBean {
    public HashMap<String, ArrayList<String>> priorityTableMap = new HashMap();
    public HashMap<String, ArrayList<String>> priority2M1TableMap = new HashMap();
    public HashMap<String, ArrayList<String>> priority2M2TableMap = new HashMap();
    public HashMap<String, String> outClockSourceMap = new HashMap(2);
    public ArrayList<String> filterSlot1_1 = new ArrayList();
    public HashMap<String, String> filterSlot1_2 = new HashMap();
    public String clock2mFlag = "0";
    public String subrackType_68 = "51";
    public boolean is68Subrack = false;

    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.clock2mFlag = inputData.getBussinessParams().getRowParams(0).getParam("clock2mFlag").getValue();
        this.outputData = new Datainterface();
        this.operationList = this.getOperation(this.neid, subFunc, inputData, memeryData);
        int result = this.sendMessage(this.neid);
        ArrayList clockSourceList = new ArrayList(0);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        this.handleOutput(this.neid, this.operationList, clockSourceList);
        Datainterface tempOutput = TEDataConverter.convertToDatainterface((int)this.neid, (SubFunc)this.subfunc, (ArrayList)this.operationList, (ArrayList)this.getFilterErrorCodeList());
        RowParams errRow = null;
        int errCode = Integer.parseInt(tempOutput.getErrorMessage().getErrorcode());
        if (errCode != 0) {
            errRow = tempOutput.getBussinessParams().getRowParams(tempOutput.getBussinessParams().getRowParamsCount() - 1);
        }
        this.addSource(clockSourceList);
        if (null == clockSourceList || clockSourceList.size() == 0) {
            if (this.is68Subrack) {
                RowParams row = new RowParams();
                row.addParam("is68Subrack", "yes");
                tempOutput.getBussinessParams().addRowParams(row);
            }
            return tempOutput;
        }
        this.outputData = TEUsableBoardPortResource.constructQueryClockSourceOutput(neID, clockSourceList, user, ipAddress);
        if (this.is68Subrack) {
            RowParams row = new RowParams();
            row.addParam("is68Subrack", "yes");
            this.outputData.getBussinessParams().addRowParams(row);
        }
        if (errCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)errCode));
            this.outputData.getBussinessParams().addRowParams(errRow);
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            ArrayList operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_SYN_CLASS_EX");
            Input input = operation.getInput();
            input.setPartValue("clockslotno", "65535");
            operationList.add(operation.clone());
            return operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleOutput(int neid, ArrayList operationList, ArrayList clockSourceList) {
        Operation oper = null;
        String operName = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            oper = (Operation)operationList.get(i);
            operName = oper.getName();
            if (operName.equalsIgnoreCase("NSCMD_CFG_GET_PLLSYN_SYNID")) {
                this.getOutClockSourceMap(oper);
                continue;
            }
            this.getAllPriorityTable(oper);
        }
        if (!this.clock2mFlag.equals("0")) {
            String subrackType;
            if (!this.outClockSourceMap.containsKey(this.clock2mFlag)) {
                this.outputData.setBussinessParams(new BussinessParams());
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
                return;
            }
            String srcId = this.outClockSourceMap.get(this.clock2mFlag);
            int subrackId = Integer.valueOf(srcId.substring(0, 2), 16);
            TESubrack subrack = this.getSubrack(subrackId);
            if (null != subrack && (subrackType = subrack.getLogicSubrackType()).equals(this.subrackType_68)) {
                this.is68Subrack = true;
            }
        }
        clockSourceList.addAll(TEUsableBoardPortResource.getClockSourceResList(this.neid));
        ClockUtil.fillterNotSupportBoard(neid, clockSourceList);
        this.getFilterSlot();
        this.filter(clockSourceList);
        if (!this.clock2mFlag.equals("0")) {
            this.filterFor2M(clockSourceList);
        }
    }

    private void getOutClockSourceMap(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        String clock2mindex = null;
        String clockid = null;
        int listlen = operation.getOutputCount();
        for (int i = 0; i < listlen; ++i) {
            output = outputs[i];
            if (!output.getFault(0).getCode().equals("0")) continue;
            clock2mindex = output.getPartValue("clock2mindex");
            clockid = output.getPartValue("clockid");
            this.outClockSourceMap.put(clock2mindex, clockid);
        }
    }

    private void getAllPriorityTable(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        HashMap<String, ArrayList<String>> map = null;
        int listlen = operation.getOutputCount();
        for (int i = 0; i < listlen; ++i) {
            output = outputs[i];
            if (!output.getFault(0).getCode().equals("0")) continue;
            int clock2mindex = 0;
            if (null != output.getPart("clock2mindex")) {
                clock2mindex = Integer.parseInt(output.getPartValue("clock2mindex"));
            }
            switch (clock2mindex) {
                case 1: {
                    map = this.priority2M1TableMap;
                    break;
                }
                case 2: {
                    map = this.priority2M2TableMap;
                    break;
                }
                default: {
                    map = this.priorityTableMap;
                }
            }
            int clocknum = Integer.parseInt(output.getPartValue("clocknum"));
            String clockdata = output.getPartValue("clockdata");
            String clockidHexStr = null;
            String slotidHexStr = null;
            String portidHexStr = null;
            int clockidlength = 8;
            int from = 0;
            for (int j = 0; j < clocknum; ++j) {
                clockidHexStr = clockdata.substring(from, from + clockidlength);
                from += clockidlength;
                slotidHexStr = clockidHexStr.substring(0, 4);
                portidHexStr = clockidHexStr.substring(6, 8);
                if (map.containsKey(slotidHexStr)) {
                    map.get(slotidHexStr).add(portidHexStr);
                    continue;
                }
                ArrayList<String> arrList = new ArrayList<String>();
                arrList.add(portidHexStr);
                map.put(slotidHexStr, arrList);
            }
        }
    }

    private void getFilterSlot() {
        int clock2mindex = Integer.parseInt(this.clock2mFlag);
        HashMap<String, ArrayList<String>> map_A = null;
        HashMap<String, ArrayList<String>> map_B = null;
        switch (clock2mindex) {
            case 1: {
                map_A = this.priorityTableMap;
                map_B = this.priority2M2TableMap;
                break;
            }
            case 2: {
                map_A = this.priorityTableMap;
                map_B = this.priority2M1TableMap;
                break;
            }
            default: {
                map_A = this.priority2M1TableMap;
                map_B = this.priority2M2TableMap;
            }
        }
        this._getFilterSlot(map_A);
        this._getFilterSlot(map_B);
    }

    private void _getFilterSlot(HashMap<String, ArrayList<String>> map) {
        Iterator<Map.Entry<String, ArrayList<String>>> iterator = map.entrySet().iterator();
        Map.Entry<String, ArrayList<String>> entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getValue().size() > 1) {
                this.filterSlot1_1.add(entry.getKey());
                continue;
            }
            this.filterSlot1_2.put(entry.getKey(), entry.getValue().get(0));
        }
    }

    private void filter(ArrayList clockSourceList) {
        TEClockSource clocksource = null;
        String clockidHexStr = null;
        String slotidHexStr = null;
        String portidHexStr = null;
        for (int i = clockSourceList.size() - 1; i >= 0; --i) {
            clocksource = (TEClockSource)clockSourceList.get(i);
            clockidHexStr = clocksource.getSourceIDHexStr();
            slotidHexStr = clockidHexStr.substring(0, 4);
            portidHexStr = clockidHexStr.substring(6, 8);
            if (this.filterSlot1_1.contains(slotidHexStr)) {
                clockSourceList.remove(i);
                continue;
            }
            if (!this.filterSlot1_2.containsKey(slotidHexStr) || this.filterSlot1_2.get(slotidHexStr).equalsIgnoreCase(portidHexStr)) continue;
            clockSourceList.remove(i);
        }
    }

    private void filterFor2M(ArrayList clockSourceList) {
        String outClocksourceId = this.outClockSourceMap.get(this.clock2mFlag);
        String outClockShelfId = outClocksourceId.substring(0, 2);
        TEClockSource clocksource = null;
        String clockidHexStr = null;
        String shelfIdHexStr = null;
        for (int i = clockSourceList.size() - 1; i >= 0; --i) {
            clocksource = (TEClockSource)clockSourceList.get(i);
            clockidHexStr = clocksource.getSourceIDHexStr();
            shelfIdHexStr = clockidHexStr.substring(0, 2);
            if (outClockShelfId.equalsIgnoreCase(shelfIdHexStr)) continue;
            clockSourceList.remove(i);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38823);
        list.add(44741);
        return list;
    }

    private TESubrack getSubrack(int subrackId) {
        TESubrack subrack = null;
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector subRackList = ne.getSubrackList();
        for (int i = subRackList.size() - 1; i >= 0; --i) {
            subrack = (TESubrack)subRackList.get(i);
            if (!subrack.getSubrackID().equals("" + subrackId)) continue;
            return subrack;
        }
        return subrack;
    }

    public void addSource(ArrayList clockSourceList) {
        if (!this.clock2mFlag.equals("0")) {
            TEClockSource innersource = ClockUtil.hexclockID2TEClockSource(this.neid, "00F10001");
            clockSourceList.add(innersource);
        } else {
            Iterator<Map.Entry<String, String>> iter = this.outClockSourceMap.entrySet().iterator();
            while (iter.hasNext()) {
                String element = iter.next().getValue();
                TEClockSource outersource = ClockUtil.hexclockID2TEClockSource(this.neid, element);
                clockSourceList.add(outersource);
            }
        }
    }
}

