/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.ClockUtil;

public class TEClockSource {
    private int neID = -1;
    private int slotID = -1;
    private String boardName;
    private int subboardId = 0;
    private String subboardName;
    private int portID = -1;
    private String portName;
    private String otherFiberEnd;
    private int clockSourceType = 0;
    public static final int LINE_SOURCE = -1;
    public static final int INNER_SOURCE = 0;
    public static final int OUTER_SOURCE = 2;
    public static final int NONE_SOURCE = -2;
    private String alarmID = "";
    public static final int SLOTCONSTATNS = 65536;

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public TEClockSource(int neid, int slotID, String boardName, int subboardId, String subboardName, int portID, String portName, int clockSourceType) {
        this.neID = neid;
        this.slotID = slotID;
        this.boardName = boardName;
        this.subboardId = subboardId;
        this.subboardName = subboardName;
        this.portID = portID;
        this.portName = portName;
        this.clockSourceType = clockSourceType;
    }

    public int getSourceID() {
        return Integer.parseInt(this.getSourceIDHexStr(), 16);
    }

    public String getSourceIDHexStr() {
        String sourceIDStr = "00f10001";
        switch (this.clockSourceType) {
            case 0: {
                sourceIDStr = "00F10001";
                break;
            }
            case -1: {
                sourceIDStr = ClockUtil.getShelfIDHexStr(this.slotID) + ClockUtil.getSlotIDHexStr(this.slotID) + "00" + ClockUtil.getPortIDHexStr(this.portID, 2);
                break;
            }
            case 2: {
                sourceIDStr = ClockUtil.getShelfIDHexStr(this.slotID) + "f0" + ClockUtil.getPortIDHexStr(this.portID, 4);
                break;
            }
            default: {
                sourceIDStr = "00f10001";
            }
        }
        return sourceIDStr.toLowerCase();
    }

    public String getOuterSourceNo() {
        if (this.clockSourceType != 2) {
            return "" + this.clockSourceType;
        }
        if (this.portID == 1) {
            return "1";
        }
        return "2";
    }

    public String getBoardName() {
        return this.boardName;
    }

    public int getPortID() {
        return this.portID;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getClockSourceType() {
        return this.clockSourceType;
    }

    public int getSubboardId() {
        return this.subboardId;
    }

    public String getSubboardName() {
        return this.subboardName;
    }

    public void setPortID(int portID) {
        this.portID = portID;
    }

    public String getAlarmID() {
        return this.alarmID;
    }

    public void setAlarmID(String alarmID) {
        this.alarmID = alarmID;
    }

    public static int slotIDNEToNM(int slotID) {
        int slot = slotID & 0x1F;
        int shelfID = slotID & 0xE0;
        return slot += (shelfID >>>= 5) * 65536;
    }

    public static int slotIDNMToNE(int slotID) {
        int shelfID = slotID / 65536;
        int slot = slotID % 65536;
        slot = (shelfID <<= 5) + slot;
        return slot;
    }

    public String getOtherFiberEnd() {
        return this.otherFiberEnd;
    }

    public void setOtherFiberEnd(String otherFiberEnd) {
        this.otherFiberEnd = otherFiberEnd;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clockSourceType;
        result = 31 * result + this.neID;
        result = 31 * result + this.portID;
        result = 31 * result + this.slotID;
        result = 31 * result + this.subboardId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEClockSource other = (TEClockSource)obj;
        if (this.clockSourceType != other.clockSourceType) {
            return false;
        }
        if (this.neID != other.neID) {
            return false;
        }
        if (this.portID != other.portID) {
            return false;
        }
        if (this.slotID != other.slotID) {
            return false;
        }
        return this.subboardId == other.subboardId;
    }
}

