/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEClockSource;
import com.huawei.nglct.nemgr.ngwdm.clock_v2r7c03.TEUsableBoardPortResource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClockUtil {
    public static String clockSourceCfgFile = "conf" + File.separator + "clock" + File.separator + "clocksource_res.xml";
    public static String clockSourceCfgFile_switch = "conf" + File.separator + "clock" + File.separator + "clocksource_switch_res.xml";
    public static String clockSource2MCfgFile = "conf" + File.separator + "clock" + File.separator + "clocksource_2m_res.xml";
    public static ArrayList<String> clockCfgFileList = new ArrayList();
    public static HashMap<String, ArrayList> clockSourceMap = null;
    public static HashMap<String, ArrayList> clockSource2MMap = null;
    public static HashMap<String, String> supPTPClockSourceMap = new HashMap();
    public static HashMap<String, String> suppClockDomainMap = new HashMap();
    private static HashMap<String, String> boardSupAlmID = new HashMap();

    private ClockUtil() {
    }

    public static HashMap<String, ArrayList> getCfgClockSourceRes(int neID, String cfgFile, int sourceFlag) {
        String cfgfile = "nemgr" + File.separator + "ngwdm" + File.separator + cfgFile;
        if (sourceFlag == 2) {
            clockSource2MMap = ClockUtil.parseBoardPortCfgFile(neID, cfgfile);
            clockCfgFileList.add(cfgfile);
            return clockSource2MMap;
        }
        clockSourceMap = ClockUtil.parseBoardPortCfgFile(neID, cfgfile);
        clockCfgFileList.add(cfgfile);
        return clockSourceMap;
    }

    public static HashMap<String, ArrayList> parseBoardPortCfgFile(int neid, String cfgfile) {
        HashMap<String, ArrayList> boradPortMap = new HashMap<String, ArrayList>();
        Bundle bundle = FrameworkUtil.getBundle(ClockUtil.class);
        Document doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)cfgfile);
        NodeList nodeList = doc.getElementsByTagName("item");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap sub_nodes = node.getAttributes();
            String bodyTypeId = ClockUtil.getNodeAttrValue(sub_nodes, "cp_type_id");
            String portListStr = ClockUtil.getNodeAttrValue(sub_nodes, "port_list");
            String lportListStr = ClockUtil.getNodeAttrValue(sub_nodes, "lport_list");
            String supportPTPFlag = ClockUtil.getNodeAttrValue(sub_nodes, "supportPTPPri");
            String supportDomainFlag = ClockUtil.getNodeAttrValue(sub_nodes, "supportDomain");
            String boardAlm = ClockUtil.getNodeAttrValue(sub_nodes, "supAlarmID");
            ArrayList<String> portList = new ArrayList<String>();
            String[] portArray = portListStr.split(",");
            String[] lportArray = lportListStr.split(",");
            int num1 = portArray.length;
            for (int index1 = 0; index1 < num1; ++index1) {
                if (portArray[index1].equals("")) continue;
                portList.add(portArray[index1]);
            }
            int num2 = lportArray.length;
            for (int index2 = 0; index2 < num2; ++index2) {
                if (lportArray[index2].equals("")) continue;
                portList.add(lportArray[index2]);
            }
            boradPortMap.put(bodyTypeId, portList);
            if (supportPTPFlag.equalsIgnoreCase("Y")) {
                supPTPClockSourceMap.put(bodyTypeId, supportPTPFlag);
            }
            if (!boardAlm.isEmpty()) {
                boardSupAlmID.put(bodyTypeId, boardAlm);
            }
            if (!supportDomainFlag.equalsIgnoreCase("T")) continue;
            suppClockDomainMap.put(bodyTypeId, supportDomainFlag);
        }
        ClockUtil.addExResource(neid, boradPortMap, cfgfile);
        return boradPortMap;
    }

    public static String getBoardSupAlarmID(String bdType) {
        return boardSupAlmID.get(bdType);
    }

    private static void addExResource(int neid, HashMap<String, ArrayList> boradPortMap, String resFileName) {
        block7: {
            block8: {
                block6: {
                    ArrayList ports;
                    int boardType;
                    if (resFileName.indexOf("ptp_port_res.xml") == -1) break block6;
                    List bds = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_CFG_PTPCLOCK_PRIORITY", "OTN_ATTR_SUPPORT_PTPCLOCK");
                    Iterator i$ = bds.iterator();
                    while (i$.hasNext()) {
                        boardType = (Integer)i$.next();
                        ports = new ArrayList();
                        ports.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_PTPCLOCK_PRIORITY", "OTN_ATTR_SUPPORT_PTPCLOCK"));
                        boradPortMap.put(String.valueOf(boardType), ports);
                    }
                    bds = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_CFG_PTPCLOCK_PRIORITY", "OTN_ATTR_SUPPORT_PTPPRI");
                    i$ = bds.iterator();
                    while (i$.hasNext()) {
                        boardType = (Integer)i$.next();
                        supPTPClockSourceMap.put(String.valueOf(boardType), "Y");
                    }
                    bds = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_CFG_PTPCLOCK_DOMAIN", "OTN_ATTR_SUPPORT_CLOCKDOMAIN");
                    i$ = bds.iterator();
                    while (i$.hasNext()) {
                        boardType = (Integer)i$.next();
                        ports = new ArrayList();
                        ports.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_PTPCLOCK_DOMAIN", "OTN_ATTR_SUPPORT_CLOCKDOMAIN"));
                        boradPortMap.put(String.valueOf(boardType), ports);
                        suppClockDomainMap.put(String.valueOf(boardType), "T");
                    }
                    break block7;
                }
                if (resFileName.indexOf("clocksource_res.xml") == -1) break block8;
                List bds = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_CFG_STG_SYNSRCPRV", "OTN_ATTR_SUPPORT_PHYCLOCKSOURCE");
                Iterator i$ = bds.iterator();
                while (i$.hasNext()) {
                    int boardType = (Integer)i$.next();
                    ArrayList ports = new ArrayList();
                    ports.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_STG_SYNSRCPRV", "OTN_ATTR_SUPPORT_PHYCLOCKSOURCE"));
                    boradPortMap.put(String.valueOf(boardType), ports);
                }
                break block7;
            }
            if (resFileName.indexOf("clocksource_switch_res.xml") == -1) break block7;
            List bds = TESpecialAttrMgr.getInstance().getSupportCPList(neid, "TE_FUNC_CFG_STG_SWITCH", "OTN_ATTR_SUPPORT_CLOCKSWITCH");
            Iterator i$ = bds.iterator();
            while (i$.hasNext()) {
                int boardType = (Integer)i$.next();
                ArrayList ports = new ArrayList();
                ports.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValueByType(boardType, "TE_FUNC_CFG_STG_SWITCH", "OTN_ATTR_SUPPORT_CLOCKSWITCH"));
                String almvalue = TESpecialAttrMgr.getInstance().getCPAttrValueByType(boardType, "TE_FUNC_CFG_STG_SWITCH", "OTN_ATTR_SUPPORT_CLOCKSWITCHALM");
                if (almvalue != null && !almvalue.isEmpty()) {
                    boardSupAlmID.put(String.valueOf(boardType), almvalue);
                }
                boradPortMap.put(String.valueOf(boardType), ports);
            }
        }
    }

    private static String getNodeAttrValue(NamedNodeMap sub_nodes, String attrName) {
        if (null == sub_nodes) {
            return "";
        }
        String value = "";
        int len1 = sub_nodes.getLength();
        for (int j = 0; j < len1; ++j) {
            Node sub_node = sub_nodes.item(j);
            String name = sub_node.getNodeName();
            value = sub_node.getNodeValue();
            if (name.equals(attrName)) break;
        }
        return value;
    }

    public static ArrayList getClockSourceResList(int neID, String cfgFile, int clockSourceType) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        Vector boardList = ne.getBoardList();
        if (boardList == null || boardList.size() == 0) {
            return null;
        }
        Collections.sort(boardList);
        HashMap<String, ArrayList> clockSourceMap = ClockUtil.getCfgClockSourceRes(neID, cfgFile, clockSourceType);
        if (clockSourceMap == null || clockSourceMap.size() == 0) {
            return null;
        }
        ArrayList<TEClockSource> resList = new ArrayList<TEClockSource>();
        ArrayList filterList = null;
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            if (!clockSourceMap.containsKey("" + boardType)) continue;
            filterList = clockSourceMap.get("" + boardType);
            int slotID = board.getSlotID();
            String bdName = board.getBoardName();
            int subBoardId = 0;
            String subdName = "";
            ArrayList portList = TEUsableBoardPortResource.getBoardPortList(neID, board);
            ClockUtil.filterPort(portList, filterList);
            int num = portList.size();
            for (int j = 0; j < num; ++j) {
                int portID = (Integer)portList.get(j);
                String portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, boardType, portID);
                TEClockSource clockSource = new TEClockSource(neID, slotID, bdName, subBoardId, subdName, portID, portName, clockSourceType);
                String alarmID = ClockUtil.getBoardSupAlarmID(String.valueOf(boardType));
                if (alarmID != null) {
                    clockSource.setAlarmID(alarmID);
                }
                if (resList.contains(clockSource)) continue;
                resList.add(clockSource);
            }
        }
        return resList;
    }

    public static void filterPort(ArrayList portList, ArrayList filterList) {
        if (null == portList || null == filterList) {
            return;
        }
        for (int index = portList.size() - 1; index >= 0; --index) {
            int item = (Integer)portList.get(index);
            boolean flag = true;
            int len = filterList.size();
            for (int i = 0; i < len; ++i) {
                int filterItem = Integer.parseInt((String)filterList.get(i));
                if (filterItem != item) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            portList.remove(index);
        }
    }

    public static ArrayList get2MClockSourceOperation0(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            String opertionStr = "NSCMD_CFG_GET_PTPEXTTIMEINTERFACEPARA";
            ArrayList outerPortLinkList = ClockUtil.getClockSourceResList(neid, clockSource2MCfgFile, 2);
            if (null == outerPortLinkList || outerPortLinkList.size() == 0) {
                return null;
            }
            ArrayList<Object> templist = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)opertionStr);
            Input input = oper.getInput();
            for (int i = outerPortLinkList.size() - 1; i >= 0; --i) {
                TEClockSource res = (TEClockSource)outerPortLinkList.get(i);
                input.setPartValue("slotid", "" + res.getSlotID());
                input.setPartValue("subslotid", "0");
                input.setPartValue("port", "" + res.getPortID());
                templist.add(oper.clone());
            }
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public static TEClockSource hexclockID2TEClockSource(int neid, String hexclockIDStr) {
        if (hexclockIDStr.equalsIgnoreCase("FFFFFFFF")) {
            return new TEClockSource(neid, -1, "", 0, "", 0, "0", -2);
        }
        if (hexclockIDStr.equalsIgnoreCase("00F10001")) {
            return new TEClockSource(neid, -1, "", 0, "", 0, "0", 0);
        }
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        int slotID = 0;
        int sourceType = 0;
        String subStr = hexclockIDStr.substring(2, hexclockIDStr.length());
        int shelfID = Integer.parseInt(hexclockIDStr.substring(0, 2), 16);
        int slotPrefix = shelfID * 65536;
        if (subStr.equalsIgnoreCase("f00001") || subStr.equalsIgnoreCase("f00002")) {
            sourceType = 2;
            int subrackType = TEBoardUtil.getShelfType((int)neid, (int)slotPrefix);
            switch (subrackType) {
                case 68: 
                case 79: 
                case 97: 
                case 109: {
                    slotID = slotPrefix + 42;
                    if (null != cfgDataMgr.getBoard(neid, slotID)) break;
                    slotID = slotPrefix + 44;
                    break;
                }
                case 74: 
                case 98: {
                    slotID = slotPrefix + 75;
                    if (null != cfgDataMgr.getBoard(neid, slotID)) break;
                    slotID = slotPrefix + 86;
                    break;
                }
                case 84: {
                    slotID = slotPrefix + 9;
                    if (null != cfgDataMgr.getBoard(neid, slotID)) break;
                    slotID = slotPrefix + 10;
                    break;
                }
                case 51: 
                case 110: {
                    slotID = slotPrefix + 15;
                    if (null != cfgDataMgr.getBoard(neid, slotID)) break;
                    slotID = slotPrefix + 16;
                    break;
                }
                case 126: 
                case 158: 
                case 174: {
                    slotID = slotPrefix + 3;
                    if (null != cfgDataMgr.getBoard(neid, slotID)) break;
                    slotID = slotPrefix + 4;
                    break;
                }
                case 111: 
                case 112: 
                case 117: 
                case 118: {
                    slotID = slotPrefix + 105;
                    break;
                }
            }
        } else {
            sourceType = -1;
            slotID = Integer.parseInt(hexclockIDStr.substring(2, 4), 16);
            slotID = slotPrefix + slotID;
        }
        int portID = Integer.parseInt(hexclockIDStr.substring(6, 8), 16);
        TEBoard board = cfgDataMgr.getBoard(neid, slotID);
        if (board == null) {
            TELogFactory.getNormalLogger().error("Get board failed neid=" + neid + " slotID=" + slotID);
            TEClockSource clockSource = new TEClockSource(neid, slotID, "Unknow", 255, "", portID, "Unknow", sourceType);
            return clockSource;
        }
        int boardType = board.getBoardType();
        String bdName = board.getBoardName();
        int subBoardId = 0;
        String portName = cfgDataMgr.getPortName(neid, slotID, boardType, portID);
        TEClockSource clockSource = new TEClockSource(neid, slotID, bdName, subBoardId, "", portID, portName, sourceType);
        return clockSource;
    }

    public static int getSubrackType(int neid, int shelfID) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        Vector subrackList = ne.getClonedSubrackList();
        TESubrack subrack = null;
        int shelfType = -1;
        for (int i = 0; i < subrackList.size(); ++i) {
            subrack = (TESubrack)subrackList.get(i);
            if (Integer.valueOf(subrack.getSubrackID()) != shelfID) continue;
            shelfType = Integer.parseInt(subrack.getLogicSubrackType());
        }
        return shelfType;
    }

    public static String getClockName(TEClockSource res) {
        String clockName = "";
        if (res.getOuterSourceNo().equals("0")) {
            clockName = "0";
        } else if (res.getOuterSourceNo().equals("-1")) {
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)res.getNeID(), (int)res.getSlotID());
            if (!"".equals(subrackName)) {
                clockName = subrackName + "-";
            }
            clockName = clockName + TEBoardUtil.getSlotIDFromSlot((int)res.getNeID(), (int)res.getSlotID()) + "-" + res.getBoardName() + "-" + res.getPortName();
        } else {
            clockName = res.getOuterSourceNo();
        }
        return clockName;
    }

    public static String getClockName(TEClockSource res, int neID) {
        String clockName;
        if (res.getOuterSourceNo().equals("0")) {
            clockName = "0";
        } else if (res.getOuterSourceNo().equals("-1")) {
            int slotid = TEBoardUtil.getSlotIDFromSlot((int)neID, (int)res.getSlotID());
            clockName = slotid + "-" + res.getBoardName() + "-" + res.getPortName();
        } else {
            clockName = res.getOuterSourceNo();
        }
        return clockName;
    }

    public static String getShelfIDHexStr(int slotID) {
        int shelfID = slotID / 65536;
        String shelfIDStr = Integer.toHexString(shelfID);
        for (int i = shelfIDStr.length(); i < 2; ++i) {
            shelfIDStr = "0" + shelfIDStr;
        }
        return shelfIDStr;
    }

    public static String getSlotIDHexStr(int slotID) {
        String slotIDStr = Integer.toHexString(slotID %= 65536);
        for (int i = slotIDStr.length(); i < 2; ++i) {
            slotIDStr = "0" + slotIDStr;
        }
        return slotIDStr;
    }

    public static ArrayList getClockBoardSlotIdList(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getBoardList();
        if (boardList == null || boardList.size() == 0) {
            return null;
        }
        Collections.sort(boardList);
        ArrayList<String> clockBoardSlotIdList = new ArrayList<String>();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardType = board.getBoardType();
            int slotID = board.getSlotID();
            ClockUtil.isNewClockBorad(clockBoardSlotIdList, boardType, slotID);
        }
        return clockBoardSlotIdList;
    }

    private static boolean isNewClockBorad(ArrayList<String> clockBoardSlotIdList, int boardType, int slotID) {
        if (boardType != 1544) {
            return false;
        }
        String slotIDStr = ClockUtil.getShelfIDStr(slotID) + "15";
        for (int i = clockBoardSlotIdList.size() - 1; i >= 0; --i) {
            if (!clockBoardSlotIdList.get(i).equalsIgnoreCase(slotIDStr)) continue;
            return false;
        }
        clockBoardSlotIdList.add(slotIDStr);
        return true;
    }

    public static String getShelfIDStr(int slotID) {
        String slotIDStr = "" + slotID;
        String str = slotIDStr.substring(slotIDStr.length() - 2, slotIDStr.length() - 1);
        String shelfIDStr = slotIDStr.substring(0, slotIDStr.lastIndexOf(str));
        return shelfIDStr;
    }

    public static ArrayList getOutClockSourceOperation(int neid) {
        try {
            String opertionStr = "NSCMD_CFG_GET_PLLSYN_SYNID";
            ArrayList<Object> templist = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)opertionStr);
            if (null == oper) {
                TELogFactory.getNormalLogger().error("oper is null!");
                return templist;
            }
            Input input = oper.getInput();
            input.setPartValue("clockslotno", "65535");
            input.setPartValue("clock2mindex", "1");
            templist.add(oper.clone());
            input.setPartValue("clock2mindex", "2");
            templist.add(oper.clone());
            return templist;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public static ArrayList getOuterClockSourceList(int neid, ArrayList operationList) {
        ArrayList<String> clockSourceList = new ArrayList<String>();
        Operation operation = null;
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            Output[] outputs = operation.getOutput();
            Output output = null;
            int listlen = operation.getOutputCount();
            for (int i = 0; i < listlen; ++i) {
                if (!outputs[i].getFault(0).getCode().equals("0")) continue;
                output = outputs[i];
                String hexclockIDStr = output.getPartValue("clockid");
                clockSourceList.add(hexclockIDStr);
            }
        }
        return clockSourceList;
    }

    public static ArrayList getOuterClockSourceList(int neid, ArrayList operationList, Map synidMap) {
        ArrayList<String> clockSourceList = new ArrayList<String>();
        Operation operation = null;
        int len = operationList.size();
        for (int index = 0; index < len; ++index) {
            operation = (Operation)operationList.get(index);
            Output[] outputs = operation.getOutput();
            Output output = null;
            int listlen = operation.getOutputCount();
            for (int i = 0; i < listlen; ++i) {
                if (!outputs[i].getFault(0).getCode().equals("0")) continue;
                output = outputs[i];
                String hexclockIDStr = output.getPartValue("clockid");
                String clock2mindex = output.getPartValue("clock2mindex");
                clockSourceList.add(hexclockIDStr);
                synidMap.put(hexclockIDStr.toLowerCase(), clock2mindex);
            }
        }
        return clockSourceList;
    }

    public static String getPortIDHexStr(int id, int strLength) {
        String hexStr = Integer.toHexString(id);
        for (int i = hexStr.length(); i < strLength; ++i) {
            hexStr = "0" + hexStr;
        }
        return hexStr;
    }

    public static void fillterNotSupportBoard(int neid, List<TEClockSource> clockSourceList) {
        Iterator<TEClockSource> it = clockSourceList.iterator();
        TEClockSource clockSource = null;
        while (it.hasNext()) {
            clockSource = it.next();
            int subrackType = TEBoardUtil.getShelfType((int)neid, (int)clockSource.getSlotID());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, clockSource.getSlotID());
            List notSupportres = ClockUtil.getNotSupportBoardList(neid, subrackType);
            if (!notSupportres.contains(String.valueOf(boardType))) continue;
            it.remove();
        }
    }

    public static List getNotSupportBoardList(int neid, int subrackType) {
        List res = TESpecialAttrMgr.getInstance().getNEAttrListValueByShelfType(neid, subrackType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_BOARD_NOTSUPPORT_PTPCLOCK");
        return res;
    }
}

