/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ngwdm.clock.TEClockUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQuerySccClock
extends TENEExplorerBean {
    private static final int FIND_NULL_ERROR_CODE = 38662;
    private static final int TIME_OUT = 10;
    private boolean allSuccess = true;
    private boolean allFail = true;
    Datainterface datainterface = null;

    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        this.neid = neID;
        Datainterface speDataInterface = new Datainterface();
        try {
            this.subfunc = subFunc;
            this.operationList = this.getOperation(neID, subFunc, inputData, MemoryData);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, (List)this.operationList, 10);
            if (result.retCode != 0) {
                speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)result.retCode));
            } else {
                speDataInterface = this.handleReturnData(this.operationList, neID);
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neID, subFunc, inputData, user, ipAddress, speDataInterface);
            }
        }
        catch (Exception e) {
            speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1090646019));
        }
        return speDataInterface;
    }

    private Datainterface handleReturnData(ArrayList operationList, int neID) {
        Datainterface speDataInterface = new Datainterface();
        BussinessParams businessParam = new BussinessParams();
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        int[] clockid1 = null;
        int clocknum1 = 0;
        for (Output output : outputArr) {
            int returnCode = new Integer(output.getFault()[0].getCode());
            if (returnCode == 37926) {
                speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)37926));
                return speDataInterface;
            }
            if (returnCode != 0) {
                speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)returnCode));
                return speDataInterface;
            }
            this.allFail = false;
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equalsIgnoreCase("clocknum") && value != null) {
                    clocknum1 = new Integer(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("clockdata") || value == null) continue;
                clockid1 = new int[clocknum1];
                int index = 0;
                for (int i = 0; i < clocknum1; ++i) {
                    clockid1[i] = Integer.parseInt(value.substring(index, index + 4), 16);
                    index += 4;
                }
            }
        }
        Param tempParam = null;
        int size = clockid1.length;
        for (int i = 0; i < size; ++i) {
            RowParams rtnRowParams = new RowParams();
            tempParam = new Param();
            tempParam.setName("clockname");
            tempParam.setValue(TEClockUtility.getClockSourceName(neID, (int)clockid1[i]));
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("clockid");
            tempParam.setValue("" + (int)clockid1[i]);
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("number");
            tempParam.setValue("" + (i + 1));
            rtnRowParams.addParam(tempParam);
            businessParam.addRowParams(rtnRowParams);
        }
        speDataInterface.setBussinessParams(businessParam);
        if (this.allSuccess) {
            speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        } else if (this.allFail) {
            speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)2));
        } else {
            speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1));
        }
        return speDataInterface;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }

    public boolean isNeedOperationlog(String ipAddress) {
        return true;
    }
}

