/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.ngwdm.clockptp.TEUsableBoardPortResource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TEGetSynAttrPortsBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFunc;
        this.inputData = inputData;
        List<String> attrs = this.getTableColid();
        this.outputData = new Datainterface();
        ArrayList<TEUsableBoardPortResource> usableResourceList = new ArrayList<TEUsableBoardPortResource>();
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        AbstractList bds = new ArrayList();
        int slotid = 0;
        Param param = inputData.getBussinessParams().getRowParams()[0].getParam("slotid");
        if (param != null) {
            slotid = Integer.parseInt(param.getValue());
            bds.add(TEBoardConfigurationDataMgr.getInstance().getBoard(this.neid, slotid));
        } else {
            bds = ne.getBoardList();
            Collections.sort(bds);
        }
        TEBoard boardObj = null;
        TEGenCfgModel genCfgModel = null;
        TreeSet<Integer> ports = new TreeSet<Integer>();
        int len = bds.size();
        for (int i = 0; i < len; ++i) {
            ArrayList supportAttrList;
            boardObj = (TEBoard)bds.get(i);
            if (null == boardObj) {
                TELogFactory.getNormalLogger().error("board object not exist!");
                continue;
            }
            genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardObj.getBoardType());
            if (null == genCfgModel || (supportAttrList = genCfgModel.getSupportAttrList(ne.getNEType(), ne.getShowNEVersion())) == null || supportAttrList.isEmpty()) continue;
            ports.clear();
            this.fillPort(attrs, ports, supportAttrList);
            if (ports.isEmpty()) continue;
            ArrayList<String> portIDList = new ArrayList<String>();
            ArrayList<String> portNameList = new ArrayList<String>();
            Iterator iter = ports.iterator();
            while (iter.hasNext()) {
                int portID = (Integer)iter.next();
                if (portID == 0) continue;
                portIDList.add(String.valueOf(portID));
                String portName = "";
                if (TESpecialAttrMgr.getInstance().isCPSupport(neID, boardObj.getSlotID(), "TE_FUNC_CLOCK_ATTRIBUTE_CONFIGURATION", "TE_ATTR_CLOCK_ATTR_CONF_PORTTYPE_ETH_MAC")) {
                    int portType = TESpecialAttrMgr.getInstance().getCPAttrIntValue(neID, boardObj.getSlotID(), "TE_FUNC_CLOCK_ATTRIBUTE_CONFIGURATION", "TE_ATTR_CLOCK_ATTR_CONF_PORTTYPE_ETH_MAC");
                    portName = TEConfigurationDataMgr.getInstance().getPortNameByPortType(neID, boardObj.getSlotID(), boardObj.getBoardType(), portID, portType);
                } else {
                    portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, boardObj.getSlotID(), boardObj.getBoardType(), portID);
                }
                portNameList.add(portName);
            }
            TEUsableBoardPortResource res = new TEUsableBoardPortResource(boardObj.getSlotID(), boardObj.getBoardName(), 255, "", portIDList, portNameList);
            res.setBoardType(boardObj.getBoardType());
            usableResourceList.add(res);
        }
        this.fillterNotSupportBoard(usableResourceList);
        this.constructOutput(this.neid, usableResourceList, user, ipAddress);
        return this.outputData;
    }

    private void fillPort(List<String> attrs, Set<Integer> ports, List<TEGenCfgAttribute> supportAttrList) {
        int jlen = supportAttrList.size();
        for (int j = 0; j < jlen; ++j) {
            TEGenCfgAttribute genCfgAttr = supportAttrList.get(j);
            if (!attrs.contains(genCfgAttr.getAttrId())) continue;
            ArrayList cfgPorts = genCfgAttr.getPortList();
            int iLen = cfgPorts.size();
            for (int i = 0; i < iLen; ++i) {
                TEGenCfgPortAttribute cfgPortAttr = (TEGenCfgPortAttribute)cfgPorts.get(i);
                ports.add(cfgPortAttr.getPort());
            }
        }
    }

    private List<String> getTableColid() {
        ArrayList<String> attrs = new ArrayList<String>();
        BussinessParams bus = this.inputData.getBussinessParams();
        Param param = bus.getRowParams(0).getParam("attrs");
        String[] attrArr = param.getValue().split(",");
        int len = attrArr.length;
        for (int i = 0; i < len; ++i) {
            attrs.add(attrArr[i]);
        }
        return attrs;
    }

    private void constructOutput(int neID, List<TEUsableBoardPortResource> usablePortResourceList, String user, String ipAddress) {
        BussinessParams bussinessParams = new BussinessParams();
        int size = usablePortResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableBoardPortResource res = usablePortResourceList.get(i);
            RowParams rowParams = new RowParams();
            Param param = null;
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)res.getSlotID());
            if (subrack != null && !subrack.equals("")) {
                param = new Param("subrack", subrack);
                rowParams.addParam(param);
            }
            param = new Param("slotid", "" + res.getSlotID());
            rowParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rowParams.addParam(param);
            param = new Param("subslotid", "" + res.getSubslotID());
            rowParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rowParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 0; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rowParams.addParam(param);
            param = new Param("portName", (String)res.getPortNameList().get(0));
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rowParams.addParam(param);
            bussinessParams.addRowParams(rowParams);
        }
        this.outputData.setBussinessParams(bussinessParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
    }

    private void fillterNotSupportBoard(List<TEUsableBoardPortResource> usableResourceList) {
        Iterator<TEUsableBoardPortResource> it = usableResourceList.iterator();
        TEUsableBoardPortResource bdres = null;
        while (it.hasNext()) {
            bdres = it.next();
            int subrackType = TEBoardUtil.getShelfType((int)this.neid, (int)bdres.getSlotID());
            List notSupportres = this.getNotSupportBoardList(subrackType);
            if (!notSupportres.contains(String.valueOf(bdres.getBoardType()))) continue;
            it.remove();
        }
    }

    private List getNotSupportBoardList(int subrackType) {
        List res = TESpecialAttrMgr.getInstance().getNEAttrListValueByShelfType(this.neid, subrackType, "TE_FUNC_CFG_PTPCLOCK_SYN_ATTRIBUTE", "OTN_ATTR_BOARD_NOTSUPPORT_PTPCLOCK");
        return res;
    }
}

