/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.clock;

import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TEClockUtility {
    private static final String filename = "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static String PAKAGE_PATH = "res" + File.separator + filename;

    public static String getClockSourceName(int neid, int clockid) {
        String path = TEGetFilePath.getFilePath((int)neid, (String)PAKAGE_PATH);
        int slotid = clockid >> 8 & 0xFF;
        int portid = clockid & 0xFF;
        String clockname = null;
        if (clockid == 240) {
            clockname = TEResourceUtil.getInstance((String)path).getString("innerclock");
            return clockname;
        }
        int neslotid = TEClockUtility.slotIDNEToNM(slotid);
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, neslotid);
        int boardtype = board.getBoardType();
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
        StringBuffer name = new StringBuffer();
        name.append(TEBoardUtil.getShelfBoardName((int)neid, (int)neslotid)).append("-").append(portname);
        return name.toString();
    }

    private static int slotIDNEToNM(int slotID) {
        int slot = slotID & 0x1F;
        int shelfID = slotID & 0xE0;
        return slot += (shelfID >>>= 5) * 100;
    }
}

