/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.channel_v2r6c01;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.TELCTFunBlockComparator;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nemgr.ngwdm.channel_v2r6c01.TEChannelDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEChannelPathGraph
extends TENEExplorerBean {
    private int boardtype = -1;
    private int slotID = -1;
    private static final String GET_ALL = "0";
    boolean isDynPortBoardType = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        this.slotID = Integer.parseInt(slotinfo);
        this.boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        String requesType = inputData.getBussinessParams().getRowParams(0).getParam("requesType").getValue();
        if (requesType.equalsIgnoreCase(GET_ALL)) {
            this.isDynPortBoardType = TEConfigurationDataMgr.getInstance().isDynPortBoardType(neid, this.boardtype);
        }
        this.getChannelData(neid, this.slotID);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public void getChannelData(int neID, int slotID) {
        List funblockList = TEChannelDataMgr.getInstance().getLctFunBlockList(neID, slotID, this.isDynPortBoardType);
        TELCTFunBlockComparator comparator = new TELCTFunBlockComparator();
        Collections.sort(funblockList, comparator);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        boolean isSimpleVirtualBoard = TEVirtualPortUtil.isSimpleVirtualBoard((int)this.boardtype);
        for (int i = 0; i < funblockList.size(); ++i) {
            TELCTFunBlock fb = (TELCTFunBlock)funblockList.get(i);
            RowParams rowParam = new RowParams();
            rowParam.addParam("id", fb.id);
            rowParam.addParam("pid", fb.pid);
            if (fb.name.indexOf("ODU15") != -1) {
                rowParam.addParam("name", "ODU1.5" + fb.name.substring(5));
            } else {
                rowParam.addParam("name", fb.name);
            }
            rowParam.addParam("portID", String.valueOf(fb.portid));
            rowParam.addParam("pathID", String.valueOf(fb.pathid));
            if (TEVirtualPortUtil.isVirtualPort((int)this.boardtype, (int)fb.portid, (int)0)) {
                rowParam.addParam("canDelPort", GET_ALL);
                rowParam.addParam("canModifyPort", GET_ALL);
            } else {
                rowParam.addParam("canDelPort", String.valueOf(fb.canDelPort));
                rowParam.addParam("canModifyPort", String.valueOf(fb.canModifyPort));
            }
            rowParam.addParam("functionType", String.valueOf(fb.functionType));
            rowParam.addParam("loopback", String.valueOf(fb.loopback));
            rowParam.addParam("payload", String.valueOf(fb.payload));
            rowParam.addParam("portName", fb.portName);
            rowParam.addParam("portStatus", String.valueOf(fb.portStatus));
            rowParam.addParam("usageState", String.valueOf(fb.usageState));
            if (isSimpleVirtualBoard) {
                rowParam.addParam("IsDynBoard", "false");
            } else {
                rowParam.addParam("IsDynBoard", String.valueOf(this.isDynPortBoardType));
            }
            rowParam.addParam("logicPortInPosition", String.valueOf(fb.logicPortInPosition));
            rowParam.addParam("porttype", fb.portType);
            rowParam.addParam("portspeed", fb.portSpeed);
            fb.topAlarmLevel = 0;
            this.geAlarmStatus(neID, slotID, fb);
            rowParam.addParam("topAlarmLevel", String.valueOf(fb.topAlarmLevel));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
    }

    private void geAlarmStatus(int neID, int slotID, TELCTFunBlock functionblock) {
        TENE neobj = TENEListMgr.getInstance().getNE(neID);
        Vector alarams = neobj.getAlarmList();
        ArrayList SupportAlmList = TEAlarmDataMgr.getInstance().getAlarmFbList(this.boardtype);
        if (SupportAlmList == null || SupportAlmList.size() == 0) {
            return;
        }
        functionblock.topAlarmLevel = 0;
        int size = alarams.size();
        for (int i = 0; i < size; ++i) {
            int AlarmLevel;
            TEAlarm alarm = (TEAlarm)alarams.get(i);
            int slot = alarm.getSlotID();
            int port = alarm.getPort();
            int path = alarm.getPath();
            int fbType = alarm.getFuncBlock();
            if (functionblock.pathid > 0) {
                if (fbType != functionblock.functionType || port != functionblock.portid || slot != slotID || path != functionblock.pathid) continue;
                AlarmLevel = alarm.getAlarmLevel();
                if (functionblock.topAlarmLevel > 0) {
                    if (AlarmLevel >= functionblock.topAlarmLevel) continue;
                    functionblock.topAlarmLevel = AlarmLevel;
                    break;
                }
                functionblock.topAlarmLevel = AlarmLevel;
                continue;
            }
            if (functionblock.pathid == 0) {
                if (fbType != functionblock.functionType || port != functionblock.portid || slot != slotID) continue;
                int size2 = SupportAlmList.size();
                for (int k = 0; k < size2; ++k) {
                    TEAlmFBObj alarmFb = (TEAlmFBObj)SupportAlmList.get(k);
                    if (alarmFb.m_usFBType != fbType || alarmFb.m_usPortID != port || alarmFb.m_usPathID != path) continue;
                    int AlarmLevel2 = alarm.getAlarmLevel();
                    if (functionblock.topAlarmLevel > 0) {
                        if (AlarmLevel2 >= functionblock.topAlarmLevel) continue;
                        functionblock.topAlarmLevel = AlarmLevel2;
                        continue;
                    }
                    functionblock.topAlarmLevel = AlarmLevel2;
                }
                continue;
            }
            if (slot != slotID || port != functionblock.portid) continue;
            AlarmLevel = alarm.getAlarmLevel();
            if (functionblock.topAlarmLevel > 0) {
                if (AlarmLevel >= functionblock.topAlarmLevel) continue;
                functionblock.topAlarmLevel = AlarmLevel;
                continue;
            }
            functionblock.topAlarmLevel = AlarmLevel;
        }
    }

    public String getDetailStr(RowParams rowparams) {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardtype);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!subrackName.equals("")) {
            subrackName = subrackName + "-";
        }
        if (null == neObj) {
            return String.valueOf(this.neid) + "-" + subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID) + "-" + boardName;
        }
        return neObj.getNEName() + "-" + subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID) + "-" + boardName;
    }
}

