/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.channel;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.TELCTFunBlockComparator;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nemgr.ngwdm.TENE_NGWDM;
import com.huawei.nglct.nemgr.ngwdm.channel.TEChannelDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEChannelPathGraph
extends TENEExplorerBean {
    private int boardtype = -1;
    private int slotID = -1;
    private int portID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param shelfPara;
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        this.slotID = Integer.parseInt(slotinfo);
        this.boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        Param portIDPara = inputData.getBussinessParams().getRowParams(0).getParam("portID");
        if (portIDPara != null) {
            this.portID = Integer.parseInt(portIDPara.getValue());
        }
        if ((shelfPara = inputData.getBussinessParams().getRowParams(0).getParam("shelfID")) != null) {
            this.slotID = TEBoardUtil.neToSlotIDNM((int)Integer.parseInt(shelfPara.getValue()), (int)this.slotID);
        }
        this.getChannelData();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private void getChannelData() {
        List funblockList = TEChannelDataMgr.getInstance().getLctFunBlockList(this.neid, this.slotID);
        TELCTFunBlockComparator comparator = new TELCTFunBlockComparator();
        Collections.sort(funblockList, comparator);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        for (int i = 0; i < funblockList.size(); ++i) {
            TELCTFunBlock fb = (TELCTFunBlock)funblockList.get(i);
            if (this.portID != -1 && (this.portID == -1 || fb.portid != this.portID)) continue;
            RowParams rowParam = new RowParams();
            rowParam.addParam("id", fb.id);
            rowParam.addParam("pid", fb.pid);
            rowParam.addParam("name", fb.name);
            rowParam.addParam("portID", String.valueOf(fb.portid));
            rowParam.addParam("pathID", String.valueOf(fb.pathid));
            rowParam.addParam("canDelPort", String.valueOf(fb.canDelPort));
            rowParam.addParam("canModifyPort", String.valueOf(fb.canModifyPort));
            rowParam.addParam("functionType", String.valueOf(fb.functionType));
            rowParam.addParam("loopback", String.valueOf(fb.loopback));
            rowParam.addParam("payload", String.valueOf(fb.payload));
            rowParam.addParam("portName", fb.portName);
            rowParam.addParam("portStatus", String.valueOf(fb.portStatus));
            rowParam.addParam("usageState", String.valueOf(fb.usageState));
            fb.topAlarmLevel = 0;
            if (fb.pathid >= 0) {
                this.geAlarmStatus(this.neid, this.slotID, fb);
            }
            rowParam.addParam("topAlarmLevel", String.valueOf(fb.topAlarmLevel));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
    }

    private void geAlarmStatus(int neID, int slotID, TELCTFunBlock functionblock) {
        TENE_NGWDM neobj = (TENE_NGWDM)TENEListMgr.getInstance().getNE(neID);
        Vector alarams = neobj.getAlarmList();
        ArrayList SupportAlmList = TEAlarmDataMgr.getInstance().getAlarmFbList(this.boardtype);
        functionblock.topAlarmLevel = 0;
        int size = alarams.size();
        for (int i = 0; i < size; ++i) {
            TEAlarm alarm = (TEAlarm)alarams.get(i);
            int slot = alarm.getSlotID();
            int port = alarm.getPort();
            int path = alarm.getPath();
            int fbType = alarm.getFuncBlock();
            if (functionblock.pathid > 0) {
                if (fbType != functionblock.functionType || port != functionblock.portid || slot != slotID || path != functionblock.pathid) continue;
                int AlarmLevel = alarm.getAlarmLevel();
                if (functionblock.topAlarmLevel > 0) {
                    if (AlarmLevel >= functionblock.topAlarmLevel) continue;
                    functionblock.topAlarmLevel = AlarmLevel;
                    break;
                }
                functionblock.topAlarmLevel = AlarmLevel;
                continue;
            }
            if (fbType != functionblock.functionType || port != functionblock.portid || slot != slotID) continue;
            int size2 = SupportAlmList.size();
            for (int k = 0; k < size2; ++k) {
                TEAlmFBObj alarmFb = (TEAlmFBObj)SupportAlmList.get(k);
                if (alarmFb.m_usFBType != fbType || alarmFb.m_usPortID != port || alarmFb.m_usPathID != path) continue;
                int AlarmLevel = alarm.getAlarmLevel();
                if (functionblock.topAlarmLevel > 0) {
                    if (AlarmLevel >= functionblock.topAlarmLevel) continue;
                    functionblock.topAlarmLevel = AlarmLevel;
                    continue;
                }
                functionblock.topAlarmLevel = AlarmLevel;
            }
        }
    }

    public String getDetailStr(RowParams rowparams) {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardtype);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotID);
        if (!subrackName.equals("")) {
            subrackName = subrackName + "-";
        }
        if (null == neObj) {
            return String.valueOf(this.neid) + "-" + subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID) + "-" + boardName;
        }
        return neObj.getNEName() + "-" + subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotID) + "-" + boardName;
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

