/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.channel;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.channel.ChannelPathNode;
import com.huawei.nglct.nelist.model.channel.TEChannelModeDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nemgr.necommon.fault.TEAlarmAdapterCache;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEChannelDataMgr {
    private static TEChannelDataMgr instance = null;

    private TEChannelDataMgr() {
    }

    public static synchronized TEChannelDataMgr getInstance() {
        if (null == instance) {
            instance = new TEChannelDataMgr();
        }
        return instance;
    }

    public String getNESlotBoardName(int neID, int slotID) {
        int boardType;
        StringBuffer sb = new StringBuffer();
        TENE neobj = TENEListMgr.getInstance().getNE(neID);
        if (neobj != null) {
            sb.append(neobj.getNEName()).append("-");
        }
        if (slotID > 0 && slotID != 255) {
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neID, (int)slotID);
            if (!"".equals(subrackName)) {
                sb.append(subrackName).append("-");
            }
            sb.append(TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID)).append("-");
        }
        if ((boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID)) > 0) {
            sb.append(TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType));
        }
        return sb.toString();
    }

    public List getLctFunBlockList(int neID, int slotID) {
        List portPropertyList;
        HashMap lastQueryWorkMode = new HashMap();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int iBoardType = mgr.getBoardType(neID, slotID);
        ArrayList<TELCTFunBlock> result = new ArrayList<TELCTFunBlock>();
        TELCTFunBlock funblock = new TELCTFunBlock();
        funblock.name = this.getNESlotBoardName(neID, slotID);
        funblock.id = "0";
        funblock.pid = "-1";
        funblock.seqenceLevel = 0;
        result.add(funblock);
        List boardFunPropertyList = mgr.getBoardFunBlockList(iBoardType);
        if (boardFunPropertyList != null && boardFunPropertyList.size() > 0) {
            int size = boardFunPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)boardFunPropertyList.get(i);
                int fbtype = fbproperty.getFuctionBlockType();
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int length = fbNoList.size();
                for (int j = 0; j < length; ++j) {
                    TELCTFunBlock fb = new TELCTFunBlock();
                    fb.id = funblock.id + "-" + result.size();
                    fb.pid = funblock.id;
                    fb.functionType = fbtype;
                    fb.pathid = 0;
                    fb.portid = 0;
                    fb.seqenceLevel = 1;
                    int id = j + 1;
                    fb.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbtype) + "-" + id;
                    result.add(fb);
                }
            }
        }
        if ((portPropertyList = mgr.getPortPropertyList(iBoardType)) != null && portPropertyList.size() > 0) {
            int size = portPropertyList.size();
            block6: for (int i = 0; i < size; ++i) {
                TEPortProperty portproperty = (TEPortProperty)portPropertyList.get(i);
                int portType = portproperty.getPortType();
                if (TEConfigurationDataMgr.getInstance().isWDMBoardType(neID, iBoardType) && portType != 61005) {
                    this.processWDMPort(portproperty, neID, iBoardType, "0", result, slotID, lastQueryWorkMode);
                    continue;
                }
                switch (portType) {
                    case 61005: {
                        this.processETHPort(portproperty, neID, iBoardType, "0", result, slotID);
                        continue block6;
                    }
                    case 1025: {
                        this.processMACPort(portproperty, neID, iBoardType, "0", result, slotID);
                        continue block6;
                    }
                    default: {
                        this.processSDHPort(portproperty, neID, iBoardType, "0", result, slotID);
                    }
                }
            }
        }
        return result;
    }

    public void processWDMPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID, HashMap lastQueryWorkMode) {
        block10: {
            TELCTFunBlock fb;
            ArrayList funblockPropertyList;
            block11: {
                if (null == portproperty) {
                    return;
                }
                int portNo = portproperty.getPortNo();
                funblockPropertyList = portproperty.getFunBlockPropertyList();
                if (portNo <= 0) break block10;
                fb = new TELCTFunBlock();
                StringBuffer portName = new StringBuffer(TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo));
                int indexOfSpecialChar = portName.indexOf("(");
                if (-1 != indexOfSpecialChar) {
                    portName.delete(0, indexOfSpecialChar + 1);
                    portName.deleteCharAt(portName.length() - 1);
                }
                fb.portName = portName.toString();
                fb.functionType = 10769;
                fb.pid = pid;
                fb.portid = portNo;
                fb.id = pid + "-" + result.size();
                result.add(fb);
                ArrayList channelModeData = (ArrayList)TEChannelModeDataMgr.getInstance().getChannelData(iBoardType, portNo);
                if (channelModeData == null) break block11;
                String workMode = null;
                int size = channelModeData.size();
                for (int i = 0; i < size; ++i) {
                    ChannelPathNode modeNode = (ChannelPathNode)channelModeData.get(i);
                    if (modeNode.isIsdynMode() && workMode == null) {
                        Integer key;
                        int relatedPort = modeNode.getRelatedPort();
                        if (relatedPort > 0) {
                            portNo = relatedPort;
                        }
                        if (lastQueryWorkMode.containsKey(key = new Integer(portNo))) {
                            workMode = (String)lastQueryWorkMode.get(key);
                        } else {
                            workMode = TEAlarmAdapterCache.getInstatce().getPortMode(neID, slotID, portNo);
                            lastQueryWorkMode.put(new Integer(portNo), workMode);
                        }
                    }
                    modeNode.convertToLCTFunBlock(fb, result, workMode, "");
                }
                break block10;
            }
            if (funblockPropertyList == null || funblockPropertyList.size() <= 0) break block10;
            int iiLength = funblockPropertyList.size();
            for (int ii = 0; ii < iiLength; ++ii) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                int funblocktype = fbproperty.getFuctionBlockType();
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int jjLength = fbNoList.size();
                for (int jj = 0; jj < jjLength; ++jj) {
                    TELCTFunBlock fbWdm2 = new TELCTFunBlock();
                    int id = jj + 1;
                    fbWdm2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                    fbWdm2.functionType = funblocktype;
                    fbWdm2.pid = fb.id;
                    fbWdm2.pathid = jj + 1;
                    fbWdm2.portid = fb.portid;
                    fbWdm2.id = fb.id + "-" + result.size();
                    result.add(fbWdm2);
                    if (iBoardType != 960 && iBoardType != 961) continue;
                    int fb2id = id + 1;
                    for (int i = 0; i < 3; ++i) {
                        fbWdm2 = new TELCTFunBlock();
                        fbWdm2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + fb2id;
                        fbWdm2.functionType = funblocktype;
                        fbWdm2.pid = fb.id;
                        fbWdm2.pathid = fb2id++;
                        fbWdm2.portid = fb.portid;
                        fbWdm2.id = fb.id + "-" + result.size();
                        result.add(fbWdm2);
                    }
                }
            }
        }
    }

    public void processMACPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock funbWDM = new TELCTFunBlock();
            funbWDM.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo);
            funbWDM.functionType = 11025;
            funbWDM.pid = pid;
            funbWDM.portid = portNo;
            funbWDM.id = pid + "-" + result.size();
            result.add(funbWDM);
            if (funblockPropertyList != null && funblockPropertyList.size() > 0) {
                int iiLength = funblockPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                    int funblocktype = fbproperty.getFuctionBlockType();
                    ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                    if (fbNoList == null || fbNoList.size() <= 0) continue;
                    int jjLength = fbNoList.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        TELCTFunBlock fb2 = new TELCTFunBlock();
                        int id = jj + 1;
                        fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                        fb2.functionType = funblocktype;
                        fb2.pid = funbWDM.id;
                        fb2.pathid = 1;
                        fb2.portid = funbWDM.portid;
                        fb2.id = funbWDM.id + "-" + result.size();
                        result.add(fb2);
                    }
                }
            }
        }
    }

    public void processSDHPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList fbPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0) {
            TELCTFunBlock fb = new TELCTFunBlock();
            fb.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, iBoardType, portNo);
            fb.functionType = 10256;
            fb.pid = pid;
            fb.portid = portNo;
            fb.id = pid + "-" + result.size();
            result.add(fb);
            if (fbPropertyList != null && fbPropertyList.size() > 0) {
                int iiLength = fbPropertyList.size();
                for (int ii = 0; ii < iiLength; ++ii) {
                    TEFunBlockProperty fbproperty = (TEFunBlockProperty)fbPropertyList.get(ii);
                    int funblocktype = fbproperty.getFuctionBlockType();
                    ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                    if (fbNoList == null || fbNoList.size() <= 0) continue;
                    int jjLength = fbNoList.size();
                    for (int jj = 0; jj < jjLength; ++jj) {
                        TELCTFunBlock funb2 = new TELCTFunBlock();
                        int id = jj + 1;
                        funb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                        funb2.functionType = funblocktype;
                        funb2.pid = fb.id;
                        funb2.pathid = jj + 1;
                        funb2.portid = fb.portid;
                        funb2.id = fb.id + "-" + result.size();
                        result.add(funb2);
                    }
                }
            }
        }
    }

    public void processETHPort(TEPortProperty portproperty, int neID, int iBoardType, String pid, List result, int slotID) {
        if (null == portproperty) {
            return;
        }
        int portNo = portproperty.getPortNo();
        ArrayList funblockPropertyList = portproperty.getFunBlockPropertyList();
        if (portNo > 0 && funblockPropertyList != null && funblockPropertyList.size() > 0) {
            int iiLength = funblockPropertyList.size();
            for (int ii = 0; ii < iiLength; ++ii) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)funblockPropertyList.get(ii);
                int funblocktype = fbproperty.getFuctionBlockType();
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int jjLength = fbNoList.size();
                for (int jj = 0; jj < jjLength; ++jj) {
                    TELCTFunBlock fb2 = new TELCTFunBlock();
                    int id = portNo & 0xFFF;
                    fb2.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(funblocktype) + "-" + id;
                    fb2.functionType = funblocktype;
                    fb2.pid = pid;
                    fb2.pathid = jj + 1;
                    fb2.portid = portNo;
                    fb2.id = pid + "-" + result.size();
                    fb2.seqenceLevel = 2;
                    result.add(fb2);
                }
            }
        }
    }
}

