/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bps;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEBpsMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEBpsDBMgr {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    private TEBpsDBMgr() {
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        normalLogger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeError(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    public static List<TEBpsMOPO> getAllBpsFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEBpsDBMgr.getBpsFromDB";
        normalLogger.info("TEBpsDBMgr.getBpsFromDB: begin.");
        ArrayList<TEBpsMOPO> bpsList = new ArrayList<TEBpsMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEBpsDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEBpsDBMgr.logFunEnd("TEBpsDBMgr.getBpsFromDB");
                return bpsList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEBpsMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEBpsMOPO.class);
        }
        catch (Exception e) {
            normalLogger.error("getBpsFromDB from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEBpsDBMgr.logFunEnd("TEBpsDBMgr.getBpsFromDB");
            return bpsList;
        }
        if (null == dbResult) {
            normalLogger.error("getBpsFromDB from db fail! dbResult is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEBpsDBMgr.logFunEnd("TEBpsDBMgr.getBpsFromDB");
            return bpsList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    bpsList.add((TEBpsMOPO)obj);
                }
            }
        } else {
            TEBpsDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEBpsDBMgr.logFunEnd("TEBpsDBMgr.getBpsFromDB");
        return bpsList;
    }

    public static void delBpsFromDB(int neID, TEBpsMOPO bps, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEBpsDBMgr.delBpsFromDB";
        normalLogger.info("TEBpsDBMgr.delBpsFromDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)bps) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)bps);
        }
        catch (Exception e) {
            normalLogger.error("delete bps from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEBpsDBMgr.logFunEnd("TEBpsDBMgr.delBpsFromDB");
            return;
        }
        if (null == dbResult) {
            TEBpsDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEBpsDBMgr.logFunEnd("TEBpsDBMgr.delBpsFromDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEBpsDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEBpsDBMgr.logFunEnd("TEBpsDBMgr.delBpsFromDB");
    }

    public static void delAllStgfreqFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEBpsDBMgr.delAllStgfreqFromDB";
        normalLogger.info("TEBpsDBMgr.delAllStgfreqFromDB: begin.");
        List<TEBpsMOPO> bpsList = TEBpsDBMgr.getAllBpsFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TEBpsDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TEBpsMOPO bps : bpsList) {
            TEBpsDBMgr.delBpsFromDB(neID, bps, errRet);
        }
        TEBpsDBMgr.logFunEnd("TEBpsDBMgr.delAllStgfreqFromDB");
    }

    public static void createBpsToDB(int neID, TEBpsMOPO bps, TEErrInfoReturn errRet) {
        String FUNCNAME = "TEBpsDBMgr.createBpsToDB";
        normalLogger.info("TEBpsDBMgr.createBpsToDB: begin.");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)bps) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)bps);
        }
        catch (Exception e) {
            TEBpsDBMgr.logExceptionErrorOnCreate(neID, e);
            errRet.setResult(1092743443);
            TEBpsDBMgr.logFunEnd("TEBpsDBMgr.createBpsToDB");
            return;
        }
        if (null == dbResult) {
            TEBpsDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEBpsDBMgr.logFunEnd("TEBpsDBMgr.createBpsToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEBpsDBMgr.logRetCodeError(neID, retCode);
            errRet.setResult(retCode);
        }
        TEBpsDBMgr.logFunEnd("TEBpsDBMgr.createBpsToDB");
    }

    private static void logNullNEError(int neID) {
        normalLogger.error("ne is null! neID->" + neID);
    }

    public static void updateBpsToDB(int neID, TEBpsMOPO mo, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)mo);
        }
        catch (Exception e) {
            String tipStr = "updateBpsToDB fail! ";
            normalLogger.error(tipStr, (Throwable)e);
            errRet.setResult(1092743443);
            return;
        }
        if (null == dbResult) {
            TEBpsDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            errRet.setResult(retCode);
        }
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get clock to db device fail! neID:%d, retCode:%d", neID, retCode);
        normalLogger.error(tipStr);
    }

    public static TEBpsMOPO getBpsByID(int neID, String id, TEErrInfoReturn errRet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Pgid", id);
        criteria.add(aPair);
        TEBpsMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TEBpsMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TEBpsMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEBpsMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                normalLogger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEBpsMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            normalLogger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEBpsMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    private static void logNullError(int neID) {
        normalLogger.error("delete clock to db device fail! neID->" + neID);
    }

    private static void logFunEnd(String funcName) {
        normalLogger.info(funcName + ": end.");
    }
}

