/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bps;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.bps.TEBPSData;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEBPSQueryBean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            ArrayList<String> firstOperationNameList = new ArrayList<String>();
            firstOperationNameList.add("NSCMD_CFG_GET_BPSPG");
            ArrayList<String> secondOperationNameList = new ArrayList<String>();
            secondOperationNameList.add("NSCMD_CFG_GET_BPSPGSTATE");
            secondOperationNameList.add("NSCMD_CFG_GET_BPSEXTPU");
            ArrayList firstOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, firstOperationNameList);
            ArrayList secondOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, secondOperationNameList);
            int firstResult = this.sendMessage(firstOperList);
            if (firstResult == 0) {
                if (this.structureSecondlyData(firstOperList, secondOperList)) {
                    int secondResult = this.sendMessage(secondOperList);
                    if (secondResult == 0) {
                        firstOperList.addAll(secondOperList);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)secondResult));
                    }
                }
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, firstOperList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)firstResult));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public int sendMessage(ArrayList operList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, (List)operList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    private boolean structureSecondlyData(ArrayList firstOperList, ArrayList secondOperList) {
        if (firstOperList.size() == 0) {
            return false;
        }
        ArrayList<Operation> tempListBps = new ArrayList<Operation>();
        int size = firstOperList.size();
        for (int i = 0; i < size; ++i) {
            Operation firstOperation = (Operation)firstOperList.get(i);
            Output[] outPutArray = firstOperation.getOutput();
            for (int j = 0; j < outPutArray.length; ++j) {
                String bpsID = outPutArray[j].getPartValue("bpsid");
                String bpsState = outPutArray[j].getPartValue("bpsstate");
                if (bpsID == null || bpsState == null || !bpsState.equals("3")) continue;
                int operationLen = secondOperList.size();
                for (int k = 0; k < operationLen; ++k) {
                    Operation aOperation = (Operation)((Operation)secondOperList.get(k)).clone();
                    aOperation.getInput().setPartValue("bpsid", bpsID);
                    tempListBps.add(aOperation);
                }
            }
        }
        secondOperList.clear();
        secondOperList.addAll(tempListBps);
        return secondOperList.size() != 0;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        ArrayList rowParamsListBps = this.outputData.getBussinessParams().getRowParamList();
        TEBPSData.getInstance().remove(String.valueOf(neid));
        int size = rowParamsListBps.size();
        for (int i = 0; i < size; ++i) {
            RowParams rowParamsBps = (RowParams)rowParamsListBps.get(i);
            RowErrors[] rowErrors = rowParamsBps.getRowErrors();
            if (rowErrors.length != 0) continue;
            String bpsID = rowParamsBps.getParam("bpsid").getValue();
            int wSlotID = Integer.valueOf(rowParamsBps.getParam("wslotid").getValue());
            int pSlotID = Integer.valueOf(rowParamsBps.getParam("pslotid").getValue());
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)wSlotID);
            if (!subrack.equals("")) {
                rowParamsBps.addParam("subrack", subrack);
            }
            rowParamsBps.addParam("wboardname", TEBPSQueryBean.getBoardName(neid, wSlotID));
            rowParamsBps.addParam("pboardname", TEBPSQueryBean.getBoardName(neid, pSlotID));
            rowParamsBps.addParam("mainunit", String.valueOf(wSlotID));
            rowParamsBps.addParam("backunit", String.valueOf(pSlotID));
            rowParamsBps.getParam("wslotid").setValue(String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)wSlotID)));
            rowParamsBps.getParam("pslotid").setValue(String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)pSlotID)));
            TEBPSData.getInstance().addSlotID(String.valueOf(neid), bpsID, String.valueOf(wSlotID));
            TEBPSData.getInstance().addSlotID(String.valueOf(neid), bpsID, String.valueOf(pSlotID));
        }
    }

    public boolean isNeedOperationlog() {
        String isNeedWriteLog = this.inputData.getBussinessParams().getRowParams(0).getParam("isNeedWriteLog").getValue();
        return Boolean.valueOf(isNeedWriteLog);
    }

    private static String getBoardName(int neid, int slotID) {
        int boradType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
        return TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boradType);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }
}

