/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnCircuitPackState;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnQueryNeCPStateReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnQueryNeCPStateRsp;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEgetBoardStateAndAlarm
implements TENEMgrInterface {
    public Datainterface outputData = null;
    private static final int BOARD_OUT_LOGIC = 1;
    private static final int BOARD_IN_RUN = 3;
    private static final int BOARD_IN_PHY = 2;
    private HashMap<Integer, TEBoard> usedSlotMap = new HashMap();
    private Map<Integer, TEBoard> logicBoardsMap = new HashMap<Integer, TEBoard>();
    private Map<Integer, List<Integer>> boardOccupySlotMap = new HashMap<Integer, List<Integer>>();
    private int shelfID = -1;
    private Logger log = TELogFactory.getNormalLogger();
    private int neid = -1;

    public boolean isNeedOperationlog() {
        return false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int ipAddr = IPAddressUtil.convertIPStrToInt((String)ipAddress);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
        this.shelfID = Integer.parseInt(inputRowParams.getParam("shelfID").getValue());
        this.neid = neid;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector logicBoardList = ne.getClonedBoardList();
        ArrayList<TEBoard> retBoardList = new ArrayList<TEBoard>();
        ArrayList<Integer> slotidList = new ArrayList<Integer>();
        for (TEBoard logicBoard : logicBoardList) {
            if (TEBoardUtil.isSupportShelfDevice((int)neid) && this.shelfID != TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)logicBoard.getSlotID())) continue;
            logicBoard.setState(1);
            this.logicBoardsMap.put(logicBoard.getSlotID(), logicBoard);
            List<Integer> slotList = this.getBoardOccupSlotList(neid, logicBoard.getSlotID(), logicBoard.getBoardType());
            for (Integer slot : slotList) {
                this.usedSlotMap.put(slot, logicBoard);
            }
            this.boardOccupySlotMap.put(logicBoard.getSlotID(), slotList);
            retBoardList.add(logicBoard);
            slotidList.add(logicBoard.getSlotID());
        }
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            Vector phyBoardList = ne.getPhyBoardList();
            for (TEBoard phyBoard : phyBoardList) {
                if (TEBoardUtil.isSupportShelfDevice((int)neid) && this.shelfID != TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)phyBoard.getSlotID())) continue;
                TEBoard logicBoard = this.logicBoardsMap.get(phyBoard.getSlotID());
                if (logicBoard != null && logicBoard.getBoardType() == phyBoard.getBoardType()) {
                    logicBoard.setState(3);
                    continue;
                }
                if (!this.isIdleSlot(neid, phyBoard)) continue;
                phyBoard.setState(2);
                retBoardList.add(phyBoard);
            }
        } else {
            TEConfigurationDataMgr.getInstance().startMethodBuffer(neid, slotidList);
            int result = this.getBoardStatusOnInter(ipAddr, neid, this.shelfID, Integer.parseInt(user), retBoardList);
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return this.outputData;
            }
            TEConfigurationDataMgr.getInstance().stopMethodBuffer(neid, slotidList);
        }
        for (TEBoard board : retBoardList) {
            RowParams rowparams = new RowParams();
            rowparams.addParam(new Param("slotID", String.valueOf(board.getSlotID())));
            rowparams.addParam(new Param("boardType", String.valueOf(board.getBoardType())));
            rowparams.addParam(new Param("boardName", board.getBoardTypeName()));
            rowparams.addParam(new Param("boardState", String.valueOf(board.getState())));
            rowparams.addParam(new Param("slotList", this.getOccupySlotStr(board)));
            rowparams.addParam(new Param("boardLoop", String.valueOf(board.getBoardLoop())));
            rowparams.addParam(new Param("boardPG", String.valueOf(board.getBoardPG())));
            rowparams.addParam(new Param("portList", this.getPortListStr(neid, board)));
            this.log.info("board.getState()===" + board.getSlotID() + "state=" + board.getState());
            int topAlm = 7;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                topAlm = ne.getCurTopLevelAlm(board.getSlotID());
            }
            rowparams.addParam(new Param("topAlmLevel", String.valueOf(topAlm)));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        this.log.info("retBoardList===" + retBoardList.size());
        return this.outputData;
    }

    private String getOccupySlotStr(TEBoard board) {
        StringBuilder occupySlotStr = new StringBuilder();
        List<Integer> occupySlotList = this.boardOccupySlotMap.get(board.getSlotID());
        for (Integer occupySlot : occupySlotList) {
            occupySlotStr.append(occupySlot).append(',');
        }
        occupySlotStr.deleteCharAt(occupySlotStr.length() - 1);
        return occupySlotStr.toString();
    }

    private String getPortListStr(int neid, TEBoard board) {
        List<Integer> portList = TEBD05FInterUtil.getInstallCPPort(board.getBoardType());
        ArrayList logicPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(neid, board.getSlotID());
        Collections.sort(portList);
        Collections.sort(logicPortList);
        StringBuilder portListStr = new StringBuilder();
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int portID = portList.get(i);
            portListStr.append(portID).append("-");
            portListStr.append("2").append("-");
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                portListStr.append("1").append("-");
            } else if (Collections.binarySearch(logicPortList, portID) >= 0) {
                portListStr.append("1").append("-");
            } else {
                portListStr.append("0").append("-");
            }
            portListStr.append('7');
            portListStr.append(',');
        }
        if (!portList.isEmpty()) {
            portListStr.deleteCharAt(portListStr.length() - 1);
        }
        return portListStr.toString();
    }

    private boolean isIdleSlot(int neID, TEBoard phyBoard) {
        List<Integer> occupySlotList = this.getBoardOccupSlotList(neID, phyBoard.getSlotID(), phyBoard.getBoardType());
        boolean isIdle = true;
        for (Integer occupySlotID : occupySlotList) {
            TEBoard logicBoard = this.usedSlotMap.get(occupySlotID);
            if (logicBoard == null) continue;
            logicBoard.setState(1);
            isIdle = false;
        }
        this.boardOccupySlotMap.put(phyBoard.getSlotID(), occupySlotList);
        return isIdle;
    }

    private List<Integer> getBoardOccupSlotList(int neid, int slotID, int boardType) {
        int offset = this.shelfID * 65536;
        TEBoardSlotInfo slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, this.shelfID, boardType, slotID - offset);
        ArrayList<Integer> slotIDList = new ArrayList<Integer>();
        if (null != slotInfo) {
            ArrayList tempusedList = slotInfo.getStandbySlotList();
            if (tempusedList.isEmpty()) {
                slotIDList.add(slotInfo.getDirectSlotid());
            } else {
                int size = tempusedList.size();
                for (int i = 0; i < size; ++i) {
                    slotIDList.add((Integer)tempusedList.get(i));
                }
            }
        } else {
            slotIDList.add(slotID - offset);
        }
        return slotIDList;
    }

    private int getBoardStatusOnInter(int ipAddr, int neID, int shelfID, int userID, List<TEBoard> retBoardList) {
        AsnQueryNeCPStateReq req = new AsnQueryNeCPStateReq();
        req.userID = userID;
        req.neID = neID;
        AsnQueryNeCPStateRsp rsp = new AsnQueryNeCPStateRsp();
        int result = TEBD05FInterUtil.sendCommand(neID, ipAddr, (FStruct)req, (FStruct)rsp, 2109779, 90);
        if (result == 0 && rsp.result.isSuccess) {
            for (AsnCircuitPackState cpInfo : rsp.cpStateList) {
                if (shelfID != TEBoardUtil.getSubrackIDFromSlot((int)neID, (int)cpInfo.slotID)) continue;
                int slotID = cpInfo.slotID;
                TEBoard board = this.logicBoardsMap.get(slotID);
                if (cpInfo.operationalState == 2) {
                    if (board != null && board.getBoardType() == cpInfo.circuitPackType) {
                        board.setState(3);
                        continue;
                    }
                    TEBoard phyBoard = new TEBoard(this.neid, cpInfo.slotID, cpInfo.circuitPackType);
                    if (!this.isIdleSlot(this.neid, phyBoard)) continue;
                    phyBoard.setState(2);
                    retBoardList.add(phyBoard);
                    continue;
                }
                if (board == null) continue;
                if (cpInfo.operationalState == 0) {
                    board.setState(3);
                } else {
                    board.setState(cpInfo.operationalState);
                }
                board.setBoardPG(cpInfo.workState);
                board.setBoardLoop(cpInfo.loopbackState);
            }
        }
        return result;
    }
}

