/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.asnattrib.AsnAttribValue;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnCPObjInfo;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCPObjInfoReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCPObjInfoRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCpMenuReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCpMenuRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeCPRemarkReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeCPRemarkRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnNECPRemark;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEShowBoardViewBean
extends TENEExplorerBean {
    private static final String PORT_LOOPBACK = "loopback";
    private static final String BOARD_REMARK = "boardRemark";
    private static final String BOARD_MENU = "boardMenu";
    private static final int ATTR_PORT_LOOPBACK = 517;
    public Logger log = TELogFactory.getNormalLogger();
    private final int[] filterMenuIDs = new int[]{204};
    private Map<Integer, Integer> portStateMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> portLoopbackMap = new HashMap<Integer, Integer>();

    public boolean isNeedOperationlog() {
        return false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.user = user;
        Arrays.sort(this.filterMenuIDs);
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        this.outputData.setBussinessParams(bussiness);
        RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
        int slotID = Integer.parseInt(inputRowParams.getParam("slotID").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
        int ipAddr = IPAddressUtil.convertIPStrToInt((String)ipAddress);
        String boardmark = this.getBoardRemark(neid, ipAddr, user, slotID);
        RowParams firstRowparams = new RowParams();
        firstRowparams.addParam(BOARD_REMARK, boardmark);
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            String interBoardmenu = "";
            if (boardType != -1) {
                interBoardmenu = this.getInterBoardMenuID(ipAddr, neid, slotID, boardType);
            }
            firstRowparams.addParam(BOARD_MENU, interBoardmenu);
        }
        this.outputData.getBussinessParams().addRowParams(firstRowparams);
        List<Integer> portList = TEBD05FInterUtil.getInstallCPPort(boardType);
        Collections.sort(portList);
        this.getExistPorts(slotID, ipAddr);
        int portState = 0;
        int loopback = 0;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            RowParams portRowparams = new RowParams();
            int portID = portList.get(i);
            portRowparams.addParam(new Param("portID", String.valueOf(portID)));
            portState = null == this.portStateMap.get(portID) ? 0 : this.portStateMap.get(portID);
            portRowparams.addParam(new Param("state", String.valueOf(portState)));
            TEPort port = TEPortModelConfigurationDataMgr.getInstance().buildTEPort(neid, slotID, portID);
            portRowparams.addParam(new Param("portType", TEBD05FInterUtil.getPortImageType(port)));
            loopback = null == this.portLoopbackMap.get(portID) ? 0 : this.portLoopbackMap.get(portID);
            portRowparams.addParam(new Param(PORT_LOOPBACK, String.valueOf(loopback)));
            this.outputData.getBussinessParams().addRowParams(portRowparams);
        }
        return this.outputData;
    }

    private String getBoardRemark(int neid, int ipAddr, String user, int slotID) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            return "";
        }
        AsnGetNeCPRemarkReq req = new AsnGetNeCPRemarkReq();
        req.userID = Integer.parseInt(user);
        req.neID = neid;
        req.slotID = slotID;
        AsnGetNeCPRemarkRsp rsp = new AsnGetNeCPRemarkRsp();
        int result = TEBD05FInterUtil.sendCommand(neid, ipAddr, (FStruct)req, (FStruct)rsp, 2105666, 90);
        if (result == 0 && rsp.cpRemarkList != null && !rsp.cpRemarkList.isEmpty()) {
            AsnNECPRemark asnRemark = (AsnNECPRemark)rsp.cpRemarkList.get(0);
            return new String(asnRemark.cpRemark);
        }
        return "";
    }

    private String getInterBoardMenuID(int ipAddr, int neID, int slotID, int boardType) {
        AsnGetCpMenuReq req = new AsnGetCpMenuReq();
        req.neID = BigInteger.valueOf(neID);
        req.slotID = BigInteger.valueOf(slotID);
        req.cpType = BigInteger.valueOf(boardType);
        StringBuilder menuIDs = new StringBuilder();
        int neType = TEGetNEDomainVersion.getInstance().getDevType(TEConfigurationDataMgr.getInstance().getNE(neID).getNEType());
        req.neType = BigInteger.valueOf(neType);
        HashMap<String, String> menuMap = new HashMap<String, String>();
        String temMenu = "";
        boolean isContains = false;
        AsnGetCpMenuRsp rsp = new AsnGetCpMenuRsp();
        int result = TEBD05FInterUtil.sendCommand(neID, ipAddr, (FStruct)req, (FStruct)rsp, 2257248, 90);
        if (result == 0) {
            int size = rsp.menuList.size();
            for (int i = 0; i < size; ++i) {
                int boardMenuID = ((BigInteger)rsp.menuList.get(i)).intValue();
                temMenu = String.valueOf(boardMenuID);
                if (Arrays.binarySearch(this.filterMenuIDs, boardMenuID) >= 0) continue;
                isContains = menuMap.containsKey(temMenu);
                if (!isContains) {
                    menuIDs.append(boardMenuID).append(',');
                }
                menuMap.put(temMenu, "in");
            }
        }
        if (menuIDs.length() > 0) {
            menuIDs.deleteCharAt(menuIDs.length() - 1);
        }
        return menuIDs.toString();
    }

    private void getExistPorts(int slotId, int ipAddr) {
        block5: {
            block4: {
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS != TESysManagerBean.getInstance().getSysStauts()) break block4;
                AsnGetCPObjInfoReq req = new AsnGetCPObjInfoReq();
                req.userID = Integer.parseInt(this.user);
                req.neID = this.neid;
                req.slotID = slotId;
                req.queryFromNE = 0;
                AsnGetCPObjInfoRsp rsp = new AsnGetCPObjInfoRsp();
                int result = TEBD05FInterUtil.sendCommand(this.neid, ipAddr, (FStruct)req, (FStruct)rsp, 2109572, 90);
                if (result != 0) {
                    return;
                }
                if (!rsp.result.isSuccess) break block5;
                int size = rsp.ttpList.size();
                block0: for (int i = 0; i < size; ++i) {
                    AsnCPObjInfo objInfo = (AsnCPObjInfo)rsp.ttpList.get(i);
                    if (objInfo.aidLoc.size() != 1 || objInfo.aidLoc.get(0) <= 1) continue;
                    int parentPortID = objInfo.aidLoc.get(0);
                    this.portStateMap.put(parentPortID &= 0xFF, 1);
                    int len = objInfo.info.size();
                    for (int j = 0; j < len; ++j) {
                        AsnAttribValue state = (AsnAttribValue)objInfo.info.get(j);
                        if (517 != state.attribID) continue;
                        this.portLoopbackMap.put(parentPortID, state.intValue);
                        continue block0;
                    }
                }
                break block5;
            }
            ArrayList existPorts = TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, slotId);
            int len = existPorts.size();
            for (int i = 0; i < len; ++i) {
                this.portStateMap.put((Integer)existPorts.get(i), 1);
            }
        }
    }
}

