/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.f_interface.asnattrib.AsnAttribValue;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNameAndValueString;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnBoardTipInfo;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnCPObjInfo;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetBoardTipInfoReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetBoardTipInfoRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCPObjInfoReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCPObjInfoRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnPortTipInfo;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEPortPathViewBean
extends TENEExplorerBean {
    private static final int ATTR_PORT_CHANGE_CFG = 532;
    private static final int ATTRTYPE_FUN_NAME = 515;
    private static final int ATTRTYPE_TTP_NAME = 771;
    private static final int ATTRTYPE_TTP_LOOPBACK = 773;
    private static final int ATTR_PORT_LOOPBACK = 517;
    private static final int ATTRTYPE_PAYLOAD_INDCT = 774;
    private static final int ATTRTYPE_USAGE_STATE = 775;
    private static final int ATTRTYPE_ALM_UNCLEARED = 785;
    private static final int ATTRTYPE_ALM_UNCONFIRMED = 786;
    private static final int ATTR_PORT_OPER_STATE = 520;
    private static final int ATTR_PORT_CAN_FIBERED = 528;
    private static final int ATTR_IS_SUP_ALM_REVERSION = 3085;
    private static final int ATTR_IS_SUP_ALM_SUPPRESSION = 3095;
    private static final int ATTR_ALL_IS_SUP_ALM = 1282;
    private static final int ATTR_PORT_DEFAULT_NAME = 521;
    private static final int ATTR_PORT_SUP_DYN_CFG = 530;
    public static final int ATTR_PATHOBJ_PATHID = 1537;
    public static final int SUPPORT = 1;
    public static final int NON_SUPPORT = 0;
    public int canDynPort = 0;
    public int canAddPort = 0;
    public int canDelPort = 0;
    public int canModifyPort = 0;
    private String Is_Sup_Dyn_Port = "Is_Sup_Dyn_Port";
    private String Is_Sup_Add_Port = "Is_Sup_Add_Port";
    private String Is_Discard_Port_Del_Menu = "Is_Discard_Port_Del_Menu";
    private int boardtype = -1;
    private int slotID = -1;
    private int portID = -1;
    private int neID = -1;
    private Datainterface outputData;
    private static String WAVELENGTH = "waveLength";
    private String portName = "";
    private int absoluteportID = -1;
    private Logger log = TELogFactory.getNormalLogger();
    private static final int[] trailSupportBlock = new int[]{1, 2, 3, 4, 5, 10, 11, 12, 14, 19, 21, 25, 61, 71, 200, 203, 206, 209, 210, 342, 351, 352, 353, 354, 355, 358, 359, 453, 456, 735, 750, 751, 752, 755, 801, 804, 807, 810, 820, 823, 826, 829, 832, 841, 871, 874, 880, 883, 1072, 1075, 1078, 1081, 1084, 1087, 1090, 1093, 1096, 1102, 1105, 1108, 1111, 1114, 1117, 1120, 1129, 1509, 1515, 1518, 1521, 1525, 1529, 1530, 1541, 1544, 1547, 1550, 1600, 1700, 1800, 1900, 2000, 892, 893, 894, 3019, 4297, 4306, 5339};
    private static final int[] protectedSubnetBlock = new int[]{1, 2, 3, 4};

    public Datainterface performBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neID;
        this.user = user;
        int ipAddr = IPAddressUtil.convertIPStrToInt((String)ipAddress);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        this.slotID = Integer.parseInt(slotinfo);
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        this.boardtype = cfgDataMgr.getBoardType(neID, this.slotID);
        Param portIDPara = inputData.getBussinessParams().getRowParams(0).getParam("portID");
        if (portIDPara != null) {
            this.portID = Integer.parseInt(portIDPara.getValue());
        }
        RowParams firstRowParam = new RowParams();
        this.outputData.getBussinessParams().addRowParams(firstRowParam);
        List<Object> funblockList = new ArrayList();
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            funblockList = this.queryPathInter(ipAddr);
        } else {
            this.portName = TEConfigurationDataMgr.getInstance().getPortName(neID, this.slotID, this.boardtype, this.portID);
            this.canAddPort = this.canDelPort = (this.canDynPort = TEConfigurationDataMgr.getInstance().isDynPort(neID, this.boardtype, this.portID) ? 1 : 0);
        }
        String waveLength = "";
        waveLength = TESysManagerBean.getInstance().isIntegratedStatus() ? this.getWaveLengthOnInter(ipAddr) : this.getWaveLenOnSingle(this.slotID, this.portID);
        firstRowParam.addParam(WAVELENGTH, waveLength);
        firstRowParam.addParam("canDelPort", String.valueOf(this.canDelPort));
        firstRowParam.addParam("canModifyPort", String.valueOf(this.canModifyPort));
        firstRowParam.addParam("canAddPort", String.valueOf(this.canAddPort));
        firstRowParam.addParam("canDynPort", String.valueOf(this.canDynPort));
        firstRowParam.addParam("portName", String.valueOf(this.portName));
        firstRowParam.addParam("portId", String.valueOf(this.absoluteportID));
        int size = funblockList.size();
        for (int i = 0; i < size; ++i) {
            TEInterFunBlock fb = (TEInterFunBlock)((Object)funblockList.get(i));
            RowParams rowParam = new RowParams();
            rowParam.addParam("id", fb.id);
            rowParam.addParam("pid", fb.pid);
            rowParam.addParam("name", fb.name);
            rowParam.addParam("portID", String.valueOf(fb.portid));
            rowParam.addParam("pathID", String.valueOf(fb.pathid));
            rowParam.addParam("functionType", String.valueOf(fb.functionType));
            rowParam.addParam("loopback", String.valueOf(fb.loopback));
            rowParam.addParam("payload", String.valueOf(fb.payload));
            rowParam.addParam("usageState", String.valueOf(fb.usageState));
            rowParam.addParam("portStatus", String.valueOf(fb.portStatus));
            rowParam.addParam("topAlarmLevel", String.valueOf(fb.topAlarmLevel));
            rowParam.addParam("isSupFiber", String.valueOf(fb.IsSupportFiber));
            rowParam.addParam("isSupAlmRe", String.valueOf(fb.isSupportAlarmReversion));
            rowParam.addParam("isSupAlmSup", String.valueOf(fb.isSupportAlarmSuppression));
            rowParam.addParam("unclearedAlarm", String.valueOf(fb.unclearedAlarm));
            rowParam.addParam("unconfirmedAlarm", String.valueOf(fb.unconfirmedAlarm));
            rowParam.addParam("isSupportAlarm", String.valueOf(fb.isSupportAlarm));
            rowParam.addParam("isSupE2E", this.isSupportQueryTrail(fb.functionType));
            rowParam.addParam("funBlockID", String.valueOf(fb.funBlockID));
            rowParam.addParam("bigPathID", String.valueOf(fb.bigPathID));
            rowParam.addParam("isSupProtectSubnet", this.isSupportQueryProtectSubNet(fb.functionType));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(neID, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    private String isSupportQueryTrail(int blockType) {
        return Arrays.binarySearch(trailSupportBlock, blockType) >= 0 ? "1" : "0";
    }

    private String isSupportQueryProtectSubNet(int blockType) {
        return Arrays.binarySearch(protectedSubnetBlock, blockType) >= 0 ? "1" : "0";
    }

    public String getDetailStr(RowParams rowparams) {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neID, this.boardtype);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)this.slotID);
        StringBuffer sb = new StringBuffer();
        if (null == neObj) {
            sb.append(String.valueOf(this.neID));
        } else {
            sb.append(neObj.getNEName());
        }
        if (!subrackName.equals("")) {
            sb.append("-").append(subrackName).append("-");
        }
        sb.append(TEBoardUtil.getSlotIDFromSlot((int)this.neID, (int)this.slotID)).append("-").append(boardName).append("-").append(String.valueOf(this.portID));
        return sb.toString();
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private List<TELCTFunBlock> queryPathInter(int ipAddr) {
        AsnGetCPObjInfoReq req = new AsnGetCPObjInfoReq();
        req.userID = Integer.parseInt(this.user);
        req.neID = this.neID;
        req.slotID = this.slotID;
        req.queryFromNE = 0;
        ArrayList<TELCTFunBlock> functionBlockList = new ArrayList<TELCTFunBlock>();
        AsnGetCPObjInfoRsp rsp = new AsnGetCPObjInfoRsp();
        int result = TEBD05FInterUtil.sendCommand(this.neID, ipAddr, (FStruct)req, (FStruct)rsp, 2109572, 90);
        if (result != 0) {
            return null;
        }
        if (rsp.result.isSuccess) {
            int i;
            functionBlockList.clear();
            int size = rsp.ttpList.size();
            for (i = 0; i < size; ++i) {
                TEInterFunBlock fb;
                AsnCPObjInfo objInfo = (AsnCPObjInfo)rsp.ttpList.get(i);
                int parentPortID = objInfo.aidLoc.get(0);
                if ((parentPortID &= 0xFF) != this.portID || objInfo.aidLoc.get(0) <= 1) continue;
                if (objInfo.aidLoc.size() > 1) {
                    fb = new TEInterFunBlock();
                    StringBuilder parentId = new StringBuilder();
                    StringBuilder pathIDBuider = new StringBuilder();
                    int jsize = objInfo.id.size() - 2;
                    for (int j = 0; j < jsize; ++j) {
                        parentId.append(objInfo.id.get(j));
                        pathIDBuider.append(objInfo.id.get(j)).append(',');
                    }
                    fb.pid = parentId.toString();
                    fb.functionType = objInfo.id.get(objInfo.id.size() - 2);
                    fb.id = parentId.toString() + fb.functionType + objInfo.aidLoc.get(objInfo.aidLoc.size() - 1);
                    pathIDBuider.append(fb.functionType).append(',').append(objInfo.id.get(objInfo.id.size() - 1));
                    fb.funBlockID = pathIDBuider.toString();
                    fb.pathid = objInfo.aidLoc.get(objInfo.aidLoc.size() - 1);
                    fb.portid = this.portID;
                    fb.seqenceLevel = objInfo.aidLoc.size();
                    this.setAttrs(objInfo, fb);
                    functionBlockList.add(fb);
                }
                if (objInfo.aidLoc.size() != 1) continue;
                fb = new TEInterFunBlock();
                fb.functionType = objInfo.id.get(objInfo.id.size() - 2);
                fb.id = fb.functionType + "" + objInfo.aidLoc.get(0);
                fb.pid = fb.functionType + "" + objInfo.aidLoc.get(0);
                fb.funBlockID = fb.functionType + "," + objInfo.aidLoc.get(0);
                fb.portid = this.portID;
                this.absoluteportID = objInfo.aidLoc.get(0);
                fb.seqenceLevel = objInfo.aidLoc.size();
                this.setAttrs(objInfo, fb);
                fb.name = fb.name.trim();
                fb.name = fb.name.length() > 0 ? fb.portName + "(" + fb.name + ")" : fb.portName;
                this.portName = fb.name;
                functionBlockList.add(fb);
            }
            size = rsp.nExAttribList.size();
            for (i = 0; i < size; ++i) {
                AsnNameAndValueString nvs = (AsnNameAndValueString)rsp.nExAttribList.get(i);
                if (nvs.name == null || nvs.value == null || nvs.name.length <= 0 || nvs.value.length <= 0) continue;
                String name = new String(nvs.name).trim();
                if (this.Is_Sup_Dyn_Port.equals(name)) {
                    this.canDynPort = Integer.parseInt(new String(nvs.value).trim());
                    continue;
                }
                if (this.Is_Sup_Add_Port.equals(name)) {
                    this.canAddPort = Integer.parseInt(new String(nvs.value).trim());
                    continue;
                }
                if (!this.Is_Discard_Port_Del_Menu.equals(name)) continue;
                this.canDelPort = Integer.parseInt(new String(nvs.value).trim());
            }
        }
        return functionBlockList;
    }

    private void setAttrs(AsnCPObjInfo asn, TEInterFunBlock fb) {
        int unclearedAlarm = 7;
        int unconfirmedAlarm = 7;
        int count = asn.info.size();
        block17: for (int k = 0; k < count; ++k) {
            AsnAttribValue state = (AsnAttribValue)asn.info.get(k);
            int attrID = state.attribID;
            switch (attrID) {
                case 517: 
                case 773: {
                    fb.loopback = state.intValue;
                    continue block17;
                }
                case 774: {
                    fb.payload = state.intValue;
                    continue block17;
                }
                case 775: {
                    fb.usageState = state.intValue;
                    continue block17;
                }
                case 785: {
                    fb.unclearedAlarm = state.intValue;
                    continue block17;
                }
                case 786: {
                    fb.unconfirmedAlarm = state.intValue;
                    continue block17;
                }
                case 515: 
                case 771: {
                    fb.name = new String(state.strValue);
                    continue block17;
                }
                case 520: {
                    fb.portStatus = state.intValue;
                    continue block17;
                }
                case 521: {
                    fb.portName = new String(state.strValue);
                    continue block17;
                }
                case 530: {
                    this.canDelPort = state.intValue;
                    continue block17;
                }
                case 528: {
                    fb.IsSupportFiber = state.intValue;
                    continue block17;
                }
                case 532: {
                    fb.canModifyPort = state.intValue;
                    if (asn.aidLoc.size() != 1) continue block17;
                    this.canModifyPort = fb.canModifyPort;
                    continue block17;
                }
                case 3085: {
                    fb.isSupportAlarmReversion = state.intValue;
                    continue block17;
                }
                case 3095: {
                    fb.isSupportAlarmSuppression = state.intValue;
                    continue block17;
                }
                case 1282: {
                    fb.isSupportAlarm = state.intValue;
                    continue block17;
                }
                case 1537: {
                    fb.bigPathID = state.intValue;
                    continue block17;
                }
            }
        }
        fb.topAlarmLevel = Math.min(unclearedAlarm, unconfirmedAlarm);
    }

    private String getWaveLengthOnInter(int ipAddr) {
        AsnGetBoardTipInfoReq req = new AsnGetBoardTipInfoReq();
        req.userID = BigInteger.valueOf(Integer.parseInt(this.user));
        req.neID = BigInteger.valueOf(this.neID);
        req.boardList.add((Object)BigInteger.valueOf(this.slotID));
        AsnGetBoardTipInfoRsp rsp = new AsnGetBoardTipInfoRsp();
        int result = TEBD05FInterUtil.sendCommand(this.neID, ipAddr, (FStruct)req, (FStruct)rsp, 2106037, 90);
        int bandType = -1;
        int waveNo = -1;
        if (result == 0) {
            int size = rsp.boardInfoList.size();
            block0: for (int i = 0; i < size; ++i) {
                AsnBoardTipInfo boardTip = (AsnBoardTipInfo)rsp.boardInfoList.get(i);
                int jsize = boardTip.portInfoList.size();
                for (int j = 0; j < jsize; ++j) {
                    AsnPortTipInfo portTip = (AsnPortTipInfo)boardTip.portInfoList.get(j);
                    if (portTip.portID != this.absoluteportID) continue;
                    bandType = portTip.workband;
                    waveNo = portTip.gnlwaveno;
                    continue block0;
                }
            }
        } else {
            this.log.debug("getWaveLengthOnInter failed" + TEErrorResourceUtil.getErrorMessage((int)result));
        }
        TEWaveLengthInfoStaticData waveLengthDataInstance = TEWaveLengthInfoStaticData.getInstance();
        int ALL_PARITY = 0;
        Map waveLengthMap = waveLengthDataInstance.getWaveLengthInfoMap(bandType, ALL_PARITY, Integer.MAX_VALUE);
        Iterator itr = waveLengthMap.entrySet().iterator();
        String waveString = "";
        while (itr.hasNext()) {
            Map.Entry etry = itr.next();
            int tempWaveNo = waveLengthDataInstance.getWaveNoByCustNO(bandType, String.valueOf(etry.getKey()));
            if (tempWaveNo != (waveNo & 0xFFFF)) continue;
            waveString = (String)waveLengthMap.get(etry.getKey());
            break;
        }
        StringBuilder retVal = new StringBuilder();
        if (!waveString.isEmpty()) {
            String[] waveArr = waveString.split("/");
            retVal.append(waveArr[0]).append('/').append(waveArr[1]).append("nm").append('/').append(waveArr[2]).append("THz");
        }
        return retVal.toString();
    }

    private String getWaveLenOnSingle(int slotId, int portId) {
        String waveLen = "";
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_GET_WAVELEN");
        Input input = oper.getInput();
        input.setPartValue("slotid", String.valueOf(slotId));
        input.setPartValue("port", String.valueOf(portId));
        operationList.add(oper.clone());
        TECommuNEMgr.getInstance().sendCommand(this.neID, operationList, this.getTimeOut(), this.subfunc);
        oper = (Operation)operationList.get(0);
        Output[] outputArr = oper.getOutput();
        int waveType = 0;
        int waveNum = 0;
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            Fault[] faults = outputArr[i].getFault();
            int count = faults.length;
            for (int j = 0; j < count; ++j) {
                if (Integer.parseInt(faults[j].getCode()) == 0) continue;
                return waveLen;
            }
            if (outputArr[i].getPart(i).getName().equals("W32BRD_ATTR_WDMTYPE")) {
                waveType = Integer.parseInt(outputArr[i].getPartValue("W32BRD_ATTR_WDMTYPE"));
            }
            if (!outputArr[i].getPart(i).getName().equals("W32PORT_ATTR_WAVELENTYPE")) continue;
            waveNum = Integer.parseInt(outputArr[i].getPartValue("W32PORT_ATTR_WAVELENTYPE"));
        }
        TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();
        waveLen = waveLeninfo.getNumberWaveLengthFrequency(waveType, waveNum);
        return waveLen;
    }

    class TEInterFunBlock
    extends TELCTFunBlock {
        private int IsSupportFiber = 1;
        private int isSupportAlarmReversion = 0;
        private int isSupportAlarmSuppression = 0;
        private int unclearedAlarm = 7;
        private int unconfirmedAlarm = 7;
        private int isSupportAlarm = 1;
        private String funBlockID = "";
        private int bigPathID = -1;

        TEInterFunBlock() {
        }
    }
}

