/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCpMenuReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCpMenuRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeCPRemarkReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeCPRemarkRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnNECPRemark;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import net.commustru.fstru.FStruct;

public class TEGetSubBoardMenuBean
implements TENEMgrInterface {
    private Datainterface outputData = null;
    private final int[] filterMenuIDs = new int[]{101, 104, 134, 204, 500};
    private static final String BOARD_REMARK = "boardRemark";
    private static final String BOARD_MENU = "boardMenu";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Arrays.sort(this.filterMenuIDs);
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        this.outputData.setBussinessParams(bussiness);
        RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
        int slotID = Integer.parseInt(inputRowParams.getParam("slotID").getValue());
        int subSlotID = Integer.parseInt(inputRowParams.getParam("subSlotID").getValue());
        int subBoardType = Integer.parseInt(inputRowParams.getParam("subBoardType").getValue());
        int ipAddr = IPAddressUtil.convertIPStrToInt((String)ipAddress);
        String boardmark = this.getBoardRemark(neid, ipAddr, user, slotID);
        RowParams firstRowparams = new RowParams();
        firstRowparams.addParam(BOARD_REMARK, boardmark);
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            String interBoardmenu = this.getInterBoardMenuID(ipAddr, neid, subSlotID, subBoardType);
            firstRowparams.addParam(BOARD_MENU, interBoardmenu);
        }
        this.outputData.getBussinessParams().addRowParams(firstRowparams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.outputData;
    }

    private String getInterBoardMenuID(int ipAddr, int neID, int slotID, int subBoardType) {
        AsnGetCpMenuReq req = new AsnGetCpMenuReq();
        req.neID = BigInteger.valueOf(neID);
        req.slotID = BigInteger.valueOf(slotID);
        req.cpType = BigInteger.valueOf(subBoardType);
        StringBuilder menuIDs = new StringBuilder();
        int neType = TEGetNEDomainVersion.getInstance().getDevType(TEConfigurationDataMgr.getInstance().getNE(neID).getNEType());
        req.neType = BigInteger.valueOf(neType);
        HashMap<String, String> menuMap = new HashMap<String, String>();
        String temMenu = "";
        boolean isContains = false;
        AsnGetCpMenuRsp rsp = new AsnGetCpMenuRsp();
        int result = TEBD05FInterUtil.sendCommand(neID, ipAddr, (FStruct)req, (FStruct)rsp, 2257248, 90);
        if (result == 0) {
            int size = rsp.menuList.size();
            for (int i = 0; i < size; ++i) {
                int boardMenuID = ((BigInteger)rsp.menuList.get(i)).intValue();
                temMenu = String.valueOf(boardMenuID);
                if (Arrays.binarySearch(this.filterMenuIDs, boardMenuID) >= 0) continue;
                isContains = menuMap.containsKey(temMenu);
                if (!isContains) {
                    menuIDs.append(boardMenuID).append(',');
                }
                menuMap.put(temMenu, "in");
            }
        }
        if (menuIDs.length() > 0) {
            menuIDs.deleteCharAt(menuIDs.length() - 1);
        }
        return menuIDs.toString();
    }

    private String getBoardRemark(int neid, int ipAddr, String user, int slotID) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            return "";
        }
        AsnGetNeCPRemarkReq req = new AsnGetNeCPRemarkReq();
        req.userID = Integer.parseInt(user);
        req.neID = neid;
        req.slotID = slotID;
        AsnGetNeCPRemarkRsp rsp = new AsnGetNeCPRemarkRsp();
        int result = TEBD05FInterUtil.sendCommand(neid, ipAddr, (FStruct)req, (FStruct)rsp, 2105666, 90);
        if (result == 0 && rsp.cpRemarkList != null && !rsp.cpRemarkList.isEmpty()) {
            AsnNECPRemark asnRemark = (AsnNECPRemark)rsp.cpRemarkList.get(0);
            return new String(asnRemark.cpRemark);
        }
        return "";
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

