/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeSupportedCPsForCfgWizardReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeSupportedCPsForCfgWizardRsp;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeSupportedCircuitPacksReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetNeSupportedCircuitPacksRsp;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEAddBoardActionOnSingle;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.commustru.fstru.FStruct;

public class TECalulateBoardOnInter
implements TENEMgrInterface {
    private Datainterface output = new Datainterface();
    private int slotID = -11;
    private int subSlotID = 0;
    private int neID = -1;
    private int neType = -1;

    public boolean isNeedOperationlog() {
        return false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.output = new Datainterface();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        this.neID = neid;
        this.neType = ne.getNEType();
        int shelfType = -1;
        int ipAddr = IPAddressUtil.convertIPStrToInt((String)ipAddress);
        this.output.setBussinessParams(new BussinessParams());
        RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
        this.slotID = Integer.parseInt(inputRowParams.getParam("slotID").getValue());
        if (null != inputRowParams.getParam("subSlotID")) {
            this.subSlotID = Integer.parseInt(inputRowParams.getParam("subSlotID").getValue());
        }
        boolean isWizardConfig = false;
        if (inputRowParams.getParam("interShelfType") != null) {
            shelfType = Integer.parseInt(inputRowParams.getParam("interShelfType").getValue());
        }
        if (inputRowParams.getParam("isWizardConfig") != null) {
            boolean bl = isWizardConfig = Integer.parseInt(inputRowParams.getParam("isWizardConfig").getValue()) == 1;
        }
        if (isWizardConfig) {
            this.neType = Integer.parseInt(inputRowParams.getParam("interNEType").getValue());
            this.getWizInstallBoard(ipAddr, this.slotID, shelfType, user);
        } else {
            this.getNeSuppportBoards(neid, ipAddr, user);
        }
        return this.output;
    }

    private void getNeSuppportBoards(int neid, int ipAddr, String user) {
        AsnGetNeSupportedCircuitPacksReq req = new AsnGetNeSupportedCircuitPacksReq();
        req.userID = BigInteger.valueOf(Integer.parseInt(user));
        req.neID = BigInteger.valueOf(this.neID);
        req.slotID = BigInteger.valueOf(this.slotID);
        AsnGetNeSupportedCircuitPacksRsp rsp = new AsnGetNeSupportedCircuitPacksRsp();
        int result = TEBD05FInterUtil.sendCommand(neid, ipAddr, (FStruct)req, (FStruct)rsp, 2109573, 90);
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        if (result == 0) {
            if (rsp.result.isSuccess) {
                int resultLength = rsp.circuitPackTypeList.size();
                for (int i = 0; i < resultLength; ++i) {
                    int boardType = ((BigInteger)rsp.circuitPackTypeList.get(i)).intValue();
                    String boardName = cpDesc.getTypeName(boardType);
                    int subrackId = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)this.slotID);
                    int tempSlotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)this.slotID);
                    String ocupSlotStr = "";
                    TEBoardSlotInfo slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardType, tempSlotID);
                    ocupSlotStr = null != slotInfo ? slotInfo.toString() : tempSlotID + "";
                    this.addBoardToOutput(neid, boardType, boardName, ocupSlotStr);
                }
                this.sortBoard();
                ErrorMessage errorMessage = TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)result);
                this.output.setErrorMessage(errorMessage);
            } else {
                ErrorMessage errorMessage = TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)rsp.result.getRetCode());
                this.output.setErrorMessage(errorMessage);
            }
        } else {
            ErrorMessage errorMessage = TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)result);
            this.output.setErrorMessage(errorMessage);
        }
    }

    private void addBoardToOutput(int neid, int boardType, String boardName, String ocupSlotStr) {
        String[] slotArray;
        RowParams rowparam = new RowParams();
        Param param = null;
        param = new Param("boardType", String.valueOf(boardType));
        rowparam.addParam(param);
        param = new Param("boardName", boardName);
        rowparam.addParam(param);
        StringBuffer sb = new StringBuffer();
        for (String element : slotArray = ocupSlotStr.split(",")) {
            sb.append(TEBoardUtil.getSlotIDFromSlot((int)neid, (int)Integer.parseInt(element))).append(",");
        }
        String tmp = sb.toString();
        ocupSlotStr = tmp.substring(0, tmp.length() - 1);
        TEAddBoardActionOnSingle.getOccupySlotList(neid, this.slotID, boardType, rowparam);
        param = new Param("issupportsubcard", String.valueOf(TEBD05FInterUtil.isSupportSubCard(boardType)));
        rowparam.addParam(param);
        param = new Param("supportsubtypes", TEBD05FInterUtil.getSupportSubCardTypes(neid, boardType, this.subSlotID));
        rowparam.addParam(param);
        this.output.getBussinessParams().addRowParams(rowparam);
    }

    private void sortBoard() {
        ArrayList rowParamList = this.output.getBussinessParams().getRowParamList();
        Collections.sort(rowParamList, new Comparator<RowParams>(){

            @Override
            public int compare(RowParams o1, RowParams o2) {
                return o1.getParam("boardName").toString().compareTo(o2.getParam("boardName").toString());
            }
        });
    }

    private void getWizInstallBoard(int ipAddr, int slotID, int shelfType, String user) {
        AsnGetNeSupportedCPsForCfgWizardReq req = new AsnGetNeSupportedCPsForCfgWizardReq();
        req.userID = Integer.parseInt(user);
        req.neID = this.neID;
        req.slotID = slotID;
        req.type = this.neType;
        req.neShelfType = shelfType;
        req.usedAsExtendedShelf = false;
        AsnGetNeSupportedCPsForCfgWizardRsp response = new AsnGetNeSupportedCPsForCfgWizardRsp();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        int result = TEBD05FInterUtil.sendCommand(this.neID, ipAddr, (FStruct)req, (FStruct)response, 2109578, 90);
        if (result == 0) {
            if (0 == result && response.result != null && response.result.isSuccess) {
                int resultLength = response.circuitPackTypeList.size();
                for (int i = 0; i < resultLength; ++i) {
                    int boardType = ((BigInteger)response.circuitPackTypeList.get(i)).intValue();
                    String boardName = cpDesc.getTypeName(boardType);
                    int subrackId = TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)slotID);
                    int tempSlotID = TEBoardUtil.getSlotIDFromSlot((int)this.neID, (int)slotID);
                    String ocupSlotStr = "";
                    TEBoardSlotInfo slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(this.neID, subrackId, boardType, tempSlotID);
                    ocupSlotStr = null != slotInfo ? slotInfo.toString() : tempSlotID + "";
                    this.addBoardToOutput(this.neID, boardType, boardName, ocupSlotStr);
                }
                this.sortBoard();
                ErrorMessage errorMessage = TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)result);
                this.output.setErrorMessage(errorMessage);
            } else {
                ErrorMessage errorMessage = TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)response.result.getRetCode());
                this.output.setErrorMessage(errorMessage);
            }
        } else {
            ErrorMessage errorMessage = TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)result);
            this.output.setErrorMessage(errorMessage);
        }
    }
}

