/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEBoardGraphBean
implements TENEMgrInterface {
    public static final String OPTIXNE_ID_PARAM = "ONE_neID";
    public static final String SLOT_ID_PARAM = "slotID";
    public static final String PORT_ID_PARAM = "portID";
    static final String SHELF_ID_PARAM = "shelfID";
    public static final String BOARD_TYPE_PARAM = "boardType";
    public static final String BOARD_NAME_PARAM = "boardName";
    public static final String PORT_LIST_PARAM = "portList";
    public static final String BOARD_LOOP_PARAM = "boardLoop";
    public static final String BOARD_PG_PARAM = "boardPG";
    public static final String TOP_ALARM_LEVEL = "topAlmLevel";
    public Datainterface outputData = null;
    public static final String BOARD_STATE_PARAM = "boardState";
    private Logger log = TELogFactory.getNormalLogger();
    public static final String BOARD_SLOT_LIST_PARAM = "slotList";
    public static final String SUB_BOARD_LIST_PARAM = "subBoardList";
    private static final String SUB_CARD_SUPPORT = "issupportsubcard";
    private static final String SUB_BOARD_NUM = "subboardnum";
    private static final String SUPPORT_CARD_TYPES = "supportsubtypes";
    public static final String SUB_CARD_ID = "subcardid";
    public static final String SUB_CARD_TYPE = "subcardtype";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neid);
            if (0 != retCode) {
                TEBoardGraphBean.logConnectNEFail(neid, retCode);
            }
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
            int shelfID = Integer.parseInt(inputRowParams.getParam(SHELF_ID_PARAM).getValue());
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            Vector boardList = ne.getClonedBoardList();
            this.log.debug("getBoardList= " + boardList.size());
            for (TEBoard board : boardList) {
                RowParams rowparams = new RowParams();
                if (TEBoardUtil.isSupportShelfDevice((int)neid) && shelfID != board.getSlotID() / 65536) continue;
                rowparams.addParam(new Param(SLOT_ID_PARAM, String.valueOf(board.getSlotID())));
                rowparams.addParam(new Param(BOARD_TYPE_PARAM, String.valueOf(board.getBoardType())));
                rowparams.addParam(new Param(BOARD_NAME_PARAM, board.getBoardTypeName()));
                rowparams.addParam(new Param(BOARD_STATE_PARAM, String.valueOf(board.getState())));
                StringBuilder portListStr = new StringBuilder();
                List<Integer> portList = TEBD05FInterUtil.getInstallCPPort(board.getBoardType());
                for (Integer portNo : portList) {
                    portListStr.append(portNo).append(',');
                }
                if (!portList.isEmpty()) {
                    portListStr.deleteCharAt(portListStr.length() - 1);
                }
                rowparams.addParam(new Param(PORT_LIST_PARAM, portListStr.toString()));
                this.getOccupySlotList(neid, board.getSlotID(), board.getBoardType(), rowparams);
                boolean isSupport = TEBD05FInterUtil.isSupportSubCard(board.getBoardType());
                rowparams.addParam(new Param(SUB_CARD_SUPPORT, String.valueOf(isSupport)));
                int subBoardNum = TEBD05FInterUtil.getSubBoardNum(board.getBoardType());
                rowparams.addParam(new Param(SUB_BOARD_NUM, String.valueOf(subBoardNum)));
                String supportSubTypes = TEBD05FInterUtil.getSupportSubCardTypes(neid, board.getBoardType(), 1);
                rowparams.addParam(new Param(SUPPORT_CARD_TYPES, String.valueOf(supportSubTypes)));
                List<TESubBoard> subBoardList = TEBD05FInterUtil.getInstallCPSubBoard(neid, board);
                StringBuilder subBoardListStr = new StringBuilder();
                for (TESubBoard subBoardInfo : subBoardList) {
                    subBoardListStr.append(subBoardInfo.getNeid()).append('|').append(subBoardInfo.getState()).append('|').append(subBoardInfo.getSubBoardName()).append('|').append(subBoardInfo.getSubBoardType()).append('|').append(subBoardInfo.getSubSlotID()).append(',');
                }
                if (!subBoardList.isEmpty()) {
                    subBoardListStr.deleteCharAt(subBoardListStr.length() - 1);
                }
                rowparams.addParam(new Param(SUB_BOARD_LIST_PARAM, subBoardListStr.toString()));
                this.outputData.getBussinessParams().addRowParams(rowparams);
                this.log.debug("portListStr= " + portListStr + ":subBoardListStr=" + subBoardListStr + ":board= " + board.getBoardType() + ":" + (board.getSlotID() - 65536 * shelfID));
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        catch (Exception e) {
            this.log.error("Get board error\u00a3\u00ba", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
    }

    private static void logConnectNEFail(int neID, int retCode) {
        String tipStr = "login nefail!";
        tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
        TELogFactory.getNormalLogger().error(tipStr);
    }

    private void getOccupySlotList(int neid, int bigSlotid, int boardtype, RowParams rowparams) {
        int subrackId = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)bigSlotid);
        int slotid = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)bigSlotid);
        String slotList = "";
        TEBoardSlotInfo slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid);
        slotList = null != slotInfo ? slotInfo.toString() : slotid + "";
        Param boardslotlist = new Param(BOARD_SLOT_LIST_PARAM, slotList);
        rowparams.addParam(boardslotlist);
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

