/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallSubCPRecord;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnCPObjInfo;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCPObjInfoReq;
import com.huawei.nglct.nemgr.f_interface.bscfg.AsnGetCPObjInfoRsp;
import com.huawei.nglct.util.string.TEConvertUtil;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TEBD05FInterUtil {
    public static final String ELECTRIC_PORT_IMG = "0";
    public static final String OPTIC_DOUBLE_PORT_IMG = "2";
    public static final String OPTIC_SINGLE_PORT_IMG = "1";
    public static TEProcID faultProcID = new TEProcID('8', '\u0000');
    public static int FAULT_CMD_NB_ALM_LEVEL_STAT_REQ = 4547;
    public static final String PORT_INSTALL = "1";
    public static final String PORT_UNINSTALL = "0";
    public static final String PORT_STATE = "state";
    public static final String PORT_IMAGE = "portType";

    private static int getProcID(int neid, TEProcID procID) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID((int)neid, (ProcessInfo)processInfo);
        if (result == 0) {
            procID.setProcHandle(processInfo.getProcHandle().charValue());
            procID.setProcID(processInfo.getProcID().charValue());
        }
        return result;
    }

    public static int sendCommand(int neid, int ipAddr, FStruct req, FStruct rsp, int command, int timeOut) {
        TEProcID procID = new TEProcID();
        int result = TEBD05FInterUtil.getProcID(neid, procID);
        TELogFactory.getInterfaceLogger().debug(TEAsn1Util.getAsn1String((Object)req));
        if (result == 0) {
            result = TEASN1CommMgr.sendCommand((int)ipAddr, (TEProcID)procID, (FStruct)req, (FStruct)rsp, (int)command, (int)timeOut);
        }
        TELogFactory.getInterfaceLogger().debug(TEAsn1Util.getAsn1String((Object)rsp));
        return result;
    }

    public static List<Integer> getInstallCPPort(int boardType) {
        ArrayList installPortList = new ArrayList();
        ArrayList<Integer> installCPPortList = new ArrayList<Integer>();
        ArrayList portList = null;
        TEInstallCPPortRecord portRecord = null;
        int portId = 0;
        List portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = (TEInstallCPPortRecord)portRecordList.get(i);
            portList = portRecord.getPortIDList();
            if (installPortList.containsAll(portList)) continue;
            installPortList.addAll(portList);
        }
        for (int j = 0; j < installPortList.size(); ++j) {
            portId = (Integer)installPortList.get(j);
            if (portId >= 50 || installCPPortList.contains(portId)) continue;
            installCPPortList.add(portId);
        }
        return installCPPortList;
    }

    public static List<Integer> getDynPortList(int neid, int boardType) {
        ArrayList<Integer> allDynPorts = new ArrayList<Integer>();
        int neVersion = TEConvertUtil.convertVerStrToInt((String)TENEListMgr.getInstance().getNE(neid).getHostVersion());
        TECPAddiblePortRecord addiblePortRecord = null;
        List addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
        int n = addiblePortRecordList.size();
        for (int j = 0; j < n; ++j) {
            addiblePortRecord = (TECPAddiblePortRecord)addiblePortRecordList.get(j);
            if (!addiblePortRecord.isWithInRange(neVersion)) continue;
            allDynPorts.add(addiblePortRecord.portID);
        }
        return allDynPorts;
    }

    public static String getPortImageType(TEPort port) {
        String portType = "0";
        switch (port.getPortType()) {
            case 1025: 
            case 1799: {
                portType = port.isOpticalPort() ? OPTIC_DOUBLE_PORT_IMG : "0";
                break;
            }
            case 256: 
            case 1798: {
                portType = port.isOpticalPort() ? OPTIC_DOUBLE_PORT_IMG : "0";
                break;
            }
            case 769: {
                int realAddibleType = port.getPortAddibleType() >> 8 & 0xFF;
                if (realAddibleType == 2 || realAddibleType == 3) {
                    portType = "1";
                }
                return portType;
            }
            default: {
                if ((port.getPortAddibleType() & 0xFF) != 1) break;
                portType = OPTIC_DOUBLE_PORT_IMG;
            }
        }
        return portType;
    }

    public static List<Integer> getLogicPortListOnInter(int ipAddr, String user, int neID, int slotID) {
        AsnGetCPObjInfoReq req = new AsnGetCPObjInfoReq();
        req.userID = Integer.parseInt(user);
        req.neID = neID;
        req.slotID = slotID;
        req.queryFromNE = 0;
        ArrayList functionBlockList = new ArrayList();
        AsnGetCPObjInfoRsp rsp = new AsnGetCPObjInfoRsp();
        int result = TEBD05FInterUtil.sendCommand(neID, ipAddr, (FStruct)req, (FStruct)rsp, 2109572, 90);
        if (result != 0) {
            return new ArrayList<Integer>();
        }
        if (rsp.result.isSuccess) {
            ArrayList<Integer> portList = new ArrayList<Integer>();
            functionBlockList.clear();
            int size = rsp.ttpList.size();
            for (int i = 0; i < size; ++i) {
                AsnCPObjInfo objInfo = (AsnCPObjInfo)rsp.ttpList.get(i);
                if (objInfo.aidLoc.size() != 1 || objInfo.aidLoc.get(0) <= 1) continue;
                int parentPortID = objInfo.aidLoc.get(0);
                portList.add(parentPortID &= 0xFF);
            }
            return portList;
        }
        return new ArrayList<Integer>();
    }

    public static List<TESubBoard> getInstallCPSubBoard(int neid, TEBoard board) {
        List subBoardList = board.getSubBoardList();
        TESubBoard subBoard = null;
        int size = subBoardList.size();
        for (int i = 0; i < size; ++i) {
            subBoard = (TESubBoard)subBoardList.get(i);
            subBoard.setSubBoardName(TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subBoard.getSubBoardType()));
        }
        return subBoardList;
    }

    public static boolean isSupportSubCard(int boardType) {
        boolean isSupport = false;
        isSupport = TEBoardConfigurationDataMgr.getInstance().isSupportSubCard(boardType);
        return isSupport;
    }

    public static String getSupportSubCardTypes(int neID, int boardType, int subSlotID) {
        TEInstallSubCPRecord subBoardType;
        StringBuilder subBoardTypeListStr = new StringBuilder();
        if (TEBD05FInterUtil.isSupportSubCard(boardType) && null != (subBoardType = TECircuitPackDescription.getInstance().getInstallSubCPType(boardType, subSlotID))) {
            int len = subBoardType.subCPTypeList.size();
            for (int i = 0; i < len; ++i) {
                int subBoardTypeID = Integer.parseInt(subBoardType.subCPTypeList.get(i).toString());
                String subBoardTypeName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, subBoardTypeID);
                subBoardTypeListStr.append(subBoardTypeID).append('-').append(subBoardTypeName).append(',');
            }
            if (!subBoardType.subCPTypeList.isEmpty()) {
                subBoardTypeListStr.deleteCharAt(subBoardTypeListStr.length() - 1);
            }
        }
        return subBoardTypeListStr.toString();
    }

    public static int getSubBoardNum(int boardType) {
        int subBoardNum = TECircuitPackDescription.getInstance().getSubCPNum(boardType);
        return subBoardNum;
    }
}

