/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.bd05boardgrah;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.nemgr.ngwdm.bd05boardgrah.TEBD05FInterUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEAddBoardActionOnSingle
extends TENEExplorerBean {
    private static final int TIME_OUT = 20;
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    public static final String BOARD_SLOT_LIST_PARAM = "slotList";

    public int getTimeOut() {
        return 20;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation addBoardOperation = (Operation)operationList.get(0);
        Part part = Definitions.getParam((Part[])addBoardOperation.getInput().getPart(), (String)SLOT_ID_PARAM);
        int slotID = Integer.parseInt(part.getValue());
        part = Definitions.getParam((Part[])addBoardOperation.getInput().getPart(), (String)BOARD_TYPE_PARAM);
        int boardType = Integer.parseInt(part.getValue());
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            this.addBoard(slotID, boardType);
            this.addBoardToOutput(slotID, boardType);
        }
    }

    private void addBoardToOutput(int slotID, int boardType) {
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(this.neid);
        for (TEBoard board : boardList) {
            if (board.getSlotID() != slotID) continue;
            RowParams rowparams = new RowParams();
            rowparams.addParam(new Param(SLOT_ID_PARAM, String.valueOf(slotID)));
            rowparams.addParam(new Param(BOARD_TYPE_PARAM, String.valueOf(boardType)));
            rowparams.addParam(new Param("boardName", board.getBoardTypeName()));
            rowparams.addParam(new Param("boardState", String.valueOf(board.getState())));
            StringBuilder portListStr = new StringBuilder();
            ArrayList portList = (ArrayList)TEBD05FInterUtil.getInstallCPPort(board.getBoardType());
            for (Integer portNo : portList) {
                portListStr.append(portNo).append(',');
            }
            if (!portList.isEmpty()) {
                portListStr.deleteCharAt(portListStr.length() - 1);
            }
            TEAddBoardActionOnSingle.getOccupySlotList(this.neid, board.getSlotID(), board.getBoardType(), rowparams);
            rowparams.addParam(new Param("portList", portListStr.toString()));
            this.outputData.getBussinessParams().addRowParams(rowparams);
            break;
        }
    }

    private void addBoard(int slotid, int boardType) {
        try {
            TENE neObj;
            Vector<TEBoard> boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
            if (null == boardList) {
                boardList = new Vector<TEBoard>();
            }
            if (null != (neObj = TENEListMgr.getInstance().getNE(this.neid))) {
                boardList.remove(neObj.getBoard(slotid));
            }
            boardList.add(new TEBoard(this.neid, slotid, boardType));
            TENEListMgr.getInstance().getNE(this.neid).setLastBoardModifyTime();
            TENEListMgr.getInstance().getNE(this.neid).setBoardList(boardList);
            TEQueryLogicPort.queryExistLogicPort((int)this.neid, (int)slotid, (int)boardType);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }

    public String getDetailStr(RowParams rowparams) {
        int slotid = Integer.parseInt(rowparams.getParam(SLOT_ID_PARAM).getValue());
        int boardType = Integer.parseInt(rowparams.getParam(BOARD_TYPE_PARAM).getValue());
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
        if (!"".equals(subrackName)) {
            subrackName = subrackName + "-";
        }
        return subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid) + "-" + boardName;
    }

    public static void getOccupySlotList(int neid, int bigSlotid, int boardtype, RowParams rowparams) {
        int subrackId = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)bigSlotid);
        int slotid = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)bigSlotid);
        String slotList = "";
        TEBoardSlotInfo slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid);
        slotList = null != slotInfo ? slotInfo.toString() : slotid + "";
        Param boardslotlist = new Param(BOARD_SLOT_LIST_PARAM, slotList);
        rowparams.addParam(boardslotlist);
    }
}

