 /*
                 
 */
language = SYSTEMCONF.getLanguage();

colon = ": ";
if ("zh" == language)
{
	colon = " ";
}

var eid;
var BLANK_AREAR = 1;
var SLOT_AREAR = 2;
var BOARD_AREAR = 3;
var SUBSLOT_AREAR = 4;
var SUBCARD_AREAR = 5;

var pBoardArr = [];
pBoardArr["53NQ2(COMP)"] = "53NQ2";
pBoardArr["53ND2(COMP)"] = "53ND2";
pBoardArr["53NS2(COMP)"] = "53NS2";
pBoardArr["55NPO2(STND)"] = "55NPO2";
pBoardArr["54ENQ2(STND)"] = "54ENQ2";
pBoardArr["53TDX(STND)"] = "53TDX";
pBoardArr["55TQX(STND)"] = "55TQX";
pBoardArr["54TOA(STND)"] = "54TOA";
pBoardArr["54THA(STND)"] = "54THA";
pBoardArr["54NS4(REG)"] = "54NS4";
pBoardArr["55NO2(REG)"] = "55NO2";
pBoardArr["F8LO2(REG)"] = "F8LO2";
pBoardArr["54NS3(STND)"] = "54NS3";
pBoardArr["52ND2(STND)"] = "52ND2";
pBoardArr["52NS2(STND)"] = "52NS2";

var currentNEInfo = window.top.currentNEInfo;

if (currentNEInfo == undefined)
{
	currentNEInfo = SpecialAttrMgr.getNeInfo(getNeProperty(top).neid);
}

function hfInitDiv()
{
	$("bpgimg").alt = RESOURCE["bpgimg"];
	$("bloopimg").alt = RESOURCE["bloopimg"];
	$("showmap").alt = RESOURCE["showmap"];
	if (null != $("batchadd"))
	{
		$("batchadd").value = RESOURCE["batchadd"];
	}
}

/**
 *           
 * 
 * @param evt:  
 * @return  
 */
function hfItemContextMenuHandler(evt)
{
	hfClearSelState();
	var eid = hfGetEIDFromEvent(evt);
	if (!eid)
	{
		return;
	}

	if (eid.cid == SLOT_AREAR)
	{
		var boardid = 'o.3.' + eid.id;
		var elem = document.getElementById(boardid);
		if (elem)
		{
			return true;
		}
	}

	hfSetSelState(eid);
	hfSetSelectedItem(eid.asOID());
	hfGetPopupMenu(eid);
	rightClickHandler(evt);
	return false;
}

function getCurrentSubrackID()
{
	if(currentNEInfo.issupportshelf == false)
	{
		return 0;
	}
	else
	{
		return window.parent.Tab.selectTabid;
	}
}

function getCurrentWindow()
{
	if(currentNEInfo.issupportshelf == false)
	{
		return window;
	}
	else
	{
		return window.parent.Tab.getTabWindow(window.parent.Tab.selectTabid);
	}
}

/*
 * Event handler that handles left click event.
 */
function leftClickHandler(e)
{ // Private method
	if (getX(e) > getClientWidth() || getY(e) > getClientHeight())
	{
		return;
	}
	if (!e)
	{
		var e = window.event;
	}
	if (e.button && e.button == 2)
	{
		return;
	}
	hideVisibleMenus();
	hideMenu(e);

	var eid = hfGetEIDFromEvent(hfWrapEvent(event, this));
	if (!eid)
	{
		return false;
	}

	if (eid.cid == BOARD_AREAR)
	{
		var slotid = eid.id;
		var subrackid = getCurrentSubrackID();
		slotid = getTotalSlotID(subrackid,slotid);
		var bdEle = window.top.frames["objecttree"].tree[slotid];
		if (null == bdEle)
		{
			return;
		}
		
		if(bdEle.parent && !bdEle.parent.openFlag)
		{
			bdEle.parent.openFolder();
		}

		bdEle.isSelect();
		
    	window.top.frames["functiontree"].refreshLastFuncID();

		bdEle.onClick();
	}
}

/**
 *         
 * 
 * @param eid   ID
 * @return String:   XML  
 */
function hfGetPopupMenu(eid)
{
	var menuObj = null;

	for ( var i = 1; i <= menuCount; i++)
	{
		menuObj = $("DOMenu" + i);
		menuObj.parentNode.removeChild(menuObj);
	}
	menuCount = 0;

	if (eid.cid == BLANK_AREAR)
	{
		createjsDOMenu();
	}
	else if (eid.cid == SLOT_AREAR) // slot
	{
		var url = getRootPath() + "/neExlorerServlet?sfid="
				+ TECMDCODE_GET_SUPPORTED_CIRCUITPACK;
		loadXMLdoc(url, "POST", false, getSlotCardCallback, eid, "inputdata="
				+ createGetBoardXML(eid.id));
	}
	else if (eid.cid == BOARD_AREAR) // board
	{
		if (eid.bstate == "2")//       60020637
		{
			var url = getRootPath() + "/neExlorerServlet?sfid="
					+ TECMDCODE_GET_SUPPORTED_CIRCUITPACK;
			loadXMLdoc(url, "POST", false, getSlotCardCallback, eid,
					"inputdata=" + createGetBoardXML(eid.id));
		}
		else
		{
			var url = getRootPath() + "/neExlorerServlet?sfid="
					+ TECMDCODE_GET_CPINFO;
			loadXMLdoc(url, "POST", false, initMenu, eid, "inputdata="
					+ createGetMenuXML(eid.id));
		}
	}
	else if(eid.cid == SUBSLOT_AREAR) //       
	{
		var topmenu = new jsDOMenu(150);
		var typeAndNames =  eid.supportsubtypes.split(",");
		for(var i = 0,len = typeAndNames.length;i < len;i++)
		{
			var typeAndName = typeAndNames[i].split("-");
			topmenu.addMenuItem(new menuItem(RESOURCE['add'] + " " + typeAndName[1], "", addSubCard, [eid.id,1,typeAndName[0],typeAndName[1],eid.bstate]));
		}
		setPopUpMenu(topmenu);
	}
	else if(eid.cid == SUBCARD_AREAR) //       
	{
		if (eid.bstate == "2")
		{
			var topmenu = new jsDOMenu(150);
			topmenu.addMenuItem(new menuItem(RESOURCE['add'] + " " + eid.bname, "", addSubCard, [eid.id,1,eid.btype,eid.bname,eid.bstate]));
			setPopUpMenu(topmenu);
		}
		else
		{
			var url = getRootPath() + "/neExlorerServlet?sfid="
						+ TECMDCODE_GET_CPINFO;
			loadXMLdoc(url, "POST", false, initMenu, eid, "inputdata="
						+ createGetMenuXML(eid.id,eid.btype));
		}
	}
}

/**
 *              XML  
 * 
 * @param slotid   ID
 * @return String:   XML  
 */
function createGetMenuXML(slotid,subcardtype)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	var neid = getNeProperty(top).neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	var subrackid = getCurrentSubrackID();
	slotid = getTotalSlotID(subrackid,slotid);
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);
	if(typeof(subcardtype) != "undefined")
	{
		param = new tagElement("param");
		param.setAttribute("name", "subcardtype");
		param.setAttribute("value", subcardtype);
		row.appendChild(param);
	}

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *      
 * 
 * @param doc        
 *            evt:  
 * @return  
 */
function initMenu(doc, eid)
{
	var data = EncapsulateData(doc);

	var topmenuList = getChildMenuItemList(data, "");
	if (0 != data.getSErrorCode() || 0 == topmenuList.length)
	{
		isRefreshBoard = true;
		hfClearSelState();
		return;
	}

	var menuLen = 150;
	if (SYSTEMCONF.getLanguage() == "en")
	{
		menuLen = 170;
	}
	var topmenu = new jsDOMenu(menuLen);
	for ( var i = 0, len = topmenuList.length; i < len; i++)
	{
		var id = topmenuList[i]["id"].value;
		var name = topmenuList[i]["name"].value;
		var funcid = topmenuList[i]["funcid"].value;
		var action = topmenuList[i]["action"].value;
		var parent = topmenuList[i]["parent"].value;
		var paramArr = [ eid, funcid ];
		with (topmenu)
		{
			if ("" == id)
			{
				addMenuItem(new menuItem(name));
			}
			else
			{
				addMenuItem(new menuItem(name, id, eval(action), paramArr));
				handleSubMenu(data, topmenu, id, eid, topmenu.items.length - 1);
			}
		}
	}
	setPopUpMenu(topmenu);
	return topmenu;
}

/**
 *      ID        
 * 
 * @param data        
 *            parentid:   ID
 * @return Array:     
 */
function getChildMenuItemList(data, parentid)
{
	var childMenuItemList = [];
	var parent = null;
	var count = 0;
	for ( var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		parent = data.getDataRowParam(i, "parent");
		if (parent == parentid)
		{
			childMenuItemList[count] = data.rows[i];
			count++;
		}
	}
	return childMenuItemList;
}

/**
 *      
 * 
 * @param data        
 *            parentmenu       parentMenuid:   ID
 * @return  
 */
function handleSubMenu(data, parentmenu, parentMenuid, eid, menuItemIndex)
{
	var subMenuList = getChildMenuItemList(data, parentMenuid);
	if (0 == subMenuList.length)
	{
		return
	}
	var subMenu = new jsDOMenu();


	for ( var i = 0, len = subMenuList.length; i < len; i++)
	{
		var id = subMenuList[i]["id"].value; //   ID
		var name = subMenuList[i]["name"].value; //     
		var funcid = subMenuList[i]["funcid"].value; //      ID
		var action = subMenuList[i]["action"].value; //    action
		var parent = subMenuList[i]["parent"].value; //     ID
		var paramArr = [ eid, funcid ];
		with (subMenu)
		{
			if ("" == id)
			{
				addMenuItem(new menuItem(name));
			}
			else
			{
				addMenuItem(new menuItem(name, id, eval(action), paramArr));
				handleSubMenu(data, subMenu, id, subMenu.items.length - 1);
			}
		}
	}
	parentmenu.items[menuItemIndex].setSubMenu(subMenu);
}

/**
 *                
 * 
 * @param paramArr          ID   ID
 * @return  
 */
function goNEFuncBrowse(paramArr)
{
	hfClearSelState();

	eid = paramArr[0];
	var funcid = paramArr[1];


	var bdEle = window.top.frames["objecttree"].tree[getNeProperty(top).realNEID];
	if (null == bdEle)
	{
		return;
	}


	bdEle.isSelect();


	bdEle.onClick();


	var fun = window.top.frames["functiontree"].tree[funcid];
	if (null == fun)
	{
		return;
	}


	fun.expand();


	fun.isSelect();


	fun.onClick();
	if (3084 == funcid)
	{
		goAlarm();
	}
	else
	{
		fun = null;
		bdEle = null;
	}

}

function goAlarm()
{
	top.globalparam = 1;
	if (top.frames["data"].frames["tab_body_3084"].slotId)
	{
		var curAlarmWin = top.frames["data"].frames["tab_body_3084"];

		var subrackid = getCurrentSubrackID();
		var slotID = getTotalSlotID(subrackid,eid.id);
		curAlarmWin.slotId = slotID;
		curAlarmWin.firstFlag = 1;
		curAlarmWin.refreshAlarmlist();

		fun = null;
		bdEle = null;
		top.globalparam = 0;
	}
	else
	{
		window.setTimeout(goAlarm, 100);
	}

}
/**
 *                
 * 
 * @param paramArr          ID   ID
 * @return  
 */
function goBoardFuncBrowse(paramArr)
{
	hfClearSelState();

	var eid = paramArr[0];
	var funcid = paramArr[1];

	var subrackid = getCurrentSubrackID();
	var	slotid = getTotalSlotID(subrackid,eid.id);

	var bdEle = window.top.frames["objecttree"].tree[slotid];
	if (null == bdEle)
	{
		return;
	}


	bdEle.isSelect();


	bdEle.onClick();

	var funcids = funcid.split(",");
	var fun = null;
	for(var i = 0,len = funcids.length;i < len;i++)
	{
		fun = window.top.frames["functiontree"].tree[funcids[i]];
		if(null != fun)
		{
			break;
		}
	}
	if (null == fun)
	{
		return;
	}


	fun.expand();


	fun.isSelect();


	fun.onClick();
	fun = null;
	bdEle = null;
}

/**
 *              XML  
 * 
 * @param slotid   ID
 * @return String:   XML  
 */
function createGetBoardXML(slotid)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	
	var subrackid = getCurrentSubrackID();
	slotid = getTotalSlotID(subrackid,slotid);
	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "shelfType");
	var shelf = document.getElementById("o.1.1").getAttribute("shelfType");
	param.setAttribute("value", shelf);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *                 
 * 
 * @param doc        
 *            eid:  ID
 * @return  
 */
function getSlotCardCallback(doc, eid)
{
	var result = EncapsulateData(doc);
	if (0 != result.getError().getGlobleECode())
	{
		return;
	}

	var topmenu = getSlotPopupMenu(result, eid);

	setPopUpMenu(topmenu);
}
/*
 *           @param doc     
 */
function getSlotPopupMenu(result, eid)
{
	var topmenu = new jsDOMenu(150);
	topmenu.setMenuType(eid.cid);

	if (result.getDataRowLength() > 10)
	{
		topmenu.setMenuType(slotMenuType);
	}

	with (topmenu)
	{
		if (eid.bstate == "2")
		{
			var bdname = eid.bname;
			var boardType = eid.btype;
			var slotList = eid.bslotlist;
			var issupportsubcard = eid.issupportsubcard;
			var supportsubtypes = eid.supportsubtypes;
			var paramArr = [ eid.id, boardType, bdname, slotList,"2",issupportsubcard,supportsubtypes];
			addMenuItem(new menuItem(RESOURCE['addPhyBoard'], boardType,
					addCard, paramArr));
		}

		for ( var rowidx = 0; rowidx < result.getDataRowLength(); rowidx++)
		{
			var bdname = result.getDataRowParam(rowidx, 'boardName');
			var boardType = result.getDataRowParam(rowidx, 'boardType');
			var slotList = result.getDataRowParam(rowidx, 'slotList');
			var issupportsubcard = result.getDataRowParam(rowidx, 'issupportsubcard');
			var supportsubtypes = result.getDataRowParam(rowidx, 'supportsubtypes');
			var paramArr = [ eid.id, boardType, bdname, slotList ,"1",issupportsubcard,supportsubtypes];
			addMenuItem(new menuItem(RESOURCE['add'] + ' ' + bdname, boardType,
					addCard, paramArr));
		}
	}
	return topmenu;
}

function addSubCard(args)
{
	disableRefreshBoard = true;
	var slot = args[0]; //   ID
	var subcardid = args[1]; //     ID
	var subcardtype = args[2]; //     
	var subcardname = args[3]; //    
	
	var subrackid = getCurrentSubrackID();
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", getTotalSlotID(subrackid,slot));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "subcardid");
	param.setAttribute("value", subcardid);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "subcardtype");
	param.setAttribute("value", subcardtype);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	if (!isAdding)
	{
		isAdding = true;
		loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
					+ TECMDCODE_CREATE_SUBBOARD, "POST", false, addSubCardCallback,
					args, "inputdata=" + di.toString());
	}
	else
	{
		alert(RESOURCE["isadding"]);
	}
}

function addSubCardCallback(doc, args)
{
	disableRefreshBoard = false;
	var result = EncapsulateData(doc);
	if (0 == result.getError().getGlobleECode())
	{
		if ("2" == args[4])
		{
			$('o.5.' + args[0]).className = 'SubCardphylog SelSStateOff';
			$('o.5.' + args[0]).bstate = "3";
		}
		else
		{
			paintSubCard(args[0], args[1],args[2], args[3],args[4]);
		}
	}
	else
	{
		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
	}
	isAdding = false;
}

/**
 *     
 * 
 * @param args     
 * @return  
 */
function addCard(args)
{
	disableRefreshBoard = true;
	var slot = args[0]; //   ID
	var bdid = args[1]; //   ID
	var boardname = args[2]; //     
	var slotList = args[3]; //        
	if(!isSupportAddCard(slot,bdid))
	{
		removejsDOMmenu();
		alert(RESOURCE["resourceoccupied"]);
		return;
	}
	if (1 == SYSTEMCONF.getDemo())
	{
		paintCard(slot, bdid, boardname,issupportsubcard,args[5],args[6]);
		return false;
	}
	var subrackid = getCurrentSubrackID();

	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", getTotalSlotID(subrackid,slot));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "boardType");
	param.setAttribute("value", bdid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	if (!isAdding)
	{
		isAdding = true;
		loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
				+ TECMDCODE_CREATE_CIRCUITPACK, "POST", false, addCardCallback,
				args, "inputdata=" + di.toString());
	}
	else
	{
		alert(RESOURCE["isadding"]);
	}
}

/**
 *          
 * 
 * @param doc       
 *            args     
 * @return  
 */
function addCardCallback(doc, args)
{
	disableRefreshBoard = false;
	var result = EncapsulateData(doc);
	if (0 == result.getError().getGlobleECode())
	{
		if ("2" == args[4])
		{
			$('o.3.' + args[0]).className = 'Cardphylog SelStateOff';
			$('o.3.' + args[0]).firstChild.childNodes[0].style.visibility = "visible"
			$('o.3.' + args[0]).bstate = "3";
		}
		else
		{
			if (null == args[3]) // slotList
			{
				paintCard(args[0], args[1], args[2],args[5],args[6]);
			}
			else
			{
				var winid = getSubrackIDFromSlot(args[0]);

				var win = getCurrentWindow();

				var slotArray = args[3].split(",");
				for ( var k = 0; k < slotArray.length; k++)
				{

					var tmpCard = win.document.getElementById("o.3."
							+ slotArray[k]);
					if (tmpCard != null)
					{
						tmpCard.parentNode.removeChild(tmpCard);
					}
				}
				currentQLogicboard();
				paintCard(args[0], args[1], args[2], args[5],args[6],args[3]);
			}
		}

	}
	else
	{
		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
	}
	isAdding = false;
}

/**
 *       
 * 
 * @param args:    
 * @return  
 */
function delSubCard(args)
{
	disableRefreshBoard = true;

	var eid = args[0];

	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	var slotid = eid.id;
	var subrackid = getCurrentSubrackID();
	param.setAttribute("value", getTotalSlotID(subrackid,slotid));
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "subcardid");
	param.setAttribute("value", 1);
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_DEL_SUBBOARD, "POST", false, delSubCardCallback, eid,
			"inputdata=" + di.toString());
}

/**
 *          
 * 
 * @param doc       
 *            eid   ID
 * @return  
 */
function delSubCardCallback(doc, eid)
{
	disableRefreshBoard = false;
	var result = EncapsulateData(doc);
	if (0 == result.getError().getGlobleECode())
	{
		var card = document.getElementById("o.5." + eid.id);
		card.parentNode.removeChild(card);
	}
	else
	{
		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
	}
}

/**
 *     
 * 
 * @param args:    
 * @return  
 */
function delCard(args)
{
	disableRefreshBoard = true;

	var eid = args[0];

	if (1 == SYSTEMCONF.getDemo())
	{
		var card = document.getElementById(eid.toString());
		card.parentNode.removeChild(card);
		return false;
	}
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	var slotid = eid.id;
	var subrackid = getCurrentSubrackID();
	param.setAttribute("value", getTotalSlotID(subrackid,slotid));
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_DEL_CIRCUITPACK, "POST", false, delCardCallback, eid,
			"inputdata=" + di.toString());
}

/**
 *          
 * 
 * @param doc       
 *            eid   ID
 * @return  
 */
function delCardCallback(doc, eid)
{
	disableRefreshBoard = false;
	var result = EncapsulateData(doc);
	if (0 == result.getError().getGlobleECode())
	{
		var card = document.getElementById(eid.toString());
		var boardName = card.boardName;
		card.parentNode.removeChild(card);

		if(!isSupportSwitchPower())
		{
			restorePowerSlot();
		}
		var soltid = eid.id;
		var rootNode = top.frames["objecttree"].rootNode;		
		var tempNmSlotID = getTotalSlotID(getCurrentSubrackID(), soltid);
		if (rootNode && (tempNmSlotID == top.frames["objecttree"].tree.selectID))
		{
			rootNode.isSelect();
			rootNode.expand();
			rootNode.onClick();
		}
		currentQLogicboard();
	}
	else
	{

		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
	}
}

/*
 *      
 */
function boardHardReset(args)
{
	hideAllMenus();
	if (confirm(RESOURCE["resetinfo"]))
	{
		var eid = args[0];
		eid.mode = 0;
		boardReset(eid);
	}
}

function boardSoftReset(args)
{
	hideAllMenus();
	if (confirm(RESOURCE["softresetinfo"]))
	{
	var eid = args[0];
	eid.mode = 1;
	boardReset(eid);
	}
}
/*
 *     
 */
function sccBoardSoftReset(args)
{
	hideAllMenus();
	if (confirm(RESOURCE["resetsccalarm"]))
	{
		var eid = args[0];
		eid.mode = 1;
		boardReset(eid);
	}
}

function boardReset(eid)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	var subrackid = getCurrentSubrackID();
	var slotid = getTotalSlotID(subrackid,eid.id);
	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", slotid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "mode");
	param.setAttribute("value", eid.mode);
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_RESETBOARDSOFT, "POST", true, boardResetCallback, "",
			"inputdata=" + di.toString());
}
/*
 *          
 */
function boardResetCallback(doc)
{

	var result = EncapsulateData(doc);
	if (0 == result.getError().getGlobleECode())
	{
		var error = new AllError();
		var eTag = new ErrorTag();
		eTag.code = "succ";
		eTag.info = RESOURCE["optSucc"];
		error.s_error = eTag;
		openErrPage(getRootPath() + "/page/", error, "");
	}
	else
	{
		if (1090650120 == result.getError().getGlobleECode())
		{
			return;
		}
		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
	}

}

/*
      
*/
function sccBoardReplace(args)
{
	if(confirm(RESOURCE["boardreplacealarm"]))
	{
	    var eid = args[0];
      var subrackid = getCurrentSubrackID();
			var slotid = getTotalSlotID(subrackid,eid.id);
      showModalDialog("boardtype.html?"+"neid="+getNeProperty(top).neid+"&slotID="+slotid+"&boardType="+eid.btype, window,"dialogHeight:100px;dialogWidth:250px;center:yes;help:no;resizable:Yes;status:No;")      
   }
}

/*
 *        
 */
function boardVersion(args)
{
	var eid = args[0];
	var xml = createBoardVersionXml(eid, 1);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_QUERY_BD_VER, "POST", true, boardVersionCallback, "",
			"inputdata=" + xml);
}

/*
 *         
 */
function sccBoardVersion(args)
{
	var eid = args[0];
	var xml = createBoardVersionXml(eid, 0);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_QUERY_NE_VER, "POST", true, SccBoardVersionCallback,
			"", "inputdata=" + xml);
}

function createBoardVersionXml(eid, verid)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	if (verid == 1)
	{
		var subrackid = getCurrentSubrackID();
		var slotid = getTotalSlotID(subrackid,eid.id);
		param = new tagElement("param");
		param.setAttribute("name", "slotID");
		param.setAttribute("value", slotid);
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function boardVersionCallback(doc)
{
	var result = EncapsulateData(doc);
	var verString = "";
	if (0 != result.getError().getGlobleECode())
	{
		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
		return;
	}
	var softVerLowBit = result.getDataRowParam(0, "softVerLowBit");
	if (softVerLowBit.length < 2)
	{
		softVerLowBit = "0" + softVerLowBit;
	}
	verString = RESOURCE["boardversion"] + colon
			+ result.getDataRowParam(0, "softVerHighBit") + "." + softVerLowBit;
	alert(verString);
}

function SccBoardVersionCallback(doc)
{
	var result = EncapsulateData(doc);
	var verSignal = "";
	var verString = "";
	if (0 != result.getError().getGlobleECode())
	{
		var oArray = new Array();
		oArray[0] = "nename";
		openErrPage(getRootPath() + "/page/", result.getError(), oArray);
		return;
	}
	for (i = 0, resultlen = result.getDataRowLength(); i < resultlen; i++)
	{
		verSignal = result.getDataRowParam(i, "verSignal");
		if (verSignal == "NSF1" || verSignal == "NSF2")
		{
			if ("active" == result.getDataRowParam(i, "activeSignal"))//           
			{
				verString = RESOURCE["sccversion"] + colon
						+ result.getDataRowParam(i, "versionStr");
				break;
			}
		}
	}
	alert(verString);
}

/*
 *      
 */
function goPathChannel(args)
{

	var eid = args[0];
	if (eid)
	{
		var pos = eid.toString().lastIndexOf(".");
		var slotID = eid.toString().substring(pos + 1);
		var subrackid = getCurrentSubrackID();
		slotID = getTotalSlotID(subrackid,slotID);
		var neProperty = getNeProperty(top);
		var neid = neProperty.neid;
		var neVersion = neProperty.neversion;
		var rVer = parseInt(neVersion.split(".")[2],10);
		if (rVer <= 2)
		{
			neVersion = "";
		}
		else
		{
			neVersion = "_v2r6c01";
		}

		var pageurl = getRootPath() + "/nemgr/ngwdm/page/channelpathgraph" + neVersion
				+ "/channelpathgraph.html?" + "neid=" + neid + "&slotID="
				+ slotID;
		var sFeatures = "top=100,left=100,height=400,width=600,status=yes,toolbar=no,menubar=no,location=no";
		var newWin = window.open(pageurl, "channelpath", sFeatures);
		newWin.focus();

	}

}

/*
 *        o.1.* represent NE o.2.* represent slot o.3.* represent board/card
 * 
 */
var neSlots = new Array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
		17, 18, 19, 20, 21, 22, 23, 28, 29, 30, 31, 120, 121, 122, 123, 124, 125, 126, 127, 128);

/*
 *       
 */
function initBoardView()
{
	if (0 == SYSTEMCONF.getDemo())
	{
		if(currentNEInfo.issupportshelf == false)
		{
			var shelfType =getNeProperty(top).shelfType;
			if(shelfType)
			{
				$("o.1.1").setAttribute("shelfType",shelfType);
			}
			qLogicboard();
			window.setInterval("qLogicboard()", 6000);
		}
		else
		{
			refreshBoardList();
		}
	}
}

function currentQLogicboard()
{
	if(currentNEInfo.issupportshelf == false)
	{
		qLogicboard();
	}
	else
	{
		window.parent.qLogicboard();
	}
}


/*
 *      ,  6800      boardview0.html                          
 */
function qLogicboard()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_QUERY_LOGIC_CIRCUITPACK, "POST", true,
			refreshBoardCallBack, new Date(), "inputdata=" + di.toString());

}

function getBoardViewWindow()
{
	if(currentNEInfo.issupportshelf == false)
	{
		return window.parent;
	}
	else
	{
		return window.parent.parent;
	}
}

var bfirstenter = true;
/*
 *           
 */
function refreshBoardCallBack(doc, calltime)
{
	if (popUpMenuObj && "hidden" != popUpMenuObj.menuObj.style.visibility
			&& !isRefreshBoard)
	{
		isRefreshBoard = false;
		return;
	}
	if (disableRefreshBoard)
	{
		return;
	}

	var data = EncapsulateData(doc);
	if (0 != data.getSErrorCode())
	{
		return;
	}

	var boardupdateflag = data.getDataRowParam(0, "boardupgateflag");

	var logicboardcounter = 0;
	for ( var i = 0; i < data.getDataRowLength(); i++)
	{
		var bstate = data.getDataRowParam(i, "boardState");
		if (bstate == "1" || bstate == "3")
		{
			logicboardcounter++;
		}
	}

	if ("false" == boardupdateflag)
	{
		if (top.frames["objecttree"] && top.frames["objecttree"].rootNode)
		{
			if (top.frames["objecttree"].rootNode.childNodes.length != logicboardcounter)
			{
				boardupdateflag = "true";
			}
		}
	}

	window.parent.currentBoardList = data;
	
	if (("false" != boardupdateflag)
			|| ("BoardView" == getBoardViewWindow().Tab.selectTabid))
	{
		qLogicboardCallback(data);
	}

	if (!bfirstenter && ("false" == boardupdateflag))
	{
		return;
	}

	if (top.frames["objecttree"] && top.frames["objecttree"].handlerTreeDate)
	{
		top.frames["objecttree"].window.handlerTreeDate(data);
	}

	bfirstenter = false;
}

function refreshBoardList()
{
	if (window.parent.currentBoardList)
	{
		qLogicboardCallback(window.parent.currentBoardList);
	}
}

/*
 *     ,         
 */
function qLogicboardCallback(result)
{
	var selecttabid = getCurrentSubrackID();
	var selectTabIndex = window.parent.Tab.getSelectedTabIndex();

	if (0 == result.getError().getGlobleECode() && typeof(neSlots) != "undefined")
	{
		var boardSlot = neSlots.slice(0);// copy neSlots array
		var winid;

		var win = null;

		var removeSelectedBoardview = true;
		for ( var rowidx = 1, len = result.getDataRowLength(); rowidx < len; rowidx++)
		{
			var slot = result.getDataRowParam(rowidx, 'slotID'); //    

			winid = getSubrackIDFromSlot(slot);
			
			if (selecttabid == "BoardView" || selecttabid == winid)
			{
				var newslot = getSlotIDFromSlot(slot);
				removeSelectedBoardview = false;

				var bdid = result.getDataRowParam(rowidx, 'boardType');
				var label = result.getDataRowParam(rowidx, 'boardName');
				var bstate = result.getDataRowParam(rowidx, 'boardState');
				var bloop = result.getDataRowParam(rowidx, 'boardLoop');// 60020637     
				var bpg = result.getDataRowParam(rowidx, 'boardPG');// 60020637     
				var slotList = result.getDataRowParam(rowidx, 'slotList'); //     
				var topalmlevel = result.getDataRowParam(rowidx, 'topAlmLevel');
				var issupportsubcard = result.getDataRowParam(rowidx, 'issupportsubcard');
				var supportsubtypes = result.getDataRowParam(rowidx, 'supportsubtypes');

				win = getCurrentWindow();

				var slotDiv = document.getElementById('o.3.' + newslot)
				if (null == slotDiv)
				{
					win.paintCard(newslot, bdid, label,issupportsubcard, supportsubtypes,slotList, bstate, bloop,
							bpg);// 60020637         
				}
				else
				{
					win.repaintCardLabel(newslot, bdid, label,issupportsubcard,supportsubtypes,slotList, bstate,
							bloop, bpg);//      
				}
				
				if(issupportsubcard == "true")
				{

					var subcardid = result.getDataRowParam(rowidx, 'subcardid');
					var subcardtype = result.getDataRowParam(rowidx, 'subcardtype');
					var subcardname = result.getDataRowParam(rowidx, 'subcardname');
					var subcardstate = result.getDataRowParam(rowidx, 'subcardstate');
					if(subcardid != null)
					{
						win.paintSubCard(newslot,subcardid,subcardtype,subcardname,subcardstate);
					}
				}

				if (bstate != "2")
				{
					setBoardLED(newslot, topalmlevel);
				}

				win.rmFromArray(newslot, boardSlot);
			}

		}

		for ( var j = 0; j < boardSlot.length && win; j++)
		{
			var card = win.document.getElementById("o.3." + boardSlot[j]);
			if (null != card)
			{
				card.parentNode.removeChild(card);
			}
		}
		if (removeSelectedBoardview)
		{
			win = getCurrentWindow();
			if(win != null)
			{
				boardSlot = win.neSlots.slice(0);
	
				for ( var k = 0; k < boardSlot.length; k++)
				{
					var card = win.document.getElementById("o.3." + boardSlot[k]);
	
					if (null != card)
					{
						card.parentNode.removeChild(card);
					}
				}
			}
		}
	}

}

function repaintCardLabel(slot, bdid, label,issupportsubcard, supportsubtypes,slotList, bstate, bloop, bpg)
{
	var board = document.getElementById("o.3." + slot);
	if (board == null || board.firstChild == null)
	{
		return;
	}
	var childDiv = board.firstChild.childNodes;//    Div
	var childDivlength = childDiv.length;
	var labelDiv;
	if (!board)
	{
		return false;
	}

	if (bdid != board.bdid)//                     
	{
		if (slotList != board.slotlist)//         ,     
		{
			var slotDiv = calcBoardPostion(slotList);
			board.style.top = (parseInt(slotDiv.top) + 1) + 'px';
			if (slotDiv.left)
				board.style.left = (parseInt(slotDiv.left) + 1) + 'px';
			if (slotDiv.right)
				board.style.right = (parseInt(slotDiv.right) + 1) + 'px';
			board.style.width = (parseInt(slotDiv.width) - 4) + 'px';
			board.style.height = (parseInt(slotDiv.height) - 4) + 'px';
			board.firstChild.style.width = (parseInt(board.style.width) - 4) + 'px';
			board.firstChild.style.height = (parseInt(board.style.height) - 4) + 'px';
			var lposition = parseInt(board.style.width) - 4;
			board.slotlist = slotList;
		}
		if (label != board.blabel) //         
		{
			for ( var i = 0; i < childDivlength; i++)
			{
				if ('Label' == childDiv[i].className)
				{
					labelDiv = childDiv[i];//   Label Div
					break;
				}
			}
			if (labelDiv)
			{
				var boardwidth = parseInt(board.firstChild.style.width);
				var boardheight = parseInt(board.firstChild.style.height);

				if (boardwidth < boardheight)
				{
					var str = "";
					for ( var i = 0; i < label.length - 1; i++)
					{
						str = str + label.charAt(i) + '<br/>';
					}
					labelDiv.innerHTML = str + label.charAt(label.length - 1);
				}
				else
				{
					labelDiv.innerHTML = label;
				}
				if (lposition)
				{
					labelDiv.style.right = (lposition - 15) / 2 + "px";
				}
			}
			board.blabel = label;
			labelDiv = null;
		}
		board.bdid = bdid;
	}

	if (bstate != board.bstate)
	{
		setSlotDivClass(board, bstate);
		var labelDiv;
		for ( var i = 0; i < childDivlength; i++)
		{
			if ('alarmlight' == childDiv[i].id)
			{
				labelDiv = childDiv[i];//       DIV
				break;
			}
		}
		if (board.bstate == "2")//             DIV    
		{
			labelDiv.style.visibility = "Hidden";
		}
		else
		{
			labelDiv.style.visibility = "visible";
		}
		labelDiv = null;
	}

	if (bloop != board.bloop)//          60020637
	{
		for ( var i = 0; i < childDivlength; i++)
		{
			if ('Loop' == childDiv[i].className)
			{
				labelDiv = childDiv[i];
				break;
			}
		}
		if (labelDiv)//         
		{
			if (bloop == "1")
			{
				labelDiv.style.visibility = "visible";
			}
			else
			{
				labelDiv.style.visibility = "hidden";
			}
		}
		else if (bloop == "1")// bloop               Div 
		{
			var div5 = board.firstChild.appendChild(document
					.createElement('div'));
			div5.style.position = 'absolute';
			div5.className = 'Loop';
			div5.style.left = '-2px';
			div5.style.bottom = '-7px';
			div5.style.width = '10px';
			div5.style.height = '10px';
		}
		board.bloop = bloop;
		labelDiv = null;
	}

	if (bpg != board.bpg)//         60020637
	{
		for ( var i = 0; i < childDivlength; i++)
		{
			if ('bpg' == childDiv[i].className)
			{
				labelDiv = childDiv[i];
				break;
			}
		}
		if (labelDiv)//         
		{
			if (bpg == "1")
			{
				labelDiv.style.visibility = "visible";
			}
			else
			{
				labelDiv.style.visibility = "hidden";
			}
		}
		else if (bpg == "1")
		{
			var div6 = board.firstChild.appendChild(document
					.createElement('div'));
			div6.style.position = 'absolute';
			div6.className = 'bpg';
			div6.style.right = '-5px';
			div6.style.bottom = '-5px';
			div6.style.width = '10px';
			div6.style.height = '10px';
		}
		board.bpg = bpg;
		labelDiv = null;
	}

}

/*
 * tab       
 */

function tabSelectHandler()
{
	var result = window.parent.currentBoardList;
	qLogicboardCallback(result);
}

/*
 *                @param value          @param        
 */
function rmFromArray(value, oArray)
{
	var i = 0;
	for (i = 0; i < oArray.length; i++)
	{
		if (value == oArray[i])
		{
			oArray.splice(i, 1);
		}
	}
}

/*
 *      left,top,width,height(           
 */

function calcBoardPostion(slotList)
{
	var boardPos = new Object();
	boardPos.top = Number.MAX_VALUE;
	boardPos.left = Number.MAX_VALUE;
	boardPos.right = 0;
	boardPos.bottom = 0;

	var top, left, right, bottom;
	var slotArray = slotList.split(",");

	for ( var j = 0; j < slotArray.length; j++)
	{
		var slotDiv = document.getElementById('o.2.' + slotArray[j]);
		if (!slotDiv)
		{
			continue;
		}
		top = parseInt(slotDiv.style.top);

		if (top < boardPos.top)
		{
			boardPos.top = top;
		}

		left = parseInt(slotDiv.style.left);
		if (left < boardPos.left)
		{
			boardPos.left = left;
		}

		right = parseInt(slotDiv.style.left) + parseInt(slotDiv.style.width);
		if (right > boardPos.right)
		{
			boardPos.right = right;
		}

		bottom = parseInt(slotDiv.style.top) + parseInt(slotDiv.style.height);
		if (bottom > boardPos.bottom)
		{
			boardPos.bottom = bottom;
		}
	}

	boardPos.width = boardPos.right - boardPos.left;
	boardPos.height = boardPos.bottom - boardPos.top;
	return boardPos;

}

/*
 *         ,       ,            . @param slot     @param bdid      @param lable
 *      @param slotList           (        1   ,    slotList)
 * 
 * 60020637       
 */
function paintCard(slot, bdid, label,issupportsubcard, supportsubtypes,slotList, bstate, bloop, bpg)
{
	if (null != document.getElementById('o.3.' + slot))
	{
		return;
	}
	
	if(isSwitchBoard(slot,bdid))
	{
		switchPowerSlot();
	}

	var slotDiv = calcBoardPostion(slotList);
	if (slotDiv.width < 0 || slotDiv.Height < 0)
	{
		return;
	}
	if (pBoardArr[label])
	{
		label = pBoardArr[label];
	}

	var neDiv = document.getElementById("o.1.1");
	var shelfDiv = gerFirstTagElement(neDiv);

	var div = document.createElement("div");
	setSlotDivClass(div, bstate);

	div.setAttribute('id', 'o.3.' + slot);
	div.setAttribute('bdid', bdid);

	div.setAttribute('bstate', bstate);
	div.setAttribute('bloop', bloop);
	div.setAttribute('bpg', bpg);
	div.setAttribute('blabel', label);
	div.setAttribute('slotlist', slotList);
	div.setAttribute('issupportsubcard',issupportsubcard);
	div.setAttribute('supportsubtypes',supportsubtypes);
	div.style.position = 'absolute';
	div.style.padding = '1px';

	div.boardType = bdid;
	div.boardName = label;

	div.style.top = (parseInt(slotDiv.top) + 1) + 'px';
	if (slotDiv.left)
		div.style.left = (parseInt(slotDiv.left) + 1) + 'px';
	div.style.width = (parseInt(slotDiv.width) - 4) + 'px';
	div.style.height = (parseInt(slotDiv.height) - 4) + 'px';

	var div2 = div.appendChild(document.createElement("div"));
	div2.style.position = 'relative';
	div2.style.width = (parseInt(div.style.width) - 4) + 'px';
	div2.style.height = (parseInt(div.style.height) - 4) + 'px';

	var ycenter = parseInt(div2.style.height);

	var div3 = div2.appendChild(document.createElement('div'));
	div3.style.position = 'absolute';
	div3.className = 'LED';
	div3.setAttribute('id', 'alarmlight');//       ID  
	div3.style.top = "6px";
	div3.style.left = '6px';
	div3.style.width = '7px';
	div3.style.height = '7px';
	if (bstate == "2") //             
	{
		div3.style.visibility = "Hidden";
	}

	if (parseInt(div2.style.width) > parseInt(div2.style.height))
	{
		div3.style.top = (ycenter - 7) / 2 + 'px';
	}

	var div4 = div2.appendChild(document.createElement('div'));
	div4.style.position = 'absolute';
	div4.className = 'Label';
	div4.style.right = '1px';
	div4.style.bottom = '1px';

	if (parseInt(div2.style.width) > parseInt(div2.style.height))
	{
		
		div4.appendChild(document.createTextNode(label));
	}
	else
	{
		var s = '';
		for ( var i = 0; i < label.length; i++)
		{
			s = s + label.charAt(i);
			if (i < label.length - 1) // last char need not append <br />
			{
				s = s + "<br />";
			}
		}
		div4.innerHTML = s;
		div4.style.bottom = '2px';

		var div2width;
		var slotWidth = 26; //     
		var slotArray = slotList.split(",");
		div2width = slotWidth * slotArray.length + 3 * (slotArray.length - 1)
				- 8;
		if(issupportsubcard == "true")
		{
			var divSubBD = div2.appendChild(document.createElement('div'));
			divSubBD.style.position = 'absolute';
			
			divSubBD.style.width = (parseInt(slotDiv.width) / 2 - 3) + "px";
			divSubBD.style.height = (parseInt(slotDiv.height)/2) + "px";
			divSubBD.className = "Slot";
			divSubBD.style.top = (parseInt(slotDiv.height)/4) + "px";
			divSubBD.style.left = "3px";
			divSubBD.id="o.4." + slot;
			divSubBD.setAttribute('issupportsubcard',issupportsubcard);
			divSubBD.setAttribute('supportsubtypes',supportsubtypes);
			div4.style.left = (div2width - 15) + "px";
		}
		else
		{
			div4.style.right = (div2width - 15) / 2 + "px";
		}
	}

	if (bloop == "1")
	{
		var div5 = div2.appendChild(document.createElement('div'));
		div5.style.position = 'absolute';
		div5.className = 'Loop';
		div5.style.left = '-2px';
		div5.style.bottom = '-7px';
		div5.style.width = '10px';
		div5.style.height = '10px';
	}

	if (bpg == "1")
	{
		var div6 = div2.appendChild(document.createElement('div'));
		div6.style.position = 'absolute';
		div6.className = 'bpg';
		div6.style.right = '-5px';
		div6.style.bottom = '-5px';
		div6.style.width = '10px';
		div6.style.height = '10px';
	}
	shelfDiv.appendChild(div);
}

function paintSubCard(slotid,subcardid,subcardtype,subcardname,bdstate)
{
	var divSubBD = document.getElementById("o.4." + slotid);
	var divSubBDTemp = document.getElementById("o.5." + slotid);
	if(null == divSubBD || divSubBDTemp != null)
	{
		return;
	}
	var div = document.createElement('div');
	divSubBD.parentNode.appendChild(div);
	setSubSlotDivClass(div,bdstate);
	div.setAttribute('id', 'o.5.' + slotid);
	div.style.position = 'absolute';
	div.style.padding = '1px';
	div.style.top = divSubBD.style.top;
	div.setAttribute('bdid', subcardtype);
	div.setAttribute('bstate', bdstate);
	div.setAttribute('blabel', subcardname);
	if (divSubBD.style.left)
	{
		div.style.left = divSubBD.style.left
	}
	div.style.width = divSubBD.style.width;
	div.style.height = divSubBD.style.height
	var divLabel = div.appendChild(document.createElement('div'));
	divLabel.style.position = 'absolute';
	divLabel.className = 'Label';
	divLabel.style.right = '1px';
	divLabel.style.bottom = '1px';
	if (parseInt(divSubBD.style.width) > parseInt(divSubBD.style.height))
	{
		divLabel.appendChild(document.createTextNode(subcardname));
	}
	else
	{
		var s = '';
		for ( var i = 0; i < subcardname.length; i++)
		{
			s = s + subcardname.charAt(i);
			if (i < subcardname.length - 1) // last char need not append <br />
			{
				s = s + "<br />";
			}
		}
		divLabel.innerHTML = s;
		divLabel.style.bottom = '2px';
		divLabel.style.left = "0px";
	}
}

/*
 *         
 */
function boardAlarmLevelCallback(doc, slot)
{
	var result = EncapsulateData(doc);

	if (result.getDataRowLength() > 0)
	{
		var lev = result.getDataRowParam(0, 'topAlmLevel');
		setBoardLED(slot, lev);
	}
}

/*
 *            
 */
function boardAlarmLevel(slot)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neID");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", slot);
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
			+ TECMDCODE_GET_NECPSANDALM, "POST", true, boardAlarmLevelCallback,
			slot, "inputdata=" + di.toString());

}

/*
 *               
 */
function setBoardLED(slot, almLevel)
{
	var board = document.getElementById("o.3." + slot);

	if (!board || !board.firstChild || board.almLevel == almLevel)
	{
		return false;
	}
	
	board.almLevel = almLevel;
	var c = board.firstChild.childNodes;
	var ledDiv = ('Label' == c[0].className) ? c[1] : c[0];

	switch (almLevel)
	{
		case "-1":
			if ("LED" != ledDiv.className)
			{
				ledDiv.className = "LED";
			}
			break;
		case "1":
			if ("RedLED" != ledDiv.className)
			{
				ledDiv.className = "RedLED";
			}
			break;
		case "2":
			if ("major" != ledDiv.className)
			{
				ledDiv.className = "major";
			}
			break;
		case "3":
			if ("YellowLED" != ledDiv.className)
			{
				ledDiv.className = "YellowLED";
			}
			break;
		case "4":
			if ("warning" != ledDiv.className)
			{
				ledDiv.className = "warning";
			}
			break;
		default:
			ledDiv.className = "GreenLED";

	}
}
/*
 *       60020637
 * 
 */

function tableview()
{
	if ($('maptable').style.visibility == "hidden")
	{
		$('maptable').style.visibility = "visible";
		$('showmap').src = getRootPath() + "/images/tree/mapsample.gif";
	}
	else if ($('maptable').style.visibility == "visible")
	{
		$('maptable').style.visibility = "hidden"
		$('showmap').src = getRootPath() + "/images/tree/mapsamplesaw.gif";
	}
}
function getPhyBoard(eid)
{
	var PHYSTATE = "2";
	var topmenu = new jsDOMenu(100);
	topmenu.setMenuType(PHYSTATE);
	with (topmenu)
	{
		var bdname = eid.bname;
		var boardType = eid.btype;
		var slotList = eid.bslotlist;
		var issupportsubcard = eid.issupportsubcard;
		var supportsubtypes = eid.supportsubtypes;
		var paramArr = [ eid.id, boardType, bdname, slotList, PHYSTATE,issupportsubcard,supportsubtypes];
		addMenuItem(new menuItem(RESOURCE['add'] + ' ' + bdname, boardType,
				addCard, paramArr));
	}
	setPopUpMenu(topmenu);
}
function createjsDOMenu()
{
	removejsDOMmenu();
	var cursorMenu1 = new jsDOMenu(150); //    150

	with (cursorMenu1)
	{
		addMenuItem(new menuItem(RESOURCE["clear_alarm_indication"], "",
				alarmReset, 0));
	}
	setPopUpMenu(cursorMenu1);

}

/*
 *         
 */
function alarmReset()
{

	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	var neid = getNeProperty(top).neid;

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "reset");
	thirdlevel.setAttribute("value", "0");//     
	secondlevel.appendChild(thirdlevel);

	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	var xml = root.toString();
	var URL = getRootPath() + "/neExlorerServlet?sfid="
			+ TE_CLR_NE_ALM_INDICATE_CMD + "&flag=1";
	loadXMLdoc(URL, "POST", true, alarmResetHandBack, null, "inputdata=" + xml);
}

function alarmResetHandBack(doc)
{
	var datainterface = EncapsulateData(doc);

	var errArr = [];
	errArr[0] = "nename";
	openErrPage(getRootPath() + "/page/", datainterface.getError(), errArr);
}
/**
 * is board can update
 */
var disableRefreshBoard = false;

var isAdding = false;

var isRefreshBoard = false;

function batchAddCard(args)
{
	disableRefreshBoard = true;
	function batchAddCardCallback(doc, args)
	{
		disableRefreshBoard = false;
		var result = EncapsulateData(doc);
		if (0 == result.getError().getGlobleECode())
		{
			currentQLogicboard();
		}
		else
		{
			var oArray = new Array();
			oArray[0] = "nename";
			oArray[1] = "slotID";
			oArray[2] = "boardname";
			openErrPage(getRootPath() + "/page/", result.getError(), oArray);
		}
		$("batchadd").disabled = false;
		isAdding = false;
	}

	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	if (!isAdding)
	{
		isAdding = true;
		if (null != $("batchadd"))
		{
			$("batchadd").disabled = true;
		}
		loadXMLdoc(getRootPath() + "/neExlorerServlet?sfid="
				+ TECMDCODE_ADD_BOARDS_IN_BATCHES, "POST", true,
				batchAddCardCallback, args, "inputdata=" + di.toString());
	}
	else
	{
		alert(RESOURCE["isadding"]);
	}
}

/*
 * set style of slot div @param div @param bstate
 */
function setSlotDivClass(div, bstate)
{
	div.bstate = bstate;
	if ("0" == bstate)
	{
		div.className = 'Card SelStateOff';
	}
	else if ("1" == bstate)
	{
		div.className = 'Cardlogic SelStateOff';
	}
	else if ("2" == bstate)
	{
		div.className = 'Cardphy SelStateOff';
	}
	else if ("3" == bstate)
	{
		div.className = 'Cardphylog SelStateOff';
	}
	else
	{
		div.className = 'Cardlogic SelStateOff';
	}
}


/*
 * set style of slot div @param div @param bstate
 */
function setSubSlotDivClass(div, bstate)
{
	div.bstate = bstate;
	if ("0" == bstate)
	{
		div.className = 'SubCard SelSStateOff';
	}
	else if ("1" == bstate)
	{
		div.className = 'SubCardlogic SelSStateOff';
	}
	else if ("2" == bstate)
	{
		div.className = 'SubCardphy SelSStateOff';
	}
	else if ("3" == bstate)
	{
		div.className = 'SubCardphylog SelSStateOff';
	}
	else
	{
		div.className = 'SubCardlogic SelSStateOff';
	}
}

function switchPowerSlot()
{
}

function restorePowerSlot()
{
}

function isSupportSwitchPower()
{
	return false;
}

function isSwitchBoard(slotid,bdType)
{
	return false;
}

function isSupportAddCard()
{
	return true;
}
