 var Tab;
var currSubrackInfo = new Array(); //         
var MAX_SUBRACK_NUM = 7;//      7 
var LOGIC_SUBRACK = 0;//    
var PHY_SUBRACK = 1;//    
var IS_FIRST_QUERY = 1;//        
var minTabID = -1; //         ID        -1
var maxTabID= -1; //         ID        -1
var nePro = getNeProperty(top);
var neid = getNeProperty(top).neid;
var SHOW_SUBRACK_DIALOG = false;

/**
*      
*/
function init()
{
	Tab = new Tabs();
	Tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame2", "tabs_li_select1");
	
	document.body.appendChild(Tab.getTabs());
	
	setMaxSubrackNum();
	addPopupMenu(); // Tab                
	querySubrack(IS_FIRST_QUERY);
	window.setInterval("querySubrack()",10000);	
}

function setMaxSubrackNum()
{
	var neProperty = getNeProperty(top);
	var neid = neProperty.neid;
	var neVersion = neProperty.neversion;
	var rCVer = parseInt(neVersion.split(".")[2]);
	if ((neVersion.split(".")[2] == 6 && neVersion.split(".")[3] >= 10) ||
			neVersion.split(".")[2] > 6)
	{
		MAX_SUBRACK_NUM = 31;
	}
}

/**
*             
*/
function addScrollBtn()
{
	var btnDiv = document.createElement("div");
	var proPageBtn = document.createElement("button"); //   
	proPageBtn.className = "buttonstyle10"; 
	proPageBtn.onclick = proPageBtnAction;

	var leftBtn = document.createElement("button"); //   
	leftBtn.className = "buttonstyle11"; 
	leftBtn.onclick = leftBtnAction;

	var rightBtn = document.createElement("button"); //   
	rightBtn.className = "buttonstyle12"; 
	rightBtn.onclick = rightBtnAction;

	var nextPageBtn = document.createElement("button"); //   
	nextPageBtn.className = "buttonstyle13"; 
	nextPageBtn.onclick = nextPageBtnAction;
		
	btnDiv.appendChild(proPageBtn); //             
	btnDiv.appendChild(leftBtn);
	btnDiv.appendChild(rightBtn);
	btnDiv.appendChild(nextPageBtn);
	btnDiv.style.styleFloat ="right";
	Tab.TabHead.appendChild(btnDiv);
}


/**
*              
*/
function addPopupMenu()
{
	Tab.TabHead.firstChild.oncontextmenu = popupMenuHandler; // Tab        
	Tab.TabHead.oncontextmenu = popupMenuHandler;
}

/**
*       
*/
function querySubrack(isFirstQuery)
{
	if(Tab.getSelectedTabID() != -1)
	{
		var tabWin = Tab.getTabWindow(Tab.getSelectedTabID());
		var boardView = tabWin;
		if(typeof(tabWin.Tab) != "undefined" && tabWin.Tab != null)
		{
			boardView = tabWin.Tab.getTabWindow(tabWin.Tab.getSelectedTabID());
		}
		if(SHOW_SUBRACK_DIALOG || (boardView.popUpMenuObj && "hidden" != boardView.popUpMenuObj.menuObj.style.visibility && !boardView.isRefreshBoard))
		{
			return;
		}
	}
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",neid);
	secondlevel.appendChild(thirdlevel);
	
	if(isFirstQuery == null)
	{
		isFirstQuery = 0;
	}
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","isFirstQuery");
	thirdlevel.setAttribute("value",isFirstQuery);
	secondlevel.appendChild(thirdlevel);	
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
 	var queryUrl = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_SUBRACK;
	loadXMLdoc(queryUrl, "POST", true, querySubrackCallBack, isFirstQuery,"inputdata=" + root.toString()); 	 
}

/**
*           
*/
function querySubrackCallBack(doc,isFirstQuery)
{
	qLogicboard(isFirstQuery);
	var queryData = EncapsulateData(doc); 
	if(0 != queryData.getSErrorCode())
	{
		return;
	}
	
	var tempList = new Array();
	for(var i=0; i < queryData.getDataRowLength(); i++)
	{
		var subrackID = queryData.getDataRowParam(i,"subrackID");
		var logicSubrackType = queryData.getDataRowParam(i,"logicSubrackType");
		var phySubrackType = queryData.getDataRowParam(i,"phySubrackType");
		var subrackState = queryData.getDataRowParam(i,"subrackState");
		var subrackTopLevelAlm = queryData.getDataRowParam(i,"subrackTopLevelAlm");
		var subrackMemo = unescape(queryData.getDataRowParam(i,"subrackMemo")); //      
		var neName = queryData.getDataRowParam(i,"nename");
		
		var tempSubrack = new Object();
		tempSubrack.subrackID = subrackID;
		tempSubrack.logicSubrackType = logicSubrackType;
		tempSubrack.phySubrackType = phySubrackType;
		tempSubrack.subrackMemo = subrackMemo;
		tempSubrack.subrackState = subrackState;
		tempSubrack.subrackTopLevelAlm = subrackTopLevelAlm;
		tempSubrack.neName = neName;
		tempList[tempList.length] = tempSubrack;
		
		var currSubrack = getSubrack(subrackID);
		if(!currSubrack)
		{
			 refreshSubrack_add(tempSubrack);
		}
		else if(!compareSubrack(currSubrack,tempSubrack))
		{
			refreshSubrack_change(tempSubrack);
		}else if((currSubrack.subrackTopLevelAlm == tempSubrack.subrackTopLevelAlm))
		{
		    Tab.getTab(currSubrack.subrackID).setImage(getImgURL(tempSubrack.subrackTopLevelAlm));
		}
	}
	
	for(var i = 0; i < currSubrackInfo.length; i++)
	{
		var tempSubrackID = currSubrackInfo[i].subrackID;
		var isExist = false;
		for(var j = 0; j < tempList.length; j++)
		{
			if(tempSubrackID == tempList[j].subrackID)
			{
				isExist = true;
				break;
			}
		}
		if(!isExist)
		{
			refreshSubrack_delete(tempSubrackID);
		}
	}
	
	currSubrackInfo = tempList; //     
 	var selectedTabId = Tab.getSelectedTabID();
  if(selectedTabId == -1)//    
  {
 	 	selectedTabId = 0;//     
  }
  Tab.selectTab(selectedTabId);//    		
}

/**
 * compare subrack
 * @param subrack1
 * @param subrack2
 * return boolean
 */
function compareSubrack(subrack1,subrack2)
{
	var blResult = ((subrack1.subrackID == subrack2.subrackID) 
									&& (subrack1.logicSubrackType == subrack2.logicSubrackType)
									&& (subrack1.subrackState == subrack2.subrackState)
									&& (subrack1.subrackMemo == subrack2.subrackMemo));
	return blResult;
}

/**
 * add subrack
 * @param subrack object
 */
function refreshSubrack_add(subrack)
{
	addSubrackTab(subrack.subrackID,subrack.logicSubrackType,subrack.subrackMemo);
	Tab.getTab(subrack.subrackID).head.style.backgroundColor = getBackgroundColor(subrack.subrackState);
	Tab.getTab(subrack.subrackID).setImage(getImgURL(subrack.subrackTopLevelAlm));
	Tab.getTab(subrack.subrackID).setTips(RESOURCE["TIPS_TYPE_" + subrack.logicSubrackType]);
	Tab.getTab(subrack.subrackID).setText(getSubrackName(subrack.subrackID,subrack.subrackMemo));
	
	if(top.frames["objecttree"]&&top.frames["objecttree"].rootNode)
	{
		top.frames["objecttree"].refreshSubrack_add(subrack);
	}
}

/**
 * change subrack
 * @param subrack object
 */
function refreshSubrack_change(subrack)
{
	var subrackURL = getSubrackPageURL(subrack.logicSubrackType, subrack.subrackID);
	Tab.getTab(subrack.subrackID).setURL(subrackURL);
	Tab.getTab(subrack.subrackID).head.style.backgroundColor = getBackgroundColor(subrack.subrackState);
	Tab.getTab(subrack.subrackID).setImage(getImgURL(subrack.subrackTopLevelAlm));
	Tab.getTab(subrack.subrackID).setTips(RESOURCE["TIPS_TYPE_" + subrack.logicSubrackType]);
	Tab.getTab(subrack.subrackID).setText(getSubrackName(subrack.subrackID,subrack.subrackMemo));
	
	if(top.frames["objecttree"]&&top.frames["objecttree"].rootNode)
	{
		top.frames["objecttree"].refreshSubrack_change(subrack);
	}
}

/**
 * delete subrack
 * @param subrack object
 */
function refreshSubrack_delete(subrackID)
{
	delSubrackTab(subrackID);
	
	if(top.frames["objecttree"]&&top.frames["objecttree"].rootNode)
	{
		top.frames["objecttree"].refreshSubrack_delete(subrackID);
	}
}


function getSubrack(subrackID)
{
	for(var i = 0; i < currSubrackInfo.length; i++)
	{
		if(currSubrackInfo[i].subrackID == subrackID)
		{
			return currSubrackInfo[i];
		}
	}
	return null;
}

/**
*                     
*/
function delSubrack(subrackID)
{
	removejsDOMmenu(); //          
	var isDel = confirm(RESOURCE["isdelete"]);
	if(!isDel)
	{
		return;
	}
	SHOW_SUBRACK_DIALOG = true;
	
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",neid);
	secondlevel.appendChild(thirdlevel);

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","subrackID");
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	thirdlevel.setAttribute("value",subrackID);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	var delUrl = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_DEL_SUBRACK;
	loadXMLdoc(delUrl, "POST", true, delSubrackCallBack, subrackID,"inputdata=" + root.toString()); 	
}

/**
*           
*/
function delSubrackCallBack(doc, subrackID)
{
	SHOW_SUBRACK_DIALOG = false;
	var delData = EncapsulateData(doc); //        
	if(0 != delData.getSErrorCode()) //     
	{
		showErrorDialog(delData); //        
		return; //          
	}
	
	refreshSubrack_delete(subrackID);//             Tab   
	for(var i = 0; i < currSubrackInfo.length; i++)
	{
		if(currSubrackInfo[i].subrackID == subrackID)
		{
			 currSubrackInfo[i] = null;
			 currSubrackInfo.splice(i,1); //           
			 break;
		}
	}
	
	for (var i = currentBoardList.getDataRowLength() - 1; i > 0; i--) 
	{
		var slotid = parseInt(currentBoardList.getDataRowParam(i, "slotID"));
		var subrackid = getSubrackIDFromSlot(slotid);
		if(subrackid == subrackID)
		{
			currentBoardList.removeDataRowAt(i);
		}
	}
}

/**
*      
*/
function addSubrack()
{
	removejsDOMmenu(); //       
	if(currSubrackInfo.length == MAX_SUBRACK_NUM + 1)//         
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	SHOW_SUBRACK_DIALOG = true;
	xshowModalDialog("addsubrackdlg.html?subrackID=-1",RESOURCE["addsubrack"],400,250,"../../../../../../images/");
}

/**
 *       
 */
function modifySubrack(subrackID)
{
	removejsDOMmenu(); //       
	SHOW_SUBRACK_DIALOG = true;
	xshowModalDialog("addsubrackdlg.html?subrackID=" + subrackID,RESOURCE["modifysubrack"],400,250,"../../../../../../images/");
}

function getSubrackName(subrackID,subrackMemo)
{
	var subrackName = subrackID + ":" + subrackMemo;
	
	/*if(typeof(subrackMemo) == "undefined" || subrackMemo == null || subrackMemo == "")
	{
		if(subrackID == 0)
		{
			subrackName = subrackID + ":" + RESOURCE["mainsubtrack"];
		}
		else
		{
			subrackName = subrackID + ":" + RESOURCE["subtrack"] + subrackID;
		}
	}*/
	return subrackName;
}

/**
*           Tab 
*/
function addSubrackTab(subrackID, subrackType,subrackMemo)
{
	var subrackURL = getSubrackPageURL(subrackType, subrackID);
	var subrackName = getSubrackName(subrackID,subrackMemo);
	if(subrackID == 0) //   
	{
		Tab.addTab(0, subrackName, subrackURL);
		return;
	}
	
	var isAdd = false;//      
	for(var i = Number(subrackID) + 1; i <= MAX_SUBRACK_NUM; i++)
	{
		if(Tab.getTab(i))
		{
			isAdd = true;
			Tab.insertTabAt(subrackID, subrackName, subrackURL, "", i);
			return;
		}
	}
	if(!isAdd)
	{
		Tab.addTab(subrackID, subrackName, subrackURL);
	}
}
/**
*           Tab      
*/
function refreshShowAfterModify(subrackID, logicSubrackType, subrackMemo)
{

	var tempSubrack = getSubrack(subrackID);

	if(tempSubrack != null)
	{
		tempSubrack.subrackMemo = subrackMemo;
	}

	refreshSubrack_change(tempSubrack);
	SHOW_SUBRACK_DIALOG = false;
}

/**
*           Tab      
*/
function refreshShowAfterAddTab(subrackID, logicSubrackType, subrackMemo)
{
	var tempSubrack = new Object();
	tempSubrack.subrackID = subrackID;
	tempSubrack.logicSubrackType = logicSubrackType;
	tempSubrack.subrackMemo = subrackMemo;
	tempSubrack.subrackState = LOGIC_SUBRACK;

	for(var i = subrackID - 1; i >= 0; i--)
	{
		if(currSubrackInfo[i])
		{
			var tempSubrack = new Object(); //          
			tempSubrack.subrackID = subrackID;
			tempSubrack.logicSubrackType = logicSubrackType;
			tempSubrack.subrackMemo = subrackMemo;
			tempSubrack.subrackState = LOGIC_SUBRACK;
			currSubrackInfo.insertAt(i + 1, tempSubrack);
			break;
		}
	}
	refreshSubrack_add(tempSubrack);
	Tab.selectTab(subrackID);
	SHOW_SUBRACK_DIALOG = false;
}


/**
*             Tab 
*/
function delSubrackTab(subrackID)
{	
	Tab.removeTabNode(subrackID); //       Tab   
	Tab.selectTab(0);
}


/**
*                url
*/
function getSubrackPageURL(subrackType, subrackID)
{
	var subrackURL = "../../../ne_74/5.51.01.10/page/subboardview_6800.html?subtrackid="; //        6800
	if(subrackType == 68) 
	{
		subrackURL = "../../../ne_74/5.51.01.10/page/subboardview_7800.html?subtrackid=";
	}
	else if(subrackType == 74)
	{
		subrackURL = "../../../ne_74/5.51.01.10/page/subboardview_8800II.html?subtrackid=";
	}
	else if(subrackType == 84)
	{
		subrackURL = "subboardview_8800T16.html?subtrackid=";
	}
	else if(subrackType == 93)
	{
		subrackURL = "../../../ne_51/5.51.04.20/page/subboardview_6800P.html?subtrackid=";
	}
	else if(subrackType == 97)
	{		
		subrackURL = "../../../ne_68/5.51.04.20/page/subboardview_8800T32E.html?subtrackid=";
	}
	else if(subrackType == 98)
	{
		subrackURL = "../../../ne_74/5.51.01.10/page/subboardview_8800T64E.html?subtrackid=";
	}
	else if(subrackType == 102)
	{
		subrackURL = "../../../ne_102/5.51.08.13/page/subboardview_6800.html?subtrackid=";
	}
	else if (subrackType == 126)
	{
		subrackURL = "../../../page/subboardview_8800P16.html?subtrackid=";
	}
	return subrackURL + subrackID; //      
}

function getSubrackSecondPageURL(subrackType, subrackID)
{
	subrackURL = "subboardview_second_8800.html?subtrackid=";
	return subrackURL + subrackID; //      
}


/**
*                       
*/
function getImgURL(subrackTopLevelAlm)
{
	var imgURL = "../../../../../../images/gled.png"; //        
	if(subrackTopLevelAlm == 1)
	{
            imgURL = "../../../../../../images/rled.png";
	} else if(subrackTopLevelAlm == 2)
	{
	    imgURL = "../../../../../../images/major.png";
	} else if(subrackTopLevelAlm == 3)
	{
	    imgURL = "../../../../../../images/yled.png";
	} else if(subrackTopLevelAlm == 4)
	{
	    imgURL = "../../../../../../images/warning.png";
	}

	return imgURL; //      
}

/**
*          tab     
*/
function getBackgroundColor(subrackState)
{
	var color = "#A67AFF"; //        
	if(subrackState == PHY_SUBRACK)
	{
		color = "#00F800";
	}
	return color; //    
}

/**
*              
*/
function popupMenuHandler(evt)
{
	removejsDOMmenu(); //          
	if(!evt)
	{
		evt = window.event;
	}
	
	var elem = (evt.target) ? evt.target : evt.srcElement;
	if(elem!= null && elem.blur) 
	{
		 elem.blur(); 
	}
	
	while(elem!=null)
	{
		if(elem.tagName == 'A' || elem.tagName == 'DIV') //  Tab     
		{
			break;	
		}
		else if(elem.tagName == 'LI')
		{
			elem = elem.firstChild;
		}
		else
		{
			elem = elem.parentNode;
		}
	}
	
	if(elem == null || (elem.tagName != 'A' && elem.tagName != 'DIV')) //   Tab      
	{
		return;
	}	
	
	var subrackText = elem.parentNode.id; //  Tab      
	var idHead = "tab_head_";
	var isMainSubrack = false;//        
	var subrackID = subrackText.substring(idHead.length);
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	if(subrackID + "" == "0")//   
	{
		subrackID = 0;
		isMainSubrack = true;	
		Tab.selectTab(0); //          Tab 	
	}
	if(subrackID == "" || isNaN(subrackID))
	{
		subrackID = Tab.getSelectedTabID(); //         ID
		if(subrackID == -1 || subrackID == 0) //            Tab 
		{
			isMainSubrack = true;
			Tab.selectTab(0); //          Tab 
		}	
	}
	else
	{
		Tab.selectTab(subrackID); //          Tab 
	}	
	var cursorMenu = new jsDOMenu(150); //      
	with(cursorMenu)
	{
		 addMenuItem(new menuItem(RESOURCE["addsubrack"], "", addSubrack));
		 addMenuItem(new menuItem(RESOURCE["modifysubrack"], "", modifySubrack,subrackID));
		 if(!isMainSubrack)//                
		 {
		 		addMenuItem(new menuItem(RESOURCE["delsubrack"], "", delSubrack, subrackID));
		 }
	}	
  setPopUpMenu(cursorMenu);
  showMenu();
}

/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = data.getError().rowErrors;
	var size = data.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		if(tempObj["subrackID"] != null)
		{
			tempObj["subrackID"] = RESOURCE["subrackID"] + ":" + tempObj["subrackID"];
		}
	}	
	errArr[1] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}
/*
     ,  6800      boardview0.html        
                 
*/
function qLogicboard(isFirstQuery)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
		if(isFirstQuery == null)
		{
			isFirstQuery = 0;
		}
		param = new tagElement("param");
		param.setAttribute("name","isFirstQuery");
		param.setAttribute("value",isFirstQuery);
		row.appendChild(param);	
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_LOGIC_CIRCUITPACK, "POST", true, refreshBoardCallBack, isFirstQuery, "inputdata="+di.toString());
 
}

var currentBoardList = null;
/*
           
*/
function refreshBoardCallBack(doc,isFirstQuery)
{
	var data = EncapsulateData(doc);
	if(0 != data.getSErrorCode())
	{
		return;
	}
	var boardupdateflag = data.getDataRowParam(0, "boardupgateflag");
	
	var logicboardcounter=0;
	var board = null;
	for(var rowidx = 1; rowidx < data.getDataRowLength(); rowidx++)
	{
    bstate = data.getDataRowParam(rowidx,"boardState");
		if(bstate == "1" || bstate == "3")
		{
			logicboardcounter++;
		}
	}

    if("false" == boardupdateflag)
    {
    	 if(top.frames["objecttree"]&&top.frames["objecttree"].rootNode)
    	 {
    	 	if(top.frames["objecttree"].rootNode.childNodes.length!=logicboardcounter)
    	 	{
    	 		boardupdateflag="true";
    	 	}
    	 }
    }
   
    currentBoardList = data;
    
    initBoardList();
    
    initObjectTree();

	if("false" == boardupdateflag)
	{
	  return;	
	}
	  
	refreshObjectTree();
}

function initBoardList()
{
	if(typeof(Tab.getTabWindow(Tab.getSelectedTabID()).refreshBoardList) != "undefined")
    {
       Tab.getTabWindow(Tab.getSelectedTabID()).refreshBoardList();
    }
	else
	{
		window.setTimeout(initBoardList,500);
	}
}

function initObjectTree()
{
	if(typeof(top.frames["objecttree"].rootNode) != "undefined" )
	{
		if(top.frames["objecttree"].rootNode == null)
		{
			top.frames["objecttree"].window.initObjectTree(currSubrackInfo,currentBoardList);
		}
	}
	else
	{
		window.setTimeout(initObjectTree,500);
	}
}

function refreshObjectTree()
{
	if(top.frames["objecttree"] && top.frames["objecttree"].handlerTreeDate)
    {  	
        top.frames["objecttree"].window.refreshBoardList(currentBoardList);
    }
    else
    {
    	window.setTimeout(refreshObjectTree,500);
    }
}
