loadXMLdoc("../../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../../../../../necommon/res/subrackres_"+ language +".xml"); //      

var NETYPE_8800 = "68";//8800     
var NETYPE_8800_2 = "74";//8800     
var NETYPE_8800_16 = "84";//8800T16     
var NETYPE_8800_32E = "97";//8800T16     
var NETYPE_8800_64E = "98";//8800T16     

function init()
{		
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	SpecialAttrMgr.getNEFunInfo(win.neid,"TE_FUNC_OTN_NE_MGR");
	if(blModify)
	{
		var currentSubrack = win.getSubrack(subrackID);
		var atom = new Atom("span");
		atom.setValue(getNeProperty(self).subrackID);
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		atom = new Atom("span");
		atom.setValue(RESOURCE["TYPE_" + currentSubrack.logicSubrackType]);
		table.addAttrRow("subrackName", RESOURCE["subrackType"], atom);
		atom = new Atom("hidden");
		atom.setValue(currentSubrack.logicSubrackType);
		table.addAttrRow("subrackType", RESOURCE["subrackType"], atom);
		atom = new Atom("text");
		atom.setValue(currentSubrack.subrackMemo);
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
        
        
        initCrossOption(atom, false);
        /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 begin */
        atom = new Atom("select");
        init1588V2(atom, currentSubrack.logicSubrackType);       
        table.addAttrRow("1588v2", RESOURCE["title1588v2"], atom);       
        /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 end */
        
        atom = new Atom("select");
        initSDHLowCross(atom, currentSubrack.logicSubrackType, true);
        table.addAttrRow("sdhlowcross", RESOURCE["titlesdhlowcross"], atom);     
        var crossTypeXml = createCrossTypeXML();
             
        loadXMLdoc("../../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_SHELFCROSSTYPE, "POST", false, queryShelfCrossTypeCallBack, null, "inputdata=" + crossTypeXml);
        
        
	}
	else
	{
		var atom = new Atom("select");
		var existSubrackIDArr = win.Tab.getAllTabsID();
		for(var i = 1; i <= win.MAX_SUBRACK_NUM; i++)
		{
			if(!existSubrackIDArr.contains(i)) // i       
			{
				atom.addOption(i, i);
			}
		}
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		
	
		atom = new Atom("select");
	
		table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
		atom.addOption(RESOURCE["TYPE_51"], 51);
		if( compare(win.nePro["neversion"],"5.51.05.10") > 0 )
		{
			
			if (compare(win.nePro["neversion"],"5.51.07.33") >= 0 && compare(win.nePro["neversion"],"5.51.08.10") <= 0)
            {
            	atom.addOption(RESOURCE["TYPE_93"], 93);
            }
			if(compare(win.nePro["neversion"],"5.51.08.13") >= 0 )
            {
				atom.addOption(RESOURCE["TYPE_102"], 102);
            }
	        if(compare(win.nePro["neversion"],"5.51.07.10") >= 0 )
            {
            	atom.addOption(RESOURCE["TYPE_84"], 84);
            }
			atom.addOption(RESOURCE["TYPE_68"], 68);			
			if(compare(win.nePro["neversion"],"5.51.07.64") >= 0 )
            {
				atom.addOption(RESOURCE["TYPE_97"], 97);
            }
			
			atom.addOption(RESOURCE["TYPE_74"], 74);			
			if(compare(win.nePro["neversion"],"5.51.07.65") >= 0 )
            {
				atom.addOption(RESOURCE["TYPE_98"], 98);
            }
            if(compare(win.nePro["neversion"],"5.51.09.10") >= 0 )
            {
				atom.addOption(RESOURCE["TYPE_126"], 126);
            }
            
		}
		else
		{
			if( win.nePro["neType"] == NETYPE_8800 )
			{
				atom.addOption(RESOURCE["TYPE_68"], 68);
			}
		}
		
		atom.element.onchange = function()
		{
            if (isSupportCross(table.getAttrValue("subrackType"))) 
			{
				table.getAtom("crossType").element.disabled = false;
				table.getAtom("crossCapacity").element.disabled = false;
			}
			else
			{
				table.getAtom("crossType").element.disabled = true;
				table.getAtom("crossCapacity").element.disabled = true;
			}
			
			/* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 begin */
			init1588V2(table.getAtom("1588v2"), table.getAttrValue("subrackType"));
        	/* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 end */  		
		}
		
		atom = new Atom("text");
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
		initCrossOption(atom,true);
	
        /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 begin */
        atom = new Atom("select");
        init1588V2(atom, table.getAttrValue("subrackType"));
        table.addAttrRow("1588v2", RESOURCE["title1588v2"], atom);
        /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 end */
        atom = new Atom("select");
        initSDHLowCross(atom, table.getAttrValue("subrackType"), false);
        table.addAttrRow("sdhlowcross", RESOURCE["titlesdhlowcross"], atom);
	}
	document.body.insertBefore(table.getTable(), $("AddTable"));
}

/**
 *           xml  
 */
function createAddXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
    if (subrackID.indexOf("-") != -1) 
    {
        subrackID = subrackID.split("-")[0];
    }
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "memo");
	param.setAttribute("value",subrackMemo);
	row.appendChild(param);
	
    
    if ((isSupportCross(table.getAttrValue("subrackType"))) &&
			table.getAtom("crossType") != null && 
			table.getAtom("crossCapacity") != null )
	{
		var crossType = table.getAttrValue("crossType");
		var crossCapacity = table.getAttrValue("crossCapacity");
		
		param = new tagElement("param"); 
		param.setAttribute("name", "crossType");
		param.setAttribute("value",crossType);
		row.appendChild(param);
		param = new tagElement("param"); 
		param.setAttribute("name", "crossCapacity");
		param.setAttribute("value",crossCapacity);
		row.appendChild(param);
	}
    /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 begin */
    if (table.getAtom("1588v2") != null && table.getAttrValue("1588v2") != -1)
    /* JIRA TRANSV1R9C00-6219, modify by xieli 00208063 end */ 
    {
        param = new tagElement("param");
        param.setAttribute("name", "self1588");
        param.setAttribute("value", table.getAttrValue("1588v2"));
        row.appendChild(param);
    }
    
    if (table.getAtom("sdhlowcross") != null && table.getAttrValue("sdhlowcross") != -1)
    {
        param = new tagElement("param");
        param.setAttribute("name", "sdhlowcross");
        param.setAttribute("value", table.getAttrValue("sdhlowcross"));
        row.appendChild(param);
    }
	
	
	
	
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);	
	return root.toString();	
}

function initCrossOption(atom,disableFlag)                                              
{  	
		atom = new Atom("select");                                              
		atom.addOption(RESOURCE["crossType0"], 0);                              
		atom.addOption(RESOURCE["crossType1"], 1);                              
		atom.addOption(RESOURCE["crossType2"], 2);                              
		atom.addOption(RESOURCE["crossType3"], 3);   
		if (compare(win.nePro["neversion"], "5.51.08.10") >= 0) 
	    {
	        atom.addOption(RESOURCE["crossType4"], 4);
	        atom.addOption(RESOURCE["crossType5"], 5);
	        atom.addOption(RESOURCE["crossType6"], 6);
	        atom.addOption(RESOURCE["crossType7"], 7);
	    }
	    atom.element["onchange"] = function()
	    {
			$("applyBtn").disabled = false;	
			initSDHLowCross(table.getAtom("sdhlowcross"), table.getAttrValue("subrackType"), false);   		
	    }    
		table.addAttrRow("crossType",RESOURCE["crossType"], atom);		          
		atom.element.disabled = disableFlag;      
		                           
                                                                                        
		atom = new Atom("select");                                              
		atom.addOption(RESOURCE["crossCapacity0"], 0);                          
		atom.addOption(RESOURCE["crossCapacity1"], 360);  
		if(compare(win.nePro["neversion"],"5.51.07.10") >= 0 )
        {
            atom.addOption(RESOURCE["crossCapacity7"], 640);  
        }                      
		atom.addOption(RESOURCE["crossCapacity2"], 720);                        
		atom.addOption(RESOURCE["crossCapacity3"], 1280);                       
		atom.addOption(RESOURCE["crossCapacity4"], 2560);                       
		if(compare(win.nePro["neversion"],"5.51.07.10") >= 0 )
        {
            atom.addOption(RESOURCE["crossCapacity8"], 3200);
            atom.addOption(RESOURCE["crossCapacity9"], 6400);
        }
		atom.element["onchange"] = function()
	    {
			$("applyBtn").disabled = false;			
	    }
		table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);	
		atom.element.disabled = disableFlag;                                    
}


function initSDHLowCross(atom, subtrackType, isModify)
{
	if (compare(win.nePro["neversion"], "5.51.08.30") >= 0) 
    {  	
    	
    	atom.clearOptions();
    	if ((subtrackType == 93 || subtrackType == 102 || subtrackType == 126) || (!isSupportSdhLowCross() && !isModify))
		{
			atom.addOption("-", -1);
			atom.element.disabled = true;
		}
		else //     
		{
			atom.addOption(RESOURCE["ID_DISABLE2"], 0);
			atom.addOption(RESOURCE["ID_ENABLE"], 1);        	
        	atom.element.disabled = false;
		}
    }
    else
    {
    	atom.clearOptions();
    	atom.addOption("-", -1);
		atom.element.disabled = true;
    }
}    

function isSupportSdhLowCross()
{
	return true;
}                                                                                  
function isSupportCross(subracktype)
{
    var bResult = false;
    var supportShelfs = SpecialAttrMgr.getNEAttrListValue(win.neid,"OTN_ATTR_SUPPORT_CROSSSHELFTYPE");
    if (subracktype == NETYPE_8800 
    || subracktype == NETYPE_8800_2 
    || subracktype == NETYPE_8800_16 
    || subracktype == NETYPE_8800_32E 
    || subracktype == NETYPE_8800_64E 
    || (supportShelfs != null && supportShelfs.contains(subracktype))) 
    {
        bResult = true;
    }
    return bResult;
}
