 loadXMLdoc("../../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../../../../../necommon/res/subrackres_"+ language +".xml"); //      
var subrackID = getNeProperty(self).subrackID;
var blModify = false;
if(subrackID != null && typeof(subrackID) != "undefined" && subrackID >= 0)
{
	blModify = true;
	document.title = RESOURCE["modifysubrack"];
}
else
{
	document.title = RESOURCE["addsubrack"];
}
var table = new  CTable();
var win = window.dialogArguments;
var NETYPE_8800 = "68";//8800     
var NETYPE_8800_2 = "74";//8800     

    
function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	if(blModify)
	{
		var currentSubrack = win.getSubrack(subrackID);
		var atom = new Atom("span");
		atom.setValue(getNeProperty(self).subrackID);
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		atom = new Atom("span");
		atom.setValue(RESOURCE["TYPE_" + currentSubrack.logicSubrackType]);
		table.addAttrRow("subrackType", RESOURCE["subrackType"], atom);
		atom = new Atom("text");
		atom.setValue(currentSubrack.subrackMemo);
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
	}
	else
	{
		var atom = new Atom("select");
		var existSubrackIDArr = win.Tab.getAllTabsID();
		for(var i = 1; i <= win.MAX_SUBRACK_NUM; i++)
		{
			if(!existSubrackIDArr.contains(i)) // i       
			{
				atom.addOption(i, i);
			}
		}
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		
	
		atom = new Atom("select");
	
		table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
		atom.addOption(RESOURCE["TYPE_51"], 51);
		if(compare(win.nePro["neversion"],"5.51.07.10") >= 0 )
    {
    	atom.addOption(RESOURCE["TYPE_84"], 84);
    }
		atom.addOption(RESOURCE["TYPE_68"], 68);
		atom.addOption(RESOURCE["TYPE_74"], 74);
		
		atom = new Atom("text");
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
	}
	document.body.insertBefore(table.getTable(), $("AddTable"));
}


/**
 *           xml  
 */
function createAddXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "memo");
	param.setAttribute("value",subrackMemo);
	row.appendChild(param);
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


/**
 *        
 */
function addSubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		win.SHOW_SUBRACK_DIALOG = false;
		xcloseDialog(); //                        
		return;
	}
		
	var subrackID = table.getAttrValue("subrackID"); //          ID
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	if(subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	var existSubrackIDArr = win.Tab.getAllTabsID();
	if(existSubrackIDArr.contains(subrackID)) //          ,     
	{
		alert(RESOURCE["subrackExist"]); //                   
		return;
	}
	
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var addXML = createAddXML(); //        xml
	
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_SUBRACK, "POST", false,addSubrackCallBack, paramArr,"inputdata="+addXML);
}

function doSubrack(btnFlg)
{
	if(blModify)
	{
		modifySubrack(btnFlg);
	}
	else
	{
		addSubrack(btnFlg);
	}
}

/**
 *       
 */
function modifySubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var modifyXML = createAddXML(); //        xml
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_SUBRACK_NAME, "POST", false,modifySubrackCallBack, paramArr,"inputdata="+modifyXML);

}

function modifySubrackCallBack(doc,paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	win.refreshShowAfterModify(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
	}
}

/**
 *             
 */
function addSubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //       
	showErrorDialog(addData); 
	
	if(addData.getSErrorCode() != 0 && addData.getSErrorCode() != 1) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	
	win.refreshShowAfterAddTab(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3] && addData.getSErrorCode() == 0) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		var subrackIDAtom = table.getAtom("subrackID").element;
		subrackIDAtom.options.remove(subrackIDAtom.selectedIndex);
		if(subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}


/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}

/**
*           
*/
function cancelBtnAction()
{
	win.SHOW_SUBRACK_DIALOG = false;
	xcloseDialog();//     
}

function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
    
    obj.onkeydown = function()
    {
    	  var letterFlg = forbidSignInput();//      
    	  if(!letterFlg)
    	  {
    	      return letterFlg;
    	  }
    	  var code=event.keyCode!=0?event.keyCode:event.charCode;
    	  if(!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16))
    	  {
    	      $("applyBtn").disabled = false;
    	  }
    }
}

function forbidSignInput()
{
    var key = event.keyCode!=0?event.keyCode:event.charCode;
        
    if(event.shiftKey)
    {
        if(key == 188 || key == 222)//   <       
        {
            return false;
        }
    }
    return true;
}

/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = data.getError().rowErrors;
	var size = data.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		if(tempObj["subrackID"] != null)
		{
			tempObj["subrackID"] = RESOURCE["subrackID"] + ":" + tempObj["subrackID"];
		}
		if (tempObj["licensetype"] != null && parseInt(tempObj["licensetype"]) == 2)
		{
			tempObj["subrackID"] += "-" + RESOURCE["crossCapacity"];
		}
	}	
	errArr[1] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}
