var filterMenuIds = [134];
var wdmInfMenuId = 114;

/**
 *           
 * @param slotId
 */
function getBoardAlarmStyle(board)
{
	var id = BOARD_PREFIX + board.slotId;
	var g = getSVGElement(id);
	if(g)
	{
        var childs = g.childNodes;
        var child;
        for(var i = 0, len = childs.length; i < len; i++)
        {
        	child = childs.item(i);
        	if(child.nodeName == "circle" && "1" == child.getAttribute("alarm"))
        	{
        		return child.style.getPropertyValue("fill");
        	}
        }
	}
}

/**
 *             
 * @param alarmLevel
 * @returns {String}
 */
function getAlarmColor(alarmLevel)
{
	var color = "";
	alarmLevel = pInt(alarmLevel);
	if("0" == SYSTEMCONF.getStatus())
	{
		switch(alarmLevel)
		{
			case 1:
				color = "#ff1919";
				break;
			case 2:
				color = "#ff9600";
				break;
			case 3:
				color = "#ffff64";
				break;
			case 4:
				color = "#31cbff";
				break;
			case 5:
				color = "#0080ff";
				break;
			case 7:
				color = "#32ff32";
				break;
			case 10:
				color = "#32c8ff";
				break;
			case 11:
				color = "#808080";
				break;
		}
	}
	else
	{
		switch(alarmLevel)
		{
			case 1:
				color = boardAlarmCritical;
				break;
			case 2:
				color = boardAlarmMajor;
				break;
			case 3:
				color = boardAlramMinor;
				break;
			case 4:
				color = boardAlarmWarning;
				break;
			case 5:
				color = boardAlarmNotReport;
				break;
			case 7:
				color = boardAlarmNormal;
				break;
			case 10:
				color = boardAlarmUnknown;
				break;
			case 11:
				color = boardAlarmCommBreak;
				break;
			default:
				color = boardAlarmNormal;
		}
	}
	
	return color;
}

/**
 *                         
 *                 
 *                 
 * @param portState     
 * @param alramLevel     
 */
function getPortColor(portState, alramLevel)
{
	var color = "gray";
	portState = pInt(portState);
	if(1 == portState)
	{
		color = getAlarmColor(alramLevel);
	}
	
	return color;
}

/**
 *               3    
 * 0        #00ff00
 * 1         #8486bd
 * 255       #c0c0c0
 * @param portState
 * @returns {String}
 */
function getPortStateColor(portState)
{
	var color = "#c0c0c0";
	portState = pInt(portState);
	switch(portState)
	{
	case 0:
		color = "#00ff00";
		break;
	case 1:
		color = "#8486bd";
		break;
	case 255:
		color = "#c0c0c0"; 
	default:
		break;
	}
	
	return color;
}

/**
 *             
 * @param boardState
 * 0:    1:      2:      3:      255            
 * @returns {String}
 */
function getBoardColor(boardState)
{
	var color = "";
	boardState = pInt(boardState);
	switch(boardState)
	{
		case 0:
			color = "#e3e0e3";
			break;
		case 1:
			color = "#B4BEFF";
			break;
		case 2:
			color = "#C3F0D2";
			break;
		case 3:
			color = "#64DC8C";
			if("1" == SYSTEMCONF.getStatus())
			{
				color = getRunningBoardColor();
			}
			break;
    case 255:
			color = "#BABABA";
			break;			
		default:
			color = "#B4BEFF";
			break;
	}
	return color;
}

/**
 *                   
 */
function getRunningBoardColor()
{
	if(null == customizeRunningBoardColor || "" == customizeRunningBoardColor)
	{
		customizeRunningBoardColor = "#64DC8C";
	}
	
	return customizeRunningBoardColor;
}

/**
 *        1      2      
 * @param pathstate
 * @returns {String}
 */
function getPathState(pathstate)
{
	var color = "#00ff00";
	pathstate = pInt(pathstate);
	switch(pathstate)
	{
	case 0:
		color = "#c0c0c0";
		break;
	case 1:
	case 2:
		color = "#00ff00";
		break;
	default:
		break;
	}
	
	return color;
}
/**
 *            
 * 
 * @param slot
 * @param className
 * @return
 */
function setSlotRectClass(/* Object */ slot,/* String */ className)
{
	for(var i = 0; i < slot.childNodes.length ;i ++)
	{
		if(slot.childNodes.item(i) && slot.childNodes.item(i).nodeName == "rect")
		{
			slot.childNodes.item(i).setAttribute("class",className);
			break;
		}
	}	
}

/**
 *         ,x/y/width/height
 * 
 * @param board
 */
function calcBoardPostion(/* Object */board)
{
	var bPos = {x:Number.MAX_VALUE,y:Number.MAX_VALUE,width:0,height:0};
	var sElm,bbox,right=0,bottom=0,righttmp,bottomtmp;
	if(!board.slotList || board.slotList.length == 0)
	{
		sElm = getSVGElement(SLOT_PREFIX + board.slotId);

		if(sElm)
		{
			var bPosTemp = sElm.getBBox();
			bPos.width = bPosTemp.width;
			bPos.height = bPosTemp.height;
			bPos.x = pInt(sElm.getAttribute("x"));
			bPos.y = pInt(sElm.getAttribute("y"));
		}
	}
	else
	{
		var slotArray = board.slotList;
		for ( var j = 0; j < slotArray.length; j++)
		{
			sElm = getSVGElement(SLOT_PREFIX + slotArray[j]);
			if (!sElm)
			{
				continue;
			}
			var bbox = new Object();
			bbox.width = sElm.getBBox().width;
			bbox.height = sElm.getBBox().height;
			bbox.x = pInt(sElm.getAttribute("x"));
			bbox.y = pInt(sElm.getAttribute("y"));
			if(bPos.x > pInt(bbox.x))
			{
				bPos.x = pInt(bbox.x);
			}
			if(bPos.y > pInt(bbox.y))
			{
				bPos.y = pInt(bbox.y);
			}
			righttmp = pInt(bbox.x) + pInt(bbox.width);
			if (righttmp > right)
			{
				right = righttmp;
			}
			bottomtmp = pInt(bbox.y) + pInt(bbox.height);
			if (bottomtmp > bottom)
			{
				bottom = bottomtmp;
			}
		}
		bPos.width = right - bPos.x;
		bPos.height = bottom - bPos.y;
	}
	return bPos;
}

/**
 *             
 * @param bPos
 * @returns {___anonymous3816_3830}
 */
function calcBoardAlmPostion(bPos)
{
	var almPos = {cx:0,cy:0,r:0};
	if(bPos.width < bPos.height)
	{
		almPos.cx = bPos.width / 2;
		almPos.r = BOARD_ALARM_R;
		almPos.cy = BOARD_ALM_OFFSET + almPos.r
	}
	else
	{
		almPos.cy = bPos.height / 2;
		almPos.r = BOARD_ALARM_R;
		almPos.cx = BOARD_ALM_OFFSET + almPos.r;
	}
	return almPos;
}

/**
 *            
 * 
 * @param board
 * @param oPos
 * @return
 */
function calPortContainerPos(/* Object */ board,/* Object */ oPos)
{
	var portContainerPos = {x:0,y:0,width:0,height:0};
	if(oPos.width > oPos.height)
	{
		portContainerPos.y = oPos.height - PORT_SIZE - 1;
		portContainerPos.height = PORT_SIZE;
		if(PORT_MAX_NUMBER_COLUMN_BASE<=board.portList.length)
		{
		    portContainerPos.width  = PORT_SIZE * PORT_MAX_NUMBER_COLUMN_BASE + 5;
		    portContainerPos.x = (oPos.width - PORT_SIZE * PORT_MAX_NUMBER_COLUMN_BASE)/2;
		}
		else
		{
		    portContainerPos.width = PORT_SIZE * board.portList.length + 5;
		    portContainerPos.x = (oPos.width - PORT_SIZE * board.portList.length)/2;
		}
	}
	else
	{
		portContainerPos.x = oPos.width - PORT_SIZE;
	    portContainerPos.y = oPos.height * (ALARM_AREA_PER + NAME_AREA_PER);
	    portContainerPos.width = PORT_SIZE;
	    portContainerPos.height = oPos.height * PORT_AREA_PER;
	}
	return portContainerPos;
}

/**
 *               
 *                     
 * @param board1
 * @param board2
 * @returns {Boolean}
 */
function compareJsonBoard(board1,board2)
{
	if(board1 && board2)
	{
		if(board1.slotId == board2.slotId
			&& board1.boardType == board2.boardType
			&& board1.boardState == board2.boardState
			&& board1.alarmLevel == board2.alarmLevel
			&& board1.loopback == board2.loopback
			&& board1.boardPG == board2.boardPG
			&& comparePortListObj(board1, board2))
		{
			return true;
		}
	}
	return false;
}


/**
 *             
 *               ID  
 * @param board1
 * @param board2
 * @returns {Boolean}
 */
function comparePortListObj(board1, board2)
{
	if(board1 && board2)
	{
		var portList1 = board1.portList;
		var portList2 = board2.portList;
		if(portList1.length == portList2.length)
		{
			var port1;
			var port2;
			for(var i = 0, len = portList1.length; i < len; i++)
			{
				port1 = portList1[i];
				port2 = portList2[i];
				if(port1 == port2.portId || port1.portId == port2)
				{
					return false;
				}
				if(port1.portId == port2.portId)
				{
					   if(port1.portType != port2.portType
					      || port1.portState != port2.portState
					      || port1.alarmLevel != port2.alarmLevel
					      || port1.loopback != port2.loopback)
					   {
						    return false;
					   }
				}
			}
			return true;
		}
	}
	
	return false;
}

/**
 *          
 * @param target
 * @returns
 */
function getTargetBoard(target)
{
	if(target)
	{
		if(target.nodeName == "#document")
		{
			return null;
		}
		if(target.getAttribute("oboard") && target.getAttribute("oboard") != "")
		{
			return target;
		}
		else
		{
			return getTargetBoard(target.parentNode);
		}
	}
	else
	{
		return target;
	}
}

/**
 *               
 * @param pathview
 */
function getParentNodeList(pathview)
{
	var list = [];
	var len = pathview.length;
	var path;
	for(var i = 0; i < len; i++)
	{
		path = pathview[i];
		list.push(path.pid);
	}
	list = unique(list);
	return list.sort(compareNum);
}

/**
 *            
 * @param board
 * @returns {___anonymous5277_5367}
 */
function getCurrentMoveBoardPoint(board)
{
	var cPos = {x:0,y:0,width:pInt(board.getAttribute("width")),height:pInt(board.getAttribute("height"))};
	while(board.parentNode && board.parentNode != "#document")
	{
		if(board.getAttribute("x") && board.getAttribute("x") != "")
		{
			cPos.x += pInt(board.getAttribute("x"));
		}
		if(board.getAttribute("y") && board.getAttribute("y") != "")
		{
			cPos.y += pInt(board.getAttribute("y"));
		}
		board = board.parentNode;
	}
	return cPos;
}

/**
 *          tips    
 * @param x
 * @param y
 * @param width
 * @param height
 * @param bPos
 * @returns {String}
 */
function getTooltipPoints(x,y,width,height,bPos)
{
	var pointstr = "";
	var x1 = x,y1 = y,x2 = (x+width),y2 = y,x3 = x2,y3 = y + height,x4 = x + width/2 + 5,y4 = y3;
	var x5 = bPos.x + bPos.width /2,y5 = y3 + 10,x6=x + width/2-5,y6 = y3,x7=x,y7=y3;
	if(y > bPos.y)
	{
		y5 = y3 - 10;
		return x1+","+y1+ " " +x6+","+y+ " " +x5+","+(y-10)+ " "+x4+","+y+ " " +x2+","+y2+ " " +x3+","+y3+ " "+x7+","+y7;
	}
	else
	{
		return x1+","+y1+ " " +x2+","+y2+ " " +x3+","+y3+ " "+x4+","+y4+ " " + x5+","+y5+ " "+x6+","+y6+ " " + x7+","+y7;
	}
}

/**
 *                 
 *         16      32       16               32           
 */
function calcPortListBarPostion(portNum)
{
	var width = SHOW_BOARD_WIDTH;
	PORT_MAX_NUMBER_COLUMN = PORT_MAX_NUMBER_COLUMN_BASE;
	if(portNum > PORT_MAX_NUMBER_COLUMN && portNum <= (PORT_MAX_NUMBER_COLUMN*2))
	{
		width = SHOW_BOARD_WIDTH + BAR_WIDTH_DELTA;
	}
	if(portNum > (PORT_MAX_NUMBER_COLUMN*2))
	{
		width = SHOW_BOARD_WIDTH + BAR_WIDTH_DELTA;
		calcPortListBarNum(portNum);
	}
	var bPos = {x:SHOW_BOARD_X, y:SHOW_BOARD_Y, width:width, height:BOARD_HEIGHT};
	
	return bPos;
}

/**
 *                 
 *         16      32       16               32           
 */
function calcPortListBarNum(portNum)
{
	var portLineMaxNum;
	var portNumR = portNum%2;
	if(portNumR == 0)
	{
		portLineMaxNum = portNum/2;
	}else
	{
		portLineMaxNum = (portNum - portNumR)/2 + 1;
	}
	PORT_MAX_NUMBER_COLUMN = portLineMaxNum;
}

/**
 *            
 * @param slotId
 * @returns {___anonymous19577_19606}
 */
function calcAddBoardPostion(slotId, size)
{
	var slot = getSVGElement(SLOT_PREFIX+slotId);
	var pos = getCurrentMoveBoardPoint(slot);
	var x = pos.x + pos.width/2;
	var y = pos.y + pos.height/2;
	if(y >= THRESHOLD_Y)
	{
		if(size < BOARD_NUM_COLUMN)
		{
			y = y - size * ADD_BOARD_HEIGHT;
		}
		else
		{
			y = y - BOARD_NUM_COLUMN * ADD_BOARD_HEIGHT;
		}
	}
	var width = (Math.floor(size / BOARD_NUM_COLUMN) + 1) * ADD_BOARD_WIDTH;
	if(0 == size % BOARD_NUM_COLUMN)
	{
		width = Math.floor(size / BOARD_NUM_COLUMN) * ADD_BOARD_WIDTH;
	}
	
	if((x +width) > $("boardView").width)
	{
		x = $("boardView").width - width;
	}
	
	var height = size * (ADD_BOARD_HEIGHT + 2);
	if(size > BOARD_NUM_COLUMN)
	{
		height = BOARD_NUM_COLUMN * (ADD_BOARD_HEIGHT + 2);
	}
	var bPos = {x:x,y:y,width:width,height:height};

	return bPos;
}

/**
 *                  
 * @param bPos
 * @returns {___anonymous18882_18896}
 */
function calcPortListBarAlmPostion(bPos)
{
	var almPos = {cx:0,cy:0,r:0};

	almPos.r = 10;
	almPos.cx = 30;
	
	almPos.cy = 15;
	
	return almPos;
}

/**
 *      ID        
 * 
 * @param data        
 *            parentid:   ID
 * @return Array:     
 */
function getChildMenuItemList(data, parentid)
{
	var childMenuItemList = [];
	var parent = null;
	var count = 0;
	for ( var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		parent = data.getDataRowParam(i, "parent");
		if (parent == parentid)
		{
			childMenuItemList[count] = data.rows[i];
			count++;
		}
	}
	return childMenuItemList;
}

/**
 *       
 */
function menuItem()
{
    this.displayText = arguments[0];

    this.itemName = "";
    this.actionOnClick = "";
    this.enabled = true;
    var len = arguments.length;
    if (len > 1 && arguments[1].length > 0) 
    {
        this.itemName = arguments[1];
    }
    if (len > 2) 
    {
        this.actionOnClick = arguments[2];
    }
    
    if (len > 3) 
    {
        this.actionParams = arguments[3];
    }
    
    if (len > 4 && typeof(arguments[4]) == "boolean") 
    {
        this.enabled = arguments[4];
    }
}

/*
Add a new menu item to the menu.
Argument:
menuItemObj        : Required. Menu item object that is going to be added to the menu object.
*/
function addMenuItem(menuItemObj, pos)
{ 
	var slotC = createSVGElement("svg");
	slotC.setAttribute("itemobj", JSON.stringify(menuItemObj));
    if (menuItemObj.displayText == "-") 
    {
		pos.height = 1;
	    attr(slotC,{x:pos.x, y:pos.y, width:pos.width, height:pos.height});
        var line = createSVGElement("line");
        attr(line, {x1:0,y1:0,x2:170,y2:0});
        line.setAttribute("class", "splitlinestyle");
	    slotC.appendChild(line);
	    
	    pos.y += pos.height;
    }
    else 
    {
       	var name = menuItemObj.displayText;
    	var strArray = splitString(name, 20);
    	pos.height = 25 + 15 * (strArray.length - 1);
	    attr(slotC,{x:pos.x, y:pos.y, width:pos.width, height:pos.height});
	    var slotElm = createSVGElement("rect");
	    var style = "menustyle";
        if (!menuItemObj.enabled) 
        {
        	style = "menustyledisabled";
        }
        attr(slotElm,{width:"100%",height:"100%"});
		slotElm.setAttribute("class", style);
		slotC.appendChild(slotElm);

      	var slotText = createSVGElement("text");
       	attr(slotText,{x:0,y:15});
       	setFontSize(slotText, 10);
       	var maxLen = 25;
       	for(var i = 0, len = strArray.length; i < len; i++)
    	{
    		var tspan = createSVGElement("tspan");
    		tspan.appendChild(createSVGText(strArray[i]));
    		tspan.setAttribute("x","5");
    		tspan.setAttribute("dy","15");
    		if(i == 0)
    		{
    			tspan.setAttribute("dy","0");
    		}            
    		slotText.appendChild(tspan);
    	}
       	attachSVGEvent(slotC,"mouseover",menu_onmouseover);
       	attachSVGEvent(slotC,"mouseout",menu_onmouseout);
       	attachSVGEvent(slotC,"click",menu_onclick);
       	slotC.appendChild(slotText);
       	
       	pos.y += pos.height;
    }
    
  	return slotC;
}

function menu_onmouseover(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target.parentNode;
	if(target.nodeName.toLowerCase() != "svg")
	{
		target = target.parentNode;
	}
	var childs = target.childNodes;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		if(childs.item(i).nodeName == "rect")
		{
			childs.item(i).setAttribute("class", "menustyleOver");
			break;
		}
	}
}

function menu_onclick(evt)
{ 
    evt = evt ? evt : window.event;
    var target = evt.target.parentNode;
    while(target.nodeName.toLowerCase() != "svg")
    {
    	target = target.parentNode;
    }
    var itemObj = target.getAttribute("itemobj");
    if(null != itemObj)
    {
    	itemObj = JSON.parse(itemObj);
        if (itemObj.enabled && itemObj.actionOnClick) 
        {
            var action = eval(itemObj.actionOnClick);
            if (typeof(action) == "string") 
            {
                if (action.indexOf("link:") == 0) 
                {
                    location.href = action.substr(5);
                }
                else 
                {
                    location.href = action;
                }
            }
            else if (typeof(action) == "function") 
            {
               	action(itemObj.actionParams);
            }
        }
    }
}

function menu_onmouseout(evt)
{
	evt = evt ? evt : window.event;
	var target = evt.target.parentNode;
	var childs = target.childNodes;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		if(childs.item(i).nodeName == "rect")
		{
			childs.item(i).setAttribute("class", "menustyle");
			break;
		}
	}
}

function hfGetEIDFromEvent(evt) {
    var ele = evt.target;
    while (ele != null) {
        var id = ele.id;
        if (id != null) {
            var eid = new HFEID(id);
            eid.bstate = ele.bstate ;
            eid.btype = ele.bdid;
            eid.bname = ele.blabel;
            eid.bslotlist = ele.slotlist;
            eid.issupportsubcard = ele.issupportsubcard;
            eid.supportsubtypes = ele.supportsubtypes;
            if (eid.type != null)
                return eid;
        }
        
        ele = ele.parentNode;
    }
    var eid = new HFEID(id);
    eid.bstate = ele.bstate;
    eid.btype = ele.bdid;
    eid.bname = ele.blabel;
    eid.bslotlist = ele.slotlist;

    return null;
}

function hfClearSelState()
{
	
}

/**
 *            ID     
 * @param slotId
 */
function parseBigSlotId(slotId)
{
	slotId = pInt(slotId);
	var shId = slotId >> 16;
	var ssId = slotId & 0x0000FFFF;
	
	return [shId, ssId];
}

/**
 *           
 * @param arr
 * @returns
 */
function unique(arr)
{
    var a = [],
        o = {},
        i,
        v,
        len = arr.length;

    if (len < 2) {
        return arr;
    }

    for (i = 0; i < len; i++) {
        v = arr[i];
        if (o[v] !== 1) {
            a.push(v);
            o[v] = 1;
        }
    }

    return a;
}

/**
 *                       
 * @param newList
 * @param oldList
 */
function getDeleteSlotList(/*array*/newList, /*array*/oldList)
{
	var obj = new Object();
	var resObj = [];
	for(var i = 0, len = newList.length; i < len; i++)
	{
		obj[newList[i]] = newList[i];
	}
	for(var i = 0, len = oldList.length; i < len; i++)
	{
		if(!obj.hasOwnProperty(oldList[i]))
		{
			resObj.push(oldList[i]);
		}		
	}
	
	return resObj;
}

/**
 *        
 * @param a
 * @param b
 * @returns {Number}
 */
function compareNum(a,b)
{
	return a - b;
}

/**
 *         ASCII    1        2
 * @param s
 * @returns {Number}
 */
function charLen(s) 
{
	var l = 0;
	if('undefined' == s || null == s || '' == s)
	{
		return l;
	}
	var a = s.split("");
	for (var i=0;i<a.length;i++)
	{
	 if (a[i].charCodeAt(0)<299) 
	 {
	  l++;
	 } 
	 else 
	 {
	  l+=2;
	 }
	}
	return l;
} 

/**
 *                    
 * @param s         
 * @param maxLen          1        2 
 * @param wordBreak          
 */
function splitString(/*string*/s, /*num*/maxLen, /*boolean*/wordBreak)
{
	var strArray = [];
	if(typeof(wordBreak) == undefined || null == wordBreak)
	{
		wordBreak = false;
	}
	if(wordBreak)
	{
		
	}
	else
	{
		strArray =  splitStringWithoutBreak(s, maxLen);
	}
	
	return strArray;
}

/**
 *                     
 * @param s
 * @param maxLen
 * @returns {Array}
 */
function splitStringWithoutBreak(/*string*/s, /*num*/maxLen)
{
	var strArray = [];
	var index = 0;
	var scount = 0;
	var dcount = 0;
	if(null == s || "" == s)
	{
		return strArray;
	}
	for(var i = 0, len = s.length; i < len; i++)
	{
		if(s.charCodeAt(i) < 299) 
		{
		    scount++;		   
		} 
		else 
		{
			dcount++;
		}
		if(maxLen == (scount + 2 * dcount))
		{
			var str = s.substring(index, (index + scount + dcount));
			strArray.push(str);
			index += scount + dcount;
			scount = 0;
			dcount = 0;
		}
		else if(maxLen == (scount + 2 * dcount + 1))
		{
			if((i + 1) < len)
			{
				if(s.charCodeAt(i + 1) >= 299)
				{
					var str = s.substring(index, (index + scount + dcount));
					strArray.push(str);
					index += scount + dcount;
					scount = 0;
					dcount = 0;
				}
			}
		}
		if((index + scount + dcount) == len)
		{
			var str = s.substring(index);
			strArray.push(str);
			index += scount + dcount;
			scount = 0;
			dcount = 0;
		}
	}
	
	return strArray;
}

/**
 *                              
 * @param s
 * @param maxLen
 * @returns {Array}
 */
function splitStringWithBreak(/*string*/s, /*num*/maxLen)
{
	var strArray = [];
	var index = 0;
	var count = 0;
	var str = "";
    if("" == s || null == s)
    {
    	return strArray;
    }
    var strs = s.split("");
    for(var i = 0, len = strs.length; i < len; i++)
    {
    	if(count == maxLen)
    	{
    		str = s.substring(index, index + count);
    		strArray.push(str);
    		index += count;
    	}
    	else if(count < maxLen)
    	{
    		
    	}
    	count += strs[i].length;
    }
    currentIndex = s.indexOf("");
    if(len == maxLen)
    {
    	len = 0;
    }

	return strArray;
}

/**
 *         
 * 
 * @param ev
 * @return
 */
function mouseCoords(ev) 
{ 
	if(ev.pageX || ev.pageY)
	{ 
		return {x:ev.pageX, y:ev.pageY}; 
	} 
	return	{ x:ev.clientX + document.body.scrollLeft - document.body.clientLeft,y:ev.clientY + document.body.scrollTop - document.body.clientTop}; 
}


/**
 *     ,      
 */
function showWaitStatus(sleft,stop,sWidth,sHeight)
{
	var sid = "pageLoading";
	var shield = $(sid);
	if(!shield)
	{
		shield = document.createElement("DIV");
		shield.id = sid;
		document.body.appendChild(shield);
	}
	shield.style.position = "absolute";
	var bCorverAll = false;
	if(typeof(sleft) == "undefined")
	{
		sleft = "0";
		bCorverAll = true
	}
	if(typeof(stop) == "undefined")
	{
		stop = "0";
	}
	if(typeof(sWidth) == "undefined")
	{
		sWidth = "100%";
	}
	if(typeof(sHeight) == "undefined")
	{
		sHeight = document.body.scrollHeight + "px";
	}
	shield.style.left = sleft;
	shield.style.top = stop;
	shield.style.width = sWidth;
	shield.style.height = sHeight;
	shield.style.background = "#FFFFFF";
	shield.style.textAlign = "center";
	shield.style.zIndex = "10000";
	if(isIE)
	{
		shield.style.filter = "alpha(opacity=50)" ;
	}
	else
	{
		shield.style.opacity = "0.50";
	}
	if(isIE6)
	{
		var sels = document.getElementsByTagName("select");
		for(var i = 0,len = sels.length;i < len;i++)
		{
			if(sels[i] && sels[i].style.display == "")
			{
				sels[i].style.display = "none";
				sels[i].setAttribute("waitflag","true");
			}
		}
	}
	shield.innerHTML = '<table width="100%" height="100%"><tr><td align="center"><img align="absmiddle" src="../../../../../../images/loading.gif"/></td></tr></table>';
}


/**
 *     ,      
 */
function removeWaitStatus()   
{
	var shield = $("pageLoading");
	if(shield)
	{
		shield.parentNode.removeChild(shield);
	}
	if(isIE6)
	{
		var sels = document.getElementsByTagName("select");
		for(var i = 0,len = sels.length;i < len;i++)
		{
			if(sels[i] && sels[i].style.display == "none" && sels[i].getAttribute("waitflag") == "true")
			{
				sels[i].style.display = "";
				sels[i].setAttribute("waitflag","");
			}
		}
	}
}
