var BOARD_HEIGHT = 247;

var ADD_BOARD_WIDTH = 100;
var ADD_BOARD_HEIGHT = 20;

var TOOLTIP_WIDTH = 90;
var TOOLTIP_HEIGHT = 20;

var BOARD_NAME_FONT_SIZE = 9;
var BOARD_NAME_FONT_SIZE_HOR = 9;

var BOARD_ALARM_R = 5;

var BOARD_ALM_OFFSET = 3;

var BOARD_NUM_COLUMN = 11;

var THRESHOLD_Y = 440;

var SLOT_PREFIX = "o.1.";
var BOARD_PREFIX ="o.2.";
var ALARM_PREFIX =".a";
var BOARD_POSTFIX = ".b";

var ALARM_AREA_PER = 0.1;
var NAME_AREA_PER = 0.3;

var BOARD_COMMON = 0;
var BOARD_STND = 1;
var BOARD_COMP = 2;

var ADD_BOARD_PREFIX = "a.o.";
var ADD_BOARD_POSTFIX = ".a";

var BOARD_ADD_ID = "o.addboard";
var BOARD_DELETE_ID = "o.deleteboard";
var BOARD_MENU_ID = "o.boardmenu";

var isIE = (navigator.userAgent.indexOf("MSIE") > -1);
var isIE9 = (navigator.userAgent.indexOf("MSIE 9.0") > -1);
var isFF = (navigator.userAgent.indexOf("Firefox") > -1);

var UNDEFINED;
var SVG_NS = 'http://www.w3.org/2000/svg';
var svgDoc = null;
var htmlDoc = null;
var boardModelTypeList = [];

/**
 *                                   
 * 
 * @param board
 */
function paintBoard(board)
{
	var slot = getSVGElement(SLOT_PREFIX + board.slotId);
	if(!slot)
	{
		return;
	}
	
	var board_8 = getSVGElement(BOARD_PREFIX + 8);
	var board_17 = getSVGElement(BOARD_PREFIX + 17);
	var board_19 = getSVGElement(BOARD_PREFIX + 19);
	
	if((board.slotId*1 == 19) && (board.boardName == "F5APIU") && board_8 && !board_19)
	{
		return;
	}
	
	if((board_17 && (board_17.textContent == "F5APIU") && ((board.slotId*1 == 18) || (board.slotId*1 == 1))) || (board_19 && (board_19.textContent == "F5APIU") && (board.slotId*1 == 8)))
	{
		return;
	}
	
	if(2 == board.boardState)
	{
		var isShow = isShowPhy(board);
		if(isShow == 1)
		{
			return;
		}
	}
	
	var lastboard = getSVGElement(BOARD_PREFIX + board.slotId);
	if(lastboard)
	{
		var oboard = JSON.parse(lastboard.getAttribute("oboard"));
		if(compareJsonBoard(board,oboard))
		{
			if(currentSelectBoard && currentSelectBoard == lastboard)
			{
				currentSelectBoard = null;
			}
			return;
		}
	}
	
	var oPos = calcBoardPostion(board);
	
	if(((board.slotId*1 == 19) || (board.slotId*1 == 17)) && (board.boardName == "F5APIU"))
	{
		oPos.height = 46;
		oPos.width = 150;
		oPos.x = 40;
		oPos.y = 184;
	}
	
	var bCtn = createSVGElement("svg");
	attr(bCtn,extendObj(oPos,{id:BOARD_PREFIX + board.slotId}));
	bCtn.setAttribute("oboard",JSON.stringify(board));

	attachSVGEvent(bCtn,"click",board_onclick);
	attachSVGEvent(bCtn,"mousemove",board_onmousemove);
	attachSVGEvent(bCtn,"mouseout",board_onmouseout);
	
	var bElm = createSVGElement("rect");
	bElm.setAttribute("id",bCtn.getAttribute("id") + BOARD_POSTFIX);
	bElm.setAttribute("class","SlotPhy");
	bElm.setAttribute("width","100%");
	bElm.setAttribute("height","100%");
	bElm.style.setProperty("fill",getBoardColor(pInt(board.boardState)),"important");
	bCtn.appendChild(bElm);
	bCtn.setAttribute("rectid",bElm.getAttribute("id"));
		
	var alarm = createSVGElement("circle");
	var almPos = calcBoardAlmPostion(oPos);
	attr(alarm,almPos);
	alarm.setAttribute("alarm","1");
	alarm.style.setProperty("stroke","white","important");
	alarm.style.setProperty("fill",getAlarmColor(board.alarmLevel),"important");
	if(2 == board.boardState)
	{
		alarm.setAttribute("display", "none");
	}
	bCtn.appendChild(alarm);
	
	var boardtext = createBoardText(board,oPos,almPos);
	if(boardtext)
	{
		bCtn.appendChild(boardtext);
	}

	slot.parentNode.appendChild(bCtn);
}

/**
*                            
*
*/
function isShowPhy(board)
{
	var isShow = 0;
	var slotID;
	var len;
	var lastboard;
	slotID = board.slotId - 1;
	lastboard = getSVGElement(BOARD_PREFIX + slotID);
	if(lastboard)
	{
		var oboard = JSON.parse(lastboard.getAttribute("oboard"));
		len = oboard.slotList.length
		if(len > 0)
		{
			for(var i = 0;i < len;i++)
			{
				if(board.slotId == oboard.slotList[i])
				{
					isShow = 1;
				}
			}
		}
		
	}
	
	slotID = board.slotId + 1;
	lastboard = getSVGElement(BOARD_PREFIX + slotID);
	if(lastboard)
	{
		var oboard = JSON.parse(lastboard.getAttribute("oboard"));
		len = oboard.slotList.length
		if(len > 0)
		{
			for(var i = 0;i < len;i++)
			{
				if(board.slotId == oboard.slotList[i])
				{
					isShow = 1;
				}
			}
		}
		
	}

}

/**
 *         
 * 
 * @param board
 * @param bPos
 * @param aPos
 * @returns
 */
function createBoardText(/* Object */board,/* Object */bPos,/* Object */aPos)
{
	var boardtext = createSVGElement("text");
	var textPos = {x:0,y:0};

	if(bPos.width < bPos.height)
	{
		textPos.y = aPos.r + aPos.cy;
		var tsize = board.boardName.length;
		if(tsize * BOARD_NAME_FONT_SIZE > bPos.height)
		{
			return;
		}
		wordLen = BOARD_NAME_FONT_SIZE;
		for ( var i = 0; i < tsize; i++)
		{
			var tspan = createSVGElement("tspan");
			var ch = board.boardName.charAt(i);
			tspan.appendChild(createSVGText(ch));
			var x = (bPos.width - wordLen) / 2;
			if("I" == ch)
			{
				x += 2;
			}
			tspan.setAttribute("x", x);
			tspan.setAttribute("dy",wordLen + 1);
			setFontSize(tspan,wordLen);
			boardtext.appendChild(tspan);
		}
	}
	else
	{
		textPos = {x:18,y:((bPos.height - BOARD_NAME_FONT_SIZE_HOR)/2 + BOARD_NAME_FONT_SIZE_HOR )};
		boardtext.appendChild(createSVGText(board.boardName));
		setFontSize(boardtext,BOARD_NAME_FONT_SIZE_HOR);
	}
	attr(boardtext,textPos);
	boardtext.setAttribute("class","boardtext");
	return boardtext;
}

var currentSelectBoard;

var currentSelectPort;

var currentMoveBoard;
/**
 *            
 * 
 * @param evt
 */
function board_onmousemove(evt)
{
	var evt = evt?evt:window.event;
	var target = evt.target;
	var board = getTargetBoard(target);
	
	if(currentMoveBoard && board)
	{
		if(currentMoveBoard.getAttribute("id") == board.getAttribute("id"))
		{
			return;
		}
		var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
		var style;
		if(style == "SlotPhyMove" || style == "SlotPhyMoveInteger")
		{
			rectObject.setAttribute("class","SlotPhy");
		}
	}
	if(board)
	{
		destroyTooltip();
		tooltip = createSVGElement("polygon");
		currentMoveBoard = board;
		var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
		if(rectObject.getAttribute("class") == "SlotPhy")
		{
			rectObject.setAttribute("class","SlotPhyMove");
			if(1 == SYSTEMCONF.getStatus())
			{
				rectObject.setAttribute("class","SlotPhyMoveInteger");
			}
		}
		var boardstr = board.getAttribute("oboard");
		var oBoard = JSON.parse(boardstr)
		var pPos = calcBoardPostion(oBoard);
		pPos.x = pPos.x + pInt(board.parentNode.getAttribute("x"));
		pPos.y = pPos.y + pInt(board.parentNode.getAttribute("y"));
		
		var tx = pPos.x - (TOOLTIP_WIDTH - pPos.width)/2;
		tx = tx < 0?0:tx;
		var ty = pPos.y - (TOOLTIP_HEIGHT + 10);
		if(ty < 0)
		{
			ty = pPos.y + pPos.height + 10;
		}

		if(tx + TOOLTIP_WIDTH > 289)
		{
			tx = 289 - TOOLTIP_WIDTH;
		}
		var points = getTooltipPoints(tx,ty,TOOLTIP_WIDTH,TOOLTIP_HEIGHT,pPos);
		attr(tooltip,{points:points,id:"tooltip1"});
		tooltip.setAttribute("class","SlotTooltip");
		board.parentNode.parentNode.appendChild(tooltip);
		
		var text = createSVGElement("text");
		text.appendChild(createSVGText(oBoard.slotId + "-" + oBoard.boardName));
		attr(text,{x:tx + 5,y:ty + 13,id:"tooltip2"});
		board.parentNode.parentNode.appendChild(text);
	}
}

/**
 *   tip    
 */
function destroyTooltip()
{
	var tooltip = getSVGElement("tooltip1");
	var tooltip2 = getSVGElement("tooltip2");
	if(tooltip)
	{
		tooltip.parentNode.removeChild(tooltip);
		tooltip2.parentNode.removeChild(tooltip2);
	}
}

/**
 *           
 * 
 * @param evt
 */
function board_onmouseout(evt)
{
	var target = evt.target;
	if(currentMoveBoard)
	{
		var cPos = getCurrentMoveBoardPoint(currentMoveBoard);
		if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
			&& evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
		{
			var rectObject = getSVGElement(currentMoveBoard.getAttribute("rectid"));
			var style = rectObject.getAttribute("class");
			if(style == "SlotPhyMove" || style == "SlotPhyMoveInteger")
			{
				rectObject.setAttribute("class","SlotPhy");
			}
			destroyTooltip();
			currentMoveBoard = null;
		}
	}
}

/**
 *         
 * 
 * @param evt
 */
function board_onclick(evt)
{
	destroyShowBoard();
	var evt = evt?evt:window.event;
	var target = evt.target;
	var board = getTargetBoard(target);
	
	if(currentSelectSlot)
	{
		setSlotRectClass(currentSelectSlot,"Slot");
	}
	currentSelectSlot = null;
	if(currentSelectBoard)
	{
		var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
		if(null != ele)
		{			
			ele.setAttribute("class","SlotPhy");
			if(1 == SYSTEMCONF.getStatus())
			{
				ele.setAttribute("class","SlotPhySelectInteger");
			}
		} 
	}
	currentSelectBoard = board;
	var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
	if(null != ele)
	{			
		ele.setAttribute("class","SlotPhySelect");
		if(1 == SYSTEMCONF.getStatus())
		{
			ele.setAttribute("class","SlotPhySelectInteger");
		}
	}
	var boardstr = board.getAttribute("oboard");
	var board = JSON.parse(boardstr);
	currentSelectedBoard = board;
	var slotid = board.slotId;
	currentSelectedSlotId = slotid;
	clickedSlot = slotid;
	if(2 == board.boardState)
	{
		currentSelectSlot = getSVGElement(SLOT_PREFIX + slotid);
		currentSelectedSlotId = slotid;
		querySupportBoard(slotid, true);
	}
	else
	{
		var oPos = calcAddBoardPostion(slotid, 1);
		oPos.width = 100;
		oPos.x += 5;
		var bCtn = createSVGElement("svg");
		attr(bCtn,extendObj(oPos, {id:BOARD_MENU_ID}));

		var bElm = createSVGElement("rect");
		bElm.setAttribute("class","AddSlotViewInteger");
		attr(bElm,{width:"100%",height:"100%"});
		bCtn.appendChild(bElm);
		
		var slotC = createSVGElement("svg");		
		attr(slotC,{x:2,y:1,width:ADD_BOARD_WIDTH,height:ADD_BOARD_HEIGHT, id:BOARD_DELETE_ID});
		slotC.setAttribute("slotId",slotid);
		var slotElm = createSVGElement("rect");
		attr(slotElm,{width:"100%",height:"100%"});
		slotElm.setAttribute("class","AddSlot");
		slotC.appendChild(slotElm);
		var txtcontent = RESOURCE["delete"];				
		var slotText = createSVGElement("text");
		attr(slotText,{x:10,y:(ADD_BOARD_HEIGHT - 5)});
		if(isFF)
		{
			setFontSize(slotText, 10);
		}
		slotText.appendChild(createSVGText(txtcontent));
		
		attachSVGEvent(slotC,"mousemove",delboard_onmousemove);
		attachSVGEvent(slotC,"mouseout",delboard_onmouseout);
		attachSVGEvent(slotC,"click",delbtn_onclick);
		slotC.appendChild(slotText);
		bCtn.appendChild(slotC);
			
		getSVGElement("svgBoardview").appendChild(bCtn);
	}
}

/**
 *                
 */
function destroyShowBoard()
{
	destroyAddBoardTooltip();
	var showSlot = getSVGElement(BOARD_ADD_ID);
	if(showSlot)
	{
		currentMoveAddBoard = null;
		showSlot.parentNode.removeChild(showSlot);
	}
	var showSlot = getSVGElement(BOARD_MENU_ID);
	if(showSlot)
	{
		showSlot.parentNode.removeChild(showSlot);
	}
}

/**
 *                        
 * 
 * @param slotId
 * @return
 */
function getSupportBoard(slotId, boardList)
{
	var rectObject = getSVGElement(SLOT_PREFIX + slotId);
	setSlotRectClass(rectObject,"SlotSelect");
	if(1 == SYSTEMCONF.getStatus())
	{
		setSlotRectClass(rectObject,"SlotSelectInteger");
	}
	paintAddBoard(boardList,slotId);
}

var currentSelectSlot;
/**
 *          
 * 
 * @param evt
 */
function slot_onclick(evt)
{
	var target = evt.target;
	var parentN = target.parentNode;

	if(parentN && parentN.getAttribute("id")
		&& parentN.getAttribute("id").indexOf(SLOT_PREFIX) >= 0)
	{
		if(currentSelectBoard)
		{
			var ele = getSVGElement(currentSelectBoard.getAttribute("rectid"));
			if(null != ele)
			{
				ele.setAttribute("class","SlotPhy");
			}
			currentSelectBoard = null;
		}
		if(currentSelectSlot)
		{
			setSlotRectClass(currentSelectSlot,"Slot");
		}
		currentSelectSlot = parentN;
		var slotId = parentN.getAttribute("id");
		slotId = slotId.substr(SLOT_PREFIX.length);
		currentSelectedSlotId = slotId;

		querySupportBoard(slotId);
	}
}

/**
 *          
 * 
 * @param supportBoard
 * @param slotId
 */
function paintAddBoard(supportBoard,slotId)
{
	destroyShowBoard();
	var boardSize = supportBoard.length;

	var oPos = calcAddBoardPostion(slotId, boardSize);
	var bCtn = createSVGElement("svg");
	var boardList = "";
	attr(bCtn,extendObj(oPos,{id:BOARD_ADD_ID}));

	var bElm = createSVGElement("rect");
	bElm.setAttribute("class","AddSlotView");
	if(1 == SYSTEMCONF.getStatus())
	{
		bElm.setAttribute("class","AddSlotViewInteger");
	}
	attr(bElm,{width:"100%",height:"100%"});
	bCtn.appendChild(bElm);
	for(var rowidx = 0; rowidx < boardSize; rowidx++)
	{
		var addBoard = supportBoard[rowidx];
		boardList = boardList + addBoard.boardType + "," + addBoard.boardName + ";";
		extendObj(addBoard,{slotId:slotId});
		var slotC = createSVGElement("svg");
		var column = Math.floor(rowidx / BOARD_NUM_COLUMN);
	    var x = 2 + column * ADD_BOARD_WIDTH;
		var y = 1 + (rowidx - column * BOARD_NUM_COLUMN) * (ADD_BOARD_HEIGHT + 2);
		
		attr(slotC,{x:x,y:y,width:(ADD_BOARD_WIDTH - 4),height:ADD_BOARD_HEIGHT});
		slotC.setAttribute("addboard",JSON.stringify(addBoard));
		var slotElm = createSVGElement("rect");
		attr(slotElm,{width:"100%",height:"100%"});
		slotElm.setAttribute("class","AddSlot");
		var id = ADD_BOARD_PREFIX + addBoard.boardType;
		var txtcontent = addBoard.boardName;
		if(0 == rowidx && "1" == addBoard.physic)
		{
			id = id + "_0";
			txtcontent = RESOURCE["physicboard"];
		}
		slotElm.setAttribute("id", id);
		slotC.appendChild(slotElm);
		slotC.setAttribute("rectid",slotElm.getAttribute("id"));
		var slotText = createSVGElement("text");
		attr(slotText,{x:10,y:(ADD_BOARD_HEIGHT - 5)});
		if(isFF)
		{
			setFontSize(slotText, 10);
		}
		slotText.appendChild(createSVGText(txtcontent));
		
		attachSVGEvent(slotC,"mousemove",addboard_onmousemove);
		attachSVGEvent(slotC,"mouseout",addboard_onmouseout);
		attachSVGEvent(slotC,"click",addboard_onclick);
		slotC.appendChild(slotText);
		bCtn.appendChild(slotC);
	}
		
	getSVGElement("svgBoardview").appendChild(bCtn);
	if("1" == SYSTEMCONF.getStatus())
	{
		document.location="wrui://queryBoardModelType&" + boardList;
	}
}

/**
 *                           
 * 
 * @param boardType       
 */
function getBoardModelType(boardType)
{
	var result = BOARD_COMMON;
	var boardInfo;
	for(var i = boardModelTypeList.length - 1; i >=0; i--)
	{
		boardInfo = boardModelTypeList[i];
		if(boardInfo.boardType == boardType)
		{
			return boardInfo.modelType;
		}
	}
	return result;
}

/**
 *            
 */
function fillBoardModelType(s_modelTypeList)
{
	boardModelTypeList = [];
	var l_modelTypeList = s_modelTypeList.split(";");
	var boardInfoStr;
	var boardInfoArr;
	var boardInfo;
	for(var i = l_modelTypeList.length - 1; i >=0; i--)
	{
		boardInfoStr = l_modelTypeList[i];
		if(boardInfoStr != "")
		{
			boardInfoArr = boardInfoStr.split(",");
			boardInfo = new Object();
			boardInfo.boardType = pInt(boardInfoArr[0]);
			boardInfo.modelType = pInt(boardInfoArr[1]);
			boardModelTypeList.push(boardInfo);
		}
	}
	
}

/**
 *           Tips     
 * 
 * @param boardName       
 * @param allBoard          
 */
function drawAddBoardMenuTips(rectObject,boardType,boardName)
{
	var textContent;
	var boardModelType;
	if(rectObject.getAttribute("boardModelType"))
	{
		boardModelType = rectObject.getAttribute("boardModelType");
	}
	else
	{
		boardModelType = getBoardModelType(boardType);
		rectObject.setAttribute("boardModelType",boardModelType);
	}
	
	var hasDes = (boardName.indexOf ("(") > -1);
	var modelDes;
	if(boardModelType == BOARD_STND)
	{	
		modelDes = hasDes?" ":"(STND) ";
		textContent = boardName + modelDes + RESOURCE["SimplifiedModel"];
	}
	else if (boardModelType == BOARD_COMP)
	{
		modelDes = hasDes?" ":"(COMP) ";
		textContent = boardName + modelDes + RESOURCE["CompatibleModel"];
	}
	else
	{
		return;
	}
	
	var tooltip = createSVGElement("polygon");
	var pPos = {
            x: pInt(rectObject.getAttribute("x")),
            y: pInt(rectObject.getAttribute("y")),
            width: pInt(rectObject.getAttribute("width")),
            height: pInt(rectObject.getAttribute("height"))
        };

    var tipwidth = getTextWidth(textContent) + 10;
	var tx = pPos.x - (tipwidth - pPos.width)/2;
	tx = tx < 0?0:tx;
	var ty = pPos.y - (TOOLTIP_HEIGHT + 10);
	if(ty < 0)
	{
		ty = pPos.y + pPos.height + 10;
	}
	
	var points = getTooltipPoints(tx, ty, tipwidth, TOOLTIP_HEIGHT, pPos);
	attr(tooltip, {points: points,id: "addboardtooltip1"});
	tooltip.setAttribute("class", "SlotTooltip");
	rectObject.parentNode.appendChild(tooltip);

	var text = createSVGElement("text");
	text.appendChild(createSVGText(textContent));
	attr(text, {x: tx + 5,y: ty + 13,id: "addboardtooltip2"});
	setFontSize(text,10);
	rectObject.parentNode.appendChild(text);
}

function getTextWidth(textContent)
{
    if(SYSTEMCONF.getLanguage() == "zh")
    {
        return textContent.length*10;
    }
    else
    {
        return textContent.length*7;
    }
}

/**
 *         
 * 
 * @param evt
 */
function addboard_onclick(evt)
{
	var target = evt.target;
	var addboard = getTargetObject(target,"addboard");
	var oaddboard = JSON.parse(addboard.getAttribute("addboard"));
	destroyShowBoard();
	currentSelectSlot = null;
	addCard(oaddboard);
}

var currentMoveAddBoard;
function addboard_onmousemove(evt)
{
	var target = evt.target;

	var addboard = getTargetObject(target,"addboard");
	var oaddboard = JSON.parse(addboard.getAttribute("addboard"));
	if(currentMoveAddBoard && addboard)
	{
		if(currentMoveAddBoard.getAttribute("id") == addboard.getAttribute("id"))
		{
			return;
		}
		if(currentMoveAddBoard.getAttribute("rectid") != "")
		{
			destroyAddBoardTooltip();
			var rectObject = getSVGElement(currentMoveAddBoard.getAttribute("rectid"));
			if(rectObject && rectObject.getAttribute("class") == "AddSlotMove")
			{
				rectObject.setAttribute("class","AddSlot");
			}
		}
	}
	currentMoveAddBoard = addboard;
	var rectObject = getSVGElement(currentMoveAddBoard.getAttribute("rectid"));
	if(rectObject.getAttribute("class") == "AddSlot")
	{
		rectObject.setAttribute("class","AddSlotMove");
	}	
	drawAddBoardMenuTips(currentMoveAddBoard,oaddboard.boardType,oaddboard.boardName);
}

/**
 *             tip    
 */
function destroyAddBoardTooltip() {
    var tooltip = getSVGElement("addboardtooltip1");
    var tooltip2 = getSVGElement("addboardtooltip2");
    if (tooltip) {
        tooltip.parentNode.removeChild(tooltip);
        tooltip2.parentNode.removeChild(tooltip2);
    }
}

function addboard_onmouseout(evt)
{
	var target = evt.target;
	if(currentMoveAddBoard)
	{
		if(currentMoveAddBoard.getAttribute("rectid") == "")
		{
			currentMoveAddBoard = null;
            destroyAddBoardTooltip();
			return;
		}
		var cPos = getCurrentMoveBoardPoint(currentMoveAddBoard);
		if(!(evt.clientX >= cPos.x && evt.clientX <= (cPos.x + cPos.width)
			&& evt.clientY >= cPos.y && evt.clientY <=(cPos.y + cPos.height)))
		{
			var rectObject = getSVGElement(currentMoveAddBoard.getAttribute("rectid"));
			if(rectObject.getAttribute("class") == "AddSlotMove")
			{
				rectObject.setAttribute("class","AddSlot");
			}
			currentMoveAddBoard = null;
            destroyAddBoardTooltip();
		}
	}
}

function getTargetObject(target,jsonname,value)
{
	if(target)
	{
		if(target.nodeName == "#document")
		{
			return null;
		}
		if(target.getAttribute(jsonname))
		{
			if((typeof(value) == "undefined" && target.getAttribute(jsonname) != "")
				|| (typeof(value) != "undefined" && target.getAttribute(jsonname) == value))
			{
				return target;
			}
		}
		return getTargetObject(target.parentNode,jsonname,value);
	}
	else
	{
		return target;
	}
}

/**
 *     
 *                   
 * @param addboard
 */
function addCard(addboard)
{
	var slotId = addboard.slotId;
	var boardType = addboard.boardType;
	currentAddBoard = addboard;

    board = currentAddBoard;
    board.boardState = 3;
    board.alarmLevel = 7;
	paintBoard(board);
	
	document.location="wrui://boardPostBegin";
	postAddBoardData(board, 1);
}

/**
 *     
 * 
 * @param slotId
 */
function delCard(slotId)
{
	destroyShowBoard();
	var rectObject = getSVGElement(SLOT_PREFIX + slotId);
	setSlotRectClass(rectObject,"SlotPort");
	var card = getSVGElement(BOARD_PREFIX + slotId);
	var board = JSON.parse(card.getAttribute("oboard"));

	if(null != card)
	{
		card.parentNode.removeChild(card);
	}
	setSlotRectClass(rectObject,"SlotUnselect");
	
	destroyTooltip();

	document.location="wrui://boardPostBegin";
	postAddBoardData(board, 2);
}

function delboard_onmousemove(evt)
{
	var target = evt.target;
	var childs = target.parentNode.childNodes;
	var child;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		child = childs.item(i);
		if("rect" == child.nodeName)
		{
			child.setAttribute("class","AddSlotMove");
			break;
		}
	}		
}

function delboard_onmouseout(evt)
{
	var target = evt.target;
	var childs = target.parentNode.childNodes;
	var child;
	for(var i = 0, len = childs.length; i < len; i++)
	{
		child = childs.item(i);
		if("rect" == child.nodeName)
		{
			child.setAttribute("class","AddSlot");
			break;
		}
	}
}

/**
 *         
 * 
 * @param evt
 */
function delbtn_onclick(evt)
{
	var target = evt.target;
	var slotId = target.parentNode.getAttribute("slotId");
	if('undefined' != slotId && null != slotId && '' != slotId)
	{	
		slotId = pInt(slotId);
		currentSelectBoard = null;
		currentSelectedSlotId = slotId;

		delCard(slotId);
	}
}

/**
 *                 
 * flag:1       2              
 *       '-'         ',   
 * @return
 */
function postAddBoardData(/**object */board, /** number*/flag)
{
	var outStr = "";
	if(typeof(flag) == undefined || null == flag || '' == flag)
	{
		flag = 1;
	}
	if(null != board)
	{
		var slotId = convertSlotToBigSlot(board.slotId);
		var slotListStr = '';
		var slotList = board.slotList;

		outStr = flag + "-" + slotId + "-" + board.boardType;		
	}
   document.location="wrui://postBoardData&" + outStr; 	
}
