loadXMLdoc("../../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../res/subrackres_"+ language +".xml"); //      
var subrackID = getNeProperty(self).subrackID;
var blModify = false;
if(subrackID != null && typeof(subrackID) != "undefined" && subrackID >= 0)
{
	blModify = true;
	document.title = RESOURCE["modifysubrack"];
}
else
{
	document.title = RESOURCE["addsubrack"];
}
var table = new  CTable();
var win = window.dialogArguments;

var NETYPE_9600_U32 = "117";//9600U32     
var NETYPE_9600_U64 = "118";//9600U64     

function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	if(blModify)
	{
		var currentSubrack = win.getSubrack(subrackID);
		var atom = new Atom("span");
		atom.setValue(getNeProperty(self).subrackID);
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		atom = new Atom("span");
		atom.setValue(RESOURCE["TYPE_" + currentSubrack.logicSubrackType]);
		table.addAttrRow("subrackName", RESOURCE["subrackType"], atom);
		atom.element["onchange"] = function()
	    {
	          changeOperation(this);
	    }
		atom = new Atom("hidden");
		atom.setValue(currentSubrack.logicSubrackType);
		table.addAttrRow("subrackType", RESOURCE["subrackType"], atom);
		atom = new Atom("text");
		atom.setValue(currentSubrack.subrackMemo);
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
	    initCrossOption(currentSubrack.logicSubrackType);
		atom = new Atom("select");
        init1588V2(atom, currentSubrack.logicSubrackType);
        table.addAttrRow("1588v2", RESOURCE["title1588v2"], atom)
        
	    var crossTypeXml = createCrossTypeXML();
		loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_QUERY_SHELFCROSSTYPE, "POST", false,queryShelfCrossTypeCallBack, null,"inputdata="+crossTypeXml);
	}
	else
	{
		var atom = new Atom("select");
		var existSubrackIDArr = win.Tab.getAllTabsID();
		for(var i = 1; i <= win.MAX_SUBRACK_NUM; i++)
		{
			if(!existSubrackIDArr.contains(i)) // i       
			{
				atom.addOption(i, i);
			}
		}
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		
	
		atom = new Atom("select");
		table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
		atom.addOption(RESOURCE["TYPE_117"], NETYPE_9600_U32);
		atom.addOption(RESOURCE["TYPE_118"], NETYPE_9600_U64);
		atom.element["onchange"] = function()
	    {
	          changeOperation(this);
	    }
		
		atom = new Atom("text");
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
		initCrossOption(NETYPE_9600_U32);
		atom = new Atom("select");
	    init1588V2(atom, table.getAttrValue("subrackType"));
	    table.addAttrRow("1588v2", RESOURCE["title1588v2"], atom);
	}
	
	document.body.insertBefore(table.getTable(), $("AddTable"));
}


/**
 *           xml  
 */
function createAddXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "memo");
	param.setAttribute("value",subrackMemo);
	row.appendChild(param);
	
	var crossType = table.getAttrValue("crossType");
	var crossCapacity = table.getAttrValue("crossCapacity");	
	param = new tagElement("param"); 
	param.setAttribute("name", "crossType");
	param.setAttribute("value",crossType);
	row.appendChild(param);
	param = new tagElement("param"); 
	param.setAttribute("name", "crossCapacity");
	param.setAttribute("value",crossCapacity);
	row.appendChild(param);

	if (table.getAtom("1588v2") != null && table.getAttrValue("1588v2") != -1)
	{
		param = new tagElement("param");
		param.setAttribute("name", "self1588");
		param.setAttribute("value", table.getAttrValue("1588v2"));
		row.appendChild(param);
    }
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


/**
 *        
 */
function addSubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		win.SHOW_SUBRACK_DIALOG = false;
		xcloseDialog(); //                        
		return;
	}
		
	var subrackID = table.getAttrValue("subrackID"); //          ID
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	if(subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	var existSubrackIDArr = win.Tab.getAllTabsID();
	if(existSubrackIDArr.contains(subrackID)) //          ,     
	{
		alert(RESOURCE["subrackExist"]); //                   
		return;
	}
	
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var addXML = createAddXML(); //        xml
	
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_SUBRACK, "POST", true,addSubrackCallBack, paramArr,"inputdata="+addXML);
}

function doSubrack(btnFlg)
{
	if(blModify)
	{
		modifySubrack(btnFlg);
	}
	else
	{
		addSubrack(btnFlg);
	}
}

/**
 *       
 */
function modifySubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var modifyXML = createAddXML(); //        xml
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_SUBRACK_NAME, "POST", true,modifySubrackCallBack, paramArr,"inputdata="+modifyXML);

}

function modifySubrackCallBack(doc,paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	win.refreshShowAfterModify(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
	}
}

/**
 *             
 */
function addSubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
		
	win.refreshShowAfterAddTab(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		
		var subrackIDAtom = table.getAtom("subrackID").element;
		subrackIDAtom.options.remove(subrackIDAtom.selectedIndex);
		$("okBtn").disabled = false;
		if(subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}


/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}

/**
*           
*/
function cancelBtnAction()
{
	win.SHOW_SUBRACK_DIALOG = false;
	xcloseDialog();//     
}

function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
    
    obj.onkeydown = function()
    {
    	  var letterFlg = forbidSignInput();//      
    	  if(!letterFlg)
    	  {
    	      return letterFlg;
    	  }
    	  var code=event.keyCode!=0?event.keyCode:event.charCode;
    	  if(!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16))
    	  {
    	      $("applyBtn").disabled = false;
    	  }
    }
}

function forbidSignInput()
{
    var key = event.keyCode!=0?event.keyCode:event.charCode;
        
    if(event.shiftKey)
    {
        if(key == 188 || key == 222)//   <       
        {
            return false;
        }
    }
    return true;
}

function initCrossOption(subrackType)
{
	var atom = new Atom("select");
	var crossTypes = SpecialAttrMgr.getNEAttrListValueByType(win.neid,subrackType,"TE_FUNC_OTN_NE_MGR","OTN_ATTR_SUPPORT_SHELFCROSSTYPE");
	if(crossTypes != null && crossTypes.length > 0)
	{
		for(var i = 0,len = crossTypes.length;i < len;i++)
		{
			atom.addOption(RESOURCE["crossType" + crossTypes[i]], crossTypes[i]);
		}
	}
	atom.element["onchange"] = function()
    {
		$("applyBtn").disabled = false;
    }
	table.addAttrRow("crossType",RESOURCE["crossType"], atom);
	
	atom = new Atom("select");
	var crossCapacitys = SpecialAttrMgr.getNEAttrListValueByType(win.neid,subrackType,"TE_FUNC_OTN_NE_MGR","OTN_ATTR_SUPPORT_SHELFCROSSCAPACITY");
	if(crossCapacitys != null && crossCapacitys.length > 0)
	{
		for(var i = 0,len = crossCapacitys.length;i < len;i++)
		{
			atom.addOption(RESOURCE["crossCapacity" + crossCapacitys[i]], crossCapacitys[i]);
		}
	}
	atom.element["onchange"] = function()
    {
		$("applyBtn").disabled = false;		
    }
	table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);
}

function changeOperation(selectOperation)
{
    var selectvalue = selectOperation.value; 
    var atom = table.getAtom("crossCapacity");
    atom.clearOptions();
	var crossCapacitys = SpecialAttrMgr.getNEAttrListValueByType(win.neid,selectvalue,"TE_FUNC_OTN_NE_MGR","OTN_ATTR_SUPPORT_SHELFCROSSCAPACITY");
	if(crossCapacitys != null && crossCapacitys.length > 0)
	{
		for(var i = 0,len = crossCapacitys.length;i < len;i++)
		{
			atom.addOption(RESOURCE["crossCapacity" + crossCapacitys[i]], crossCapacitys[i]);
		}
	}
    
	init1588V2(table.getAtom("1588v2"), table.getAttrValue("subrackType"));
}

function createCrossTypeXML()
{
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	param = new tagElement("param", "opDesc", RESOURCE["QUERY_opDesc"]); 
	row.appendChild(param);
	
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


function queryShelfCrossTypeCallBack(doc)
{
	var data = EncapsulateData(doc); //       
	
	if( data.getSErrorCode() != 0 )
  {
  	return;
  }
	for( var i=0; i<data.getDataRowLength(); i++ )
	{
		var theKey = data.getDataRowParam(i, "licensetype");
		var theVal = data.getDataRowParam(i, "licensecapacity");
		var shelf1588 = data.getDataRowParam(i, "self1588");
	        
		if( theKey == "1" )
		{
			var crsTypeAtom = table.getAtom("crossType");
			if( crsTypeAtom != null )
			{
				crsTypeAtom.setValue(theVal);
			}
		}
		if( theKey == "2" )
		{
			var crsCapcAtom = table.getAtom("crossCapacity");
			if( crsCapcAtom != null )
			{
				crsCapcAtom.setValue(theVal);
			}
		}
		
		var crossMode = data.getDataRowParam(i, "crossMode");
        var crsModeAtom = table.getAtom("crossMode");
		if( crsModeAtom != null )
		{
			crsModeAtom.setValue(crossMode);
		}
		
		if (shelf1588 && shelf1588 != "" && table.getAtom("1588v2") != null) 
	    {
	       table.getAtom("1588v2").setValue(shelf1588);
	    }
	}	
}

function init1588V2(atom, subtrackType)
{
	var  shelf1588Enable = SpecialAttrMgr.isNESupportByType(win.neid,subtrackType,"TE_FUNC_OTN_NE_MGR","OTN_ATTR_SUPPORT_SHELF1588ENABLE");
	atom.clearOptions();
	if (shelf1588Enable) 
    {
		atom.addOption(RESOURCE["ID_ENABLE"], 1);
        atom.addOption(RESOURCE["ID_DISABLE2"], 0);
        atom.element.disabled = false;
    }
	else
	{
		atom.addOption("-", -1);
		atom.element.disabled = true;
	}
}
