loadXMLdoc("../../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../../../../../necommon/res/subrackres_"+ language +".xml"); //      
getResourse("../../../../../../res/validatestring_"+ language +".xml"); //      

var subrackID = getNeProperty(self).subrackID;
var blModify = false;
if(subrackID != null && typeof(subrackID) != "undefined" && subrackID >= 0)
{
	blModify = true;
	document.title = RESOURCE["modifysubrack"];
}
else
{
	document.title = RESOURCE["addsubrack"];
}
var table = new  CTable();
var win = window.dialogArguments;

var SUB_TYPE_9800P18 = 116; //OptiX OSN9800     
var SUB_TYPE_9800P16 = 174; //OptiX OSN9800        

function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	if(blModify)
	{
		var currentSubrack = win.getSubrack(subrackID);
		var atom = new Atom("span");
		atom.setValue(getNeProperty(self).subrackID);
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		atom = new Atom("span");
		atom.setValue(RESOURCE["TYPE_" + currentSubrack.logicSubrackType]);
		table.addAttrRow("subrackName", RESOURCE["subrackType"], atom);
		atom = new Atom("hidden");
		atom.setValue(currentSubrack.logicSubrackType);
		table.addAttrRow("subrackType", RESOURCE["subrackType"], atom);
		atom = new Atom("text");
		atom.setValue(currentSubrack.subrackMemo);
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
		atom = new Atom("select");
        init1588V2(atom, currentSubrack.logicSubrackType);
        table.addAttrRow("1588v2", RESOURCE["title1588v2"], atom);
		if( currentSubrack.logicSubrackType == SUB_TYPE_9800P16)
		{
			var xmldata = create1588V2XML();
			loadXMLdoc("../../../../../../neExlorerServlet?sfid="+ TECMDCODE_QUERY_SHELFCROSSTYPE, "POST", false,query1588V2CallBack, null,"inputdata="+xmldata);
		}
	}
	else
	{
		var atom = new Atom("select");
		var existSubrackIDArr = win.Tab.getAllTabsID();
		for(var i = 1; i <= win.MAX_SUBRACK_NUM; i++)
		{
			if(!existSubrackIDArr.contains(i)) // i       
			{
				atom.addOption(i, i);
			}
		}
		table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
		
	
		atom = new Atom("select");
		table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
		atom.addOption(RESOURCE["TYPE_116"], SUB_TYPE_9800P18);
		atom.addOption(RESOURCE["TYPE_174"], SUB_TYPE_9800P16);
		atom.element.onchange = function()
		{
			init1588V2(table.getAtom("1588v2"), table.getAttrValue("subrackType"));
		}
		atom = new Atom("text");
		atom.element.maxLength = 256;
		checkInputData(atom.element, 256);
		table.addAttrRow("subrackMemo",RESOURCE["subrackMemo"], atom);
		
	    atom = new Atom("select");
	    init1588V2(atom, table.getAttrValue("subrackType"));
	    table.addAttrRow("1588v2", RESOURCE["title1588v2"], atom);
	}
	document.body.insertBefore(table.getTable(), $("AddTable"));
}


/**
 *           xml  
 */
function createAddXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "memo");
	param.setAttribute("value",subrackMemo);
	row.appendChild(param);
    if (table.getAtom("1588v2") != null && table.getAttrValue("1588v2") != -1)
	{
		param = new tagElement("param");
		param.setAttribute("name", "self1588");
		param.setAttribute("value", table.getAttrValue("1588v2"));
		row.appendChild(param);
    }
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


/**
 *        
 */
function addSubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
		
	var subrackID = table.getAttrValue("subrackID"); //          ID
	if(subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	
	if(!checkValidateXMLString(subrackMemo))
	{
		return;
	}
	
	var existSubrackIDArr = win.Tab.getAllTabsID();
	if(existSubrackIDArr.contains(subrackID)) //          ,     
	{
		alert(RESOURCE["subrackExist"]); //                   
		return;
	}
	
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var addXML = createAddXML(); //        xml
	
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_ADD_SUBRACK, "POST", false,addSubrackCallBack, paramArr,"inputdata="+addXML);
}

function doSubrack(btnFlg)
{
	if(blModify)
	{
		modifySubrack(btnFlg);
	}
	else
	{
		addSubrack(btnFlg);
	}
}

/**
 *       
 */
function modifySubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	if(subrackMemo == null)
	{
		alert(RESOURCE["memonotnull"]);
		return;
	}
	if(!checkValidateXMLString(subrackMemo))
	{
		return;
	}
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var modifyXML = createAddXML(); //        xml
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");
	paramArr[2] = table.getAttrValue("subrackMemo");
	paramArr[3] = btnFlg;
	
	loadXMLdoc("../../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_SUBRACK_NAME, "POST", false,modifySubrackCallBack, paramArr,"inputdata="+modifyXML);

}

function modifySubrackCallBack(doc,paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	win.refreshShowAfterModify(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
	}
}

/**
 *             
 */
function addSubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //       
	showErrorDialog(addData); 
	
	if(addData.getSErrorCode() != 0 && addData.getSErrorCode() != 1) //    
	{
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	
	win.refreshShowAfterAddTab(paramArr[0], paramArr[1],paramArr[2]); //      Tab   
	if(paramArr[3] && addData.getSErrorCode() == 0) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		var subrackIDAtom = table.getAtom("subrackID").element;
		subrackIDAtom.options.remove(subrackIDAtom.selectedIndex);
		if(subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}


/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}

/**
*           
*/
function cancelBtnAction()
{
	xcloseDialog();//     
}

function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
    
    obj.onkeydown = function()
    {
    	  var letterFlg = forbidSignInput();//      
    	  if(!letterFlg)
    	  {
    	      return letterFlg;
    	  }
    	  var code=event.keyCode!=0?event.keyCode:event.charCode;
    	  if(!event.shiftKey && !event.ctrlKey && (code <= 36 || code >= 41) && code != 9 || (event.shiftKey && code != 16))
    	  {
    	      $("applyBtn").disabled = false;
    	  }
    }
}

function forbidSignInput()
{
    var key = event.keyCode!=0?event.keyCode:event.charCode;
        
    if(event.shiftKey)
    {
        if(key == 188 || key == 222)//   <       
        {
            return false;
        }
    }
    return true;
}

function init1588V2(atom, subtrackType)
{
	if (compare(win.nePro["neversion"], "5.51.09.13") >= 0) 
    {
    	atom.clearOptions();
    	
    	if (subtrackType == SUB_TYPE_9800P18) //9800P18     
		{
			atom.addOption("-", -1);
			atom.element.disabled = true;
		}
		else // 9800P16    1588V2  
		{
			atom.addOption(RESOURCE["ID_ENABLE"], 1);
        	atom.addOption(RESOURCE["ID_DISABLE2"], 0);
        	atom.element.disabled = false;
		}
    }
}


function create1588V2XML()
{
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType"); //            
	var subrackMemo = table.getAttrValue("subrackMemo"); //            
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	param.setAttribute("value",subrackType);
	row.appendChild(param);
	
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


function query1588V2CallBack(doc)
{
    var data = EncapsulateData(doc); //       
    if (data.getSErrorCode() != 0 && data.getSErrorCode() != 1) 
    {
        return;
    }
    
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var shelf1588 = data.getDataRowParam(i, "self1588");
        
        if (shelf1588 && shelf1588 != "" && table.getAtom("1588v2") != null) 
        {
            table.getAtom("1588v2").setValue(shelf1588);
        }
    }
}
/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	var tempArr = data.getError().rowErrors;
	var size = data.getBErrLength();
	for(var i = 0;i < size;i++)
	{
		var tempObj = tempArr[i].errorObj;
		if(tempObj["subrackID"] != null)
		{
			tempObj["subrackID"] = RESOURCE["subrackID"] + ":" + tempObj["subrackID"];
		}
		if (tempObj["licensetype"] != null && parseInt(tempObj["licensetype"]) == 2)
		{
			tempObj["subrackID"] += "-" + RESOURCE["crossCapacity"];
		}
	}	
	errArr[1] = "subrackID"; //         ID
	openErrPage("../../../../../../page/", data.getError(), errArr);
	errArr = null;
}
