
var sortList = [0];
var expandedNodeList = [];
var pnodeLayerMap = new Object();
var MAX_BLOCKS_PAGE = 18;

var lastSelectedPath = null;

/**
 *      
 * 
 * @param pathObjList
 * @param posX
 * @param style
 *                 0      1         2     3:     
 */
function drawPathTree(pathObjList,style,pageNum)
{
	if(typeof(pageNum) == 'undefined' || '' == pageNum)
	{
		pageNum = 1;
	}
	var pnodeList = getParentNodeList(pathObjList);
	var pnodeLayerMap = getParentNodeIndexLayer(pathObjList, pnodeList);
	var isExpanded = false;
	switch(style)
	{
	case 0:
	    var root = pathObjList[0];
	    sortList = [root.id];
		getSortList(root,pathObjList,pnodeList,sortList);
		isExpanded = true;
		expandedNodeList = pnodeList;
		break;
	case 1:
		sortList = pnodeList;
		isExpanded = false;
		expandedNodeList = [0];
		break;
	case 2:
		sortList = [0];
		expandedNodeList = [];
		break;
	case 3:
		expandedNodeList = pnodeList;
		break;
	default:
		break;				
	}

	var index;
	var opath;
	var num;
	var total = 0;
	var len = sortList.length;
	var layer = 0;
	if(len % MAX_BLOCKS_PAGE == 0)
	{
		total = len / MAX_BLOCKS_PAGE;
	}
	else
	{
		total = Math.floor(len / MAX_BLOCKS_PAGE) + 1;
	}
	if(len > MAX_BLOCKS_PAGE)
	{
		len = MAX_BLOCKS_PAGE;
	}
	for(var i = 0; i < len; i++)
	{
		index = sortList[i];
		opath = getPathByID(pathObjList,index);
		layer = getPathLayer(opath, pnodeList, pnodeLayerMap);
		paintPathView(opath, i, layer, pageNum);
	}
	for(var i = 0; i < len; i++)
	{
		if(0 != style)
		{
			for(var j = 0, jLen = expandedNodeList.length; j < jLen; j++)
			{
				isExpanded = false;
				if(sortList[i] == expandedNodeList[j])
				{
					isExpanded = true;
					break;
				}
			}
		}
		index = sortList[i];
		opath = getPathByID(pathObjList,index);
		drawExpandLabel(opath, pnodeList, isExpanded);
	}

	return total;
}
/*
 *     ID      
 * 
 */
function getPathByID(pathObjList,id)
{
    var path;
  	for(var j = 0, jLen = pathObjList.length; j < jLen; j++)
	{
		if(id ==pathObjList[j].id)
		{
			path = pathObjList[j];
			break;
		}
	}
	return 	path;	
}
/**
 *                   
 * 
 * @param path
 *                   
 * @param num
 *                  
 * @param page
 *               
 * @returns {Boolean}
 */
function paintPathView(path, num, layer, page)
{
	var isContinue = true;
	var pathContainer = getSVGElement("pathView");
	var pathC = createSVGElement("svg");
	attr(pathC,{width:120,height:20,id:"pathviewchild" + path.id});
	pathC.setAttribute("opath",JSON.stringify({pathID:path.pathID,funBlockID:path.funBlockID,funBlockName:path.name,menuID:path.supportMenu,bigPathID:path.bigPathID}));
	attachSVGEvent(pathC, 'click', path_onclick);
	var pathObject = createSVGElement("rect");
	attr(pathObject,{width:"100%",height:"100%"});
	pathObject.setAttribute("class","Slot");
	var color = getPathState(path.usageState);
	if(-1 != path.usageState)
	{
		pathObject.style.setProperty("fill",color,"important");
	}
	if(-1 != path.portStatus)
	{
		color = getPortStateColor(path.portStatus);
		pathObject.style.setProperty("fill",color,"important");
	}
	pathObject.style.setProperty("opacity",'0.7',"important");
	pathC.appendChild(pathObject);

	color = getAlarmColor(path.alarmLevel);
	var rect = createSVGElement("rect");
	attr(rect,{width:20,height:20});
	rect.setAttribute("class","Slot");
	rect.style.setProperty("fill","#EFEFEF","important");
	pathC.appendChild(rect);
	var circle = createSVGElement("circle");
	attr(circle, {cx:10,cy:10,r:5});
	circle.setAttribute("class","Slot");
	circle.style.setProperty("stroke","white","important");
	circle.style.setProperty("fill",color,"important");
	pathC.appendChild(circle);
	
	if(path.loopback && pInt(path.loopback))
	{
		var pPos = {width:20,height:20};
		pathC.appendChild(createLoopback(pPos, pInt(path.loopback)));
	}
	if(1 == path.payload)
	{
		var pPos = {width:120,height:20};
		pathC.appendChild(createPayloadLabel(pPos));
	}
	var pathText = createSVGElement("text");
	attr(pathText,{x:25,y:15});
	if(1 == page && 0 == num)
	{
		var txtcontent = path.name;
		var len = charLen(txtcontent);
		var maxLen = 14;
		if(len > maxLen)
		{
			txtcontent = txtcontent.substring(0,maxLen - 4);
			txtcontent += "...";
		}
		pathText.setAttribute("textcontent",path.name);
		pathText.setAttribute("posY", "100");
		pathText.setAttribute("maxLen", maxLen);
		pathText.appendChild(createSVGText(txtcontent));
		attachSVGEvent(pathText,"mouseover", showPortName);
		attachSVGEvent(pathText,"mouseout", hidePortName);
	}
	else
	{
		pathText.appendChild(createSVGText(path.name));
	}
	pathC.appendChild(pathText);
	setFontSize(pathText,10);
	if(isFF)
	{
		setFontSize(pathText,9);
	}
	var ppath = getSVGElement("pathviewchild" + path.pid);
    var sx = 20 + layer * 15;
	var sy = num * 30;
	var index = num + (page - 1) * MAX_BLOCKS_PAGE;
	if(ppath)
	{
		var px = pInt(ppath.getAttribute("x"));
		var py = pInt(ppath.getAttribute("y"));
		var pheight = pInt(ppath.getAttribute("height"));
		if(sy + 20 > 550)
		{			
			isContinue = false;
		}
		attr(pathC,{x:sx,y:sy});

		px = px + 5;
		py = py + pheight;
		sy = sy + 10;
		var points = ""+px+","+py+" "+px+","+sy+" "+sx+","+sy;
		var paths = createSVGElement("polyline");
		paths.setAttribute("id", "polyline" + path.id);
		paths.setAttribute("points",points);
		paths.setAttribute("class","ShowPathTreeLine");
		pathContainer.appendChild(paths);		
	}
	else
	{
		attr(pathC,{x:sx,y:sy});
	}
	pathC.setAttribute("index",index);
	pathContainer.appendChild(pathC);
	
	if(0 == num)
	{
		var line = getSVGElement("pathViewLine");
		if(null != line)
		{
			var oLayer = pInt(line.getAttribute("layer"));
			var points = line.getAttribute("points");
			var pArray = points.split(" ");
			var pt = pArray[3].split(",");
			var lx = pInt(pt[0]) + (layer - oLayer) * 15;
			points = pArray[0] + " " + pArray[1] + " " + pArray[2] + " " + lx + "," + pt[1];
			line.setAttribute("points", points);
			line.setAttribute("layer", layer);
		}
	}
	return isContinue;
}

/**
 *                
 * 
 * @param opath
 * @param pnodeList
 * @param isExpanded
 */
function drawExpandLabel(opath, pnodeList, isExpanded)
{
	if(typeof(isExpanded) == 'undefined' || "" == isExpanded)
	{
		isExpanded = false;
	}
	var hasChild = false;
    for(var i = 0, len = pnodeList.length; i < len; i++)
    {
    	if(opath.id == pnodeList[i])
    	{
    		hasChild = true;
    		break;
    	}
    }
    if(hasChild)
    {
    	var pathContainer = getSVGElement("pathView");
    	var pathNode = getSVGElement("pathviewchild" + opath.id);
    	if(null != pathNode)
    	{
    		var sx = pInt(pathNode.getAttribute("x"));
    		var sy = pInt(pathNode.getAttribute("y"));
        	pathContainer.appendChild(createCrossElement(sx - 15, sy + 5, opath, isExpanded));
    	}
    }
}

function drawPathPageTip(pos,total,current)
{
	var g = createSVGElement("svg");
	attr(g,extendObj(pos,{width:250,height:20,id:PATH_PAGE_TIP}));			
	var text = createSVGElement("text");
	attr(text,{x:0,y:12}); 
	setFontSize(text,10);
    
	var tspan1 = createSVGElement("tspan");
	attr(tspan1,{dx:20,dy:0,id:"total_page_num"});
	tspan1.appendChild(createSVGText(RESOURCE["total"] + total));
	text.appendChild(tspan1);
	
	var tspan2 = createSVGElement("tspan");
	tspan2.appendChild(createSVGText(RESOURCE["current"]));
    attr(tspan2,{dx:10,dy:0}); 
    text.appendChild(tspan2);

	var tspan3 = createSVGElement("tspan");
	tspan3.appendChild(createSVGText("1"));
	tspan3.setAttribute("id", "current_page_num");
    text.appendChild(tspan3);
   
	g.appendChild(text);
    
	var button1 = createSVGElement("g");
	attr(button1,{id:"button_page_up",total:total,current:current});
	var circle1 = createSVGElement("circle");
	attr(circle1, {cx:170, cy:5, r:10});
	circle1.setAttribute("class", "directioncircle");
	button1.appendChild(circle1);
	var data = "M175,5 L165,5 M170,0 L165,5 170,10";
	var line1 = createSVGElement("path");
	line1.setAttribute("d", data);
	line1.setAttribute("class", "directionline");
	button1.appendChild(line1);
	g.appendChild(button1);
	attachSVGEvent(button1,"click",clickPageUp);
	
	var button2 = createSVGElement("g");
	attr(button2,{id:"button_page_down",total:total,current:current});
	var circle2 = createSVGElement("circle");
	attr(circle2, {cx:195, cy:5, r:10});
	circle2.setAttribute("class", "directioncircle");
	button2.appendChild(circle2);
	data = "M190,5 L200,5 M195,0 L200,5 195,10";
	var line2 = createSVGElement("path");
	line2.setAttribute("d", data);
	line2.setAttribute("class", "directionline");
	button2.appendChild(line2);
	g.appendChild(button2);
	attachSVGEvent(button2,"click",clickPageDown);
	if(total <= 1)
	{
		button1.setAttribute("display", "none");
		button2.setAttribute("display", "none");
	}
	else
	{
		button1.setAttribute("display", "");
		button2.setAttribute("display", "");
	}
	
	getSVGElement("svgBoardview").appendChild(g);
}

/**
 * 
 * @param isExpanded
 *                
 */
function createCrossElement(x,y,path,isExpanded)
{
	if(typeof(isExpanded) == "undefined" || "" == isExpanded)
	{
		isExpanded = false;
	}
	var g = createSVGElement("svg");
	attr(g,{x:x,y:y,width:10,height:10,id:"checkbox" + path.id});
	g.setAttribute("opath",JSON.stringify(extendObj(path,{expanded:isExpanded})));
	var box = createSVGElement("rect");
	attr(box,{x:0,y:0,width:10,height:10});
	box.setAttribute("class","expandbox");
	g.appendChild(box);
	
	var line1 = createSVGElement("line");
	attr(line1,{x1:3,y1:5,x2:7,y2:5,label:"x"});
	line1.setAttribute("class","expandline");
	g.appendChild(line1);

	if(!isExpanded)
	{
		var line2 = createSVGElement("line");
		attr(line2,{x1:5,y1:3,x2:5,y2:7,label:"y"});
		line2.setAttribute("class","expandline");
		g.appendChild(line2);
	}
	attachSVGEvent(g,"click",expandPathTree);
	
	return g;
}

/**
 *               
 * 
 * @param opath
 * @param pathList
 */
function getPathChildIndexs(opath,pathList)
{
	var childList = [];
	if(null != opath || typeof(opath) != 'undefined')
	{
		var id = opath.id;
		var path;
		for(var i = 0, len = pathList.length; i < len; i++)
		{
			path = pathList[i];
			if((path.pid == id) && (path.id != path.pid))
			{
				childList.push(path.id);
			}
		}
	}
	childList.sort(compareNum);
	
	return childList;
}

/**
 *                     0         +1
 */
function getPathLayer(path, pnodeList, pnodeLayerMap)
{
	var layer = -1;
	for(var i = 0, len = pnodeList.length; i < len; i++)
	{
		if(path.id == pnodeList[i])
		{
			layer = pnodeLayerMap[pnodeList[i]];
			break;
		}
	}
	if(-1 == layer)
	{
		for(var i = 0, len = pnodeList.length; i < len; i++)
		{
			if(path.pid == pnodeList[i])
			{
				layer = pnodeLayerMap[pnodeList[i]] + 1;
				break;
			}
		}
	}
	
	return layer;
}

/**
 *           
 * 
 * @param pathList
 */
function getParentNodeIndexLayer(pathList, pnodeList)
{
	var path;
	var root = pathList[0];
	var index;
	var pnodeLayerMap = new Object();
	for(var i = 0, len = pnodeList.length; i < len; i++)
	{
		var layer = 0;
		index = pnodeList[i];
		while(index != root.id)
		{
			path = getPathByID(pathList, index);
			index = path.pid;
			layer++;
		}
		pnodeLayerMap[pnodeList[i]] = layer;
	}
	
	return pnodeLayerMap;
}
/**
 *             
 * 
 * @param evt
 */
function expandPathTree(evt)
{
	var target = evt.target;
	var pnode = target.parentNode;
	var opath = JSON.parse(pnode.getAttribute("opath"));
	var bObj = getSVGElement("checkbox" + opath.id);
	if(null != bObj)
	{
		var expanded = opath.expanded;
		var pathContainer = getSVGElement("pathView");
		if(null != pathContainer)
		{
			var pathList = JSON.parse(pathContainer.getAttribute("opath"));
			var pnodeList = getParentNodeList(pathList);
			var id = opath.id;
			var index = 0;
			for(var i = 0, len = sortList.length; i < len; i++)
			{
				if(id == sortList[i])
				{
					break;
				}
				index++;
			}
			var childNodes = pathContainer.childNodes;
			for(var i = childNodes.length -1; i >= 0; i--)
			{
				pathContainer.removeChild(childNodes.item(i));
			}
			if(!expanded)
			{
				expandedNodeList.push(sortList[index]);
				opath.expanded = true;
				var childs = bObj.childNodes;
				var child;
				for(var i = 0, len = childs.length; i < len; i++)
				{
					child = childs.item(i);
					if("line" == child.nodeName && "y" == child.getAttribute("label"))
					{
						bObj.removeChild(child);
					}
				}
				var childIndexs = getPathChildIndexs(opath, pathList);
				for(var i = 0, len = childIndexs.length; i < len; i++)
				{
					sortList.splice(index + i + 1, 0, childIndexs[i]);
				}
			}
			else
			{
				opath.expanded = false;
				var line = createSVGElement("line");
				attr(line,{x1:5,y1:3,x2:5,y2:7,label:"y"});
				line.setAttribute("class","expandline");
				bObj.appendChild(line);
				
				var childIndexs = [];
				var nList = [];
				for(var i = 0, len = sortList.length; i < len; i++)
				{
					nList.push(getPathByID(pathList,sortList[i]));
				}
				getSortList(opath,nList,pnodeList,childIndexs);

				sortList.splice(index + 1, childIndexs.length);
				var delArry = [id];
				for(var i = 0, len = childIndexs.length; i < len; i++)
				{
					for(var j = 0, jLen = pnodeList.length; j < jLen; j++)
					{
						if(childIndexs[i] == pnodeList[j])
						{
							delArry.push(pnodeList[j]);
							break;
						}
					}
				}
				for(var i = 0, len = delArry.length; i < len; i++)
				{
					for(var j = 0, jLen = expandedNodeList.length; j < jLen; j++)
					{
						if(delArry[i] == expandedNodeList[j])
						{
							expandedNodeList.splice(j,1);
							break;
						}
					}
				}
			}
			var total = 0;
			var len = sortList.length;
			if(len % MAX_BLOCKS_PAGE == 0)
			{
				total = len / MAX_BLOCKS_PAGE;
			}
			else
			{
				total = Math.floor(len / MAX_BLOCKS_PAGE) + 1;
			}
			var g = getSVGElement(PATH_PAGE_TIP);
			if(null != g)
			{
                var pos = {x:0,y:620};
                pos.x = pInt(g.getAttribute("x"));
                var ele = getSVGElement("button_page_up");
                var current = pInt(ele.getAttribute("current"));
                g.parentNode.removeChild(g);
               
    			scrollPageShowPath(current, total);
                drawPathPageTip(pos, total,current);
			}
			bObj.setAttribute("opath", JSON.stringify(opath));		
		}
	}
}

/**
 *        
 */
function clickPageUp(evt)
{
	var target = evt.target;
	var pnode = target.parentNode;
	var total = pnode.getAttribute("total");
	var current = pnode.getAttribute("current");
	if(null != total && "" != total && null != current && "" != current)
	{
		total = pInt(total);
		current = pInt(current);
		current = current + total - 1;
		current = current % total;
		if(current == 0)
		{
			current = total;
		}
		var cele = getSVGElement("current_page_num");
		if(null != cele)
		{
			var childs = cele.childNodes;
			for(var i = 0, len = childs.length; i < len; i++)
			{
				if("#text" == childs[i].nodeName)
				{
					var txt = createSVGText(current);
					cele.replaceChild(txt,childs[i]);
				}
			}
		}
		cele = getSVGElement("button_page_up");
		if(null != cele)
		{
			cele.setAttribute("current", current);
		}
		cele = getSVGElement("button_page_down");
		if(null != cele)
		{
			cele.setAttribute("current", current);
		}
		scrollPageShowPath(current, total);
	}
}

/**
 *        
 */
function clickPageDown(evt)
{
	var target = evt.target;
	var pnode = target.parentNode;
	var total = pnode.getAttribute("total");
	var current = pnode.getAttribute("current");
	if(null != total && "" != total && null != current && "" != current)
	{
		total = pInt(total);
		current = pInt(current);
		current = current + 1;
		if(current > total)
		{
			current = current % total;
			if(0 == current)
			{
				current = total;
			}
		}
		var cele = getSVGElement("current_page_num");
		if(null != cele)
		{
			var childs = cele.childNodes;
			for(var i = 0, len = childs.length; i < len; i++)
			{
				if("#text" == childs[i].nodeName)
				{
					var txt = createSVGText(current);
					cele.replaceChild(txt,childs[i]);
				}
			}
		}
		cele = getSVGElement("button_page_up");
		if(null != cele)
		{
			cele.setAttribute("current", current);
		}
		cele = getSVGElement("button_page_down");
		if(null != cele)
		{
			cele.setAttribute("current", current);
		}
		scrollPageShowPath(current, total);
	}
}

/**
 *     
 * 
 * @param pageNum
 *               (1-totalNum)
 * @param totalNum
 *               
 */
function scrollPageShowPath(pageNum, totalNum)
{
	var ochild = getSVGElement("pathView");
	if(null != ochild)
	{
		var childs = ochild.childNodes;
		for(var i = childs.length - 1; i >= 0; i--)
		{
			ochild.removeChild(childs[i]);
		}
		var startIndex = MAX_BLOCKS_PAGE * (pageNum - 1);
		var endIndex;
		if(pageNum == totalNum)
		{
			endIndex = sortList.length;
		}
		else
		{
			endIndex = MAX_BLOCKS_PAGE * pageNum;
		}

		var portview = JSON.parse(ochild.getAttribute("opath"));
		var pnodeList = getParentNodeList(portview);
		var pnodeLayerMap = getParentNodeIndexLayer(portview, pnodeList);
		var pathList = [];
		var opath;
		var layer = 0;
		var isExpanded = false;
		for(var i = startIndex, len = endIndex; i < len; i++)
		{
			for(var j = 0, jLen = portview.length; j < jLen; j++)
			{
				opath = portview[j];
				if(sortList[i] == opath.id)
				{
					pathList.push(opath);
					break;
				}
			}
		}
		for(var i = 0, len = pathList.length; i < len; i++)
		{
			layer = getPathLayer(pathList[i], pnodeList, pnodeLayerMap);
			paintPathView(pathList[i], i, layer, pageNum);
		}
		for(var i = startIndex, len = endIndex; i < len; i++)
		{
			isExpanded = false;
			for(var j = 0, jLen = expandedNodeList.length; j < jLen; j++)
			{
				if(sortList[i] == expandedNodeList[j])
				{
					isExpanded = true;
					break;
				}
			}
			opath = getPathByID(portview,sortList[i]);
			drawExpandLabel(opath, pnodeList, isExpanded);
		}
	}
}

/**
 * 
 */
function getSortList(opath,pathList,pnodeList,arrayList)
{
	var indexs = getPathChildIndexs(opath, pathList);
	var index;
	for(var i = 0, len = indexs.length; i < len; i++)
	{
		index = indexs[i];
		arrayList.push(index);
		for(var j = 0, jLen = pnodeList.length; j < jLen; j++)
		{
			if(index == pnodeList[j])
			{
				for(var k = 0, kLen = pathList.length; k < kLen; k++)
				{
					if(index == pathList[k].id)
					{
						getSortList(pathList[k],pathList,pnodeList,arrayList);
						break;
					}	
				}
			}
		}
	}
}

function path_onclick(evt)
{
	var target = evt.target;
	var pnode = target.parentNode;
	while(pnode.nodeName.toLowerCase() != "svg" && pnode.nodeType == 1)
	{
		pnode = pnode.parentNode;
	}
	var rect = pnode.firstChild;
	rect.setAttribute("class","SlotSelect");
	if(lastSelectedPath && lastSelectedPath != pnode)
	{
		lastSelectedPath.firstChild.setAttribute("class","Slot");
	}
	lastSelectedPath = pnode;
	if(null != pnode && pnode.getAttribute("opath"))
	{
		hightlightSelectedService();
		var opath = JSON.parse(pnode.getAttribute("opath"));
		var childWin = window.frames["serviceViewBody"];
		if(null != childWin)
		{
			var url = childWin.document.location.href;
			if(url.indexOf("/portmenu.html") > -1)
			{
				childWin.funBlockID = opath.funBlockID;
				childWin.menuIds = opath.menuID;
				childWin.funBlockName = opath.funBlockName;
				if(childWin.refreshFunMenu)
				{
					childWin.refreshFunMenu();
				}			
			}
			menuId = opath.menuID;
			funBlockID = opath.funBlockID;
			funBlockName = opath.funBlockName;
			clickedPath = opath.pathID;
		}				
	}
}

/**
 *              
 * 
 * @returns
 */
function updateBlockNameInter(param)
{
	if(null != param && "" != param)
	{
		var attrs = param.split('-');
		if(neid == pInt(attrs[0]) && convertSlotToBigSlot(clickedSlot) == pInt(attrs[1]))
		{
			var path = getSVGElement("pathviewchild" + attrs[2]);
			if(null != path)
			{
				var childs = path.childNodes;
				var child;
				for(var i = 0, len = childs.length; i < len; i++)
				{
					child = childs.item(i);
					if("text" == child.nodeName)
					{
						break;
					}
				}
				var oldName = child.getAttribute("textcontent");
				var index = oldName.indexOf("(");
				if(index > -1)
				{
					oldName = oldName.substring(0,index);
				}
				var txtcontent = oldName;
				if(attrs[3].length > 0)
				{
					txtcontent += "(" + attrs[3] + ")";
				}
				var content = txtcontent;
				var len = charLen(content);
				var maxLen = 14;
				if(len > maxLen)
				{
					content = content.substring(0,maxLen - 4);
					content += "...";
				}
				child.setAttribute("textcontent",txtcontent);
				child.replaceChild(createSVGText(content),child.firstChild);
				
				var ele = getSVGElement(PORT_COMMENTS_ID);
				if(null != ele)
				{
					child = ele.firstChild.firstChild;
					oldName = child.getAttribute("textcontent");
					index = oldName.indexOf("(");
					if(index > -1)
					{
						oldName = oldName.substring(0,index);
					}
					txtcontent = oldName;
					if(attrs[3].length > 0)
					{
						txtcontent += "(" + attrs[3] + ")";
					}
					content = txtcontent;
					len = charLen(content);
					maxLen = 22;
					if(len > maxLen)
					{
						content = content.substring(0,maxLen - 4);
						content += "...";
					}
					child.replaceChild(createSVGText(RESOURCE["port"] + content),child.firstChild);
					child.setAttribute("textcontent",txtcontent);
				}
				var opath = JSON.parse(path.getAttribute("opath"));
				opath.funBlockName = txtcontent;
				path.setAttribute("opath", JSON.stringify(opath));
				
				var childWin = window.frames["serviceViewBody"];
				if(null != childWin)
				{
					var url = childWin.document.location.href;
					if(url.indexOf("/portmenu.html") > -1)
					{
						childWin.funBlockName = txtcontent;
					}
					switchService('attribute');
				}
			}
		}
	}
}

function createPayloadLabel(/* Object */ oPos)
{
	var pT1 = createSVGElement("path");
	pT1.setAttribute("class","ShowSlotPortLP");
	var data;
	var x1;
	var x2;
	var x3;
	var y1; 
	var y2;
	var y3;
	if(oPos.width > oPos.height)
	{
		x1 = oPos.width - 12;
		x2 = oPos.width - 7;
		x3 = oPos.width;
	}
	else
	{
		x1 = 0;
		x2 = 5;
		x3 = 12;
	}
	y1 = oPos.height - 5;
	y2 = oPos.height;
	y3 = oPos.height - 12;
	data = "M" + x1 + "," + y1 + " L" + x2 + "," + y2 + " " + x3 + "," + y3;
	pT1.setAttribute("d", data);
	
	return pT1;
}
